/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.SaxUnmarshaller;
import org.exolab.castor.xml.schema.reader.SimpleTypeUnmarshaller;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class AttributeUnmarshaller
extends SaxUnmarshaller {
    private SaxUnmarshaller unmarshaller;
    private int depth = 0;
    private AttributeDecl _attribute = null;
    private Schema _schema = null;
    private boolean foundAnnotation = false;
    private boolean foundSimpleType = false;

    public AttributeUnmarshaller(Schema schema, AttributeList attributeList, Resolver resolver) {
        String string;
        this._schema = schema;
        this.setResolver(resolver);
        if (attributeList.getValue("ref") != null) {
            String string2 = "Attribute references are currently not supported.";
            throw new IllegalStateException(string2);
        }
        String string3 = attributeList.getValue("name");
        this._attribute = new AttributeDecl(schema, string3);
        this._attribute.setId(attributeList.getValue("id"));
        this._attribute.setValue(attributeList.getValue("value"));
        String string4 = attributeList.getValue("use");
        if (string4 != null) {
            this._attribute.setUse(string4);
        }
        if ((string = attributeList.getValue("type")) != null) {
            this._attribute.setSimpleTypeReference(string);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }

    public String elementName() {
        return "attribute";
    }

    public void endElement(String string) throws SAXException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("annotation".equals(string)) {
            Annotation annotation = (Annotation)this.unmarshaller.getObject();
            this._attribute.addAnnotation(annotation);
        } else if ("simpleType".equals(string)) {
            SimpleType simpleType = ((SimpleTypeUnmarshaller)this.unmarshaller).getSimpleType();
            this._attribute.setSimpleType(simpleType);
        }
        this.unmarshaller = null;
    }

    public AttributeDecl getAttribute() {
        return this._attribute;
    }

    public Object getObject() {
        return this.getAttribute();
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, attributeList);
            ++this.depth;
            return;
        }
        if ("annotation".equals(string)) {
            if (this.foundAnnotation) {
                this.error("Only one (1) annotation is allowed as a child of an attribute declaration.");
            }
            if (this.foundSimpleType) {
                this.error("An annotation may only appear as the first child of an attribute declaration.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(attributeList);
        } else if ("simpleType".equals(string)) {
            if (this.foundSimpleType) {
                this.error("Only one (1) simpleType is allowed as a child of an attribute declaration.");
            }
            this.foundSimpleType = true;
            this.unmarshaller = new SimpleTypeUnmarshaller(this._schema, attributeList);
        } else {
            this.illegalElement(string);
        }
    }
}

