/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.exolab.castor.util.CmdLineOption;
import org.exolab.castor.util.Messages;

public class CommandLineOptions {
    Vector flags = new Vector();
    Hashtable optionInfo = new Hashtable();
    PrintWriter errorWriter = new PrintWriter(System.out);

    public void addFlag(String string) {
        this.addFlag(string, null, null);
    }

    public void addFlag(String string, String string2) {
        this.addFlag(string, null, string2, false);
    }

    public void addFlag(String string, String string2, String string3) {
        this.addFlag(string, string2, string3, false);
    }

    public void addFlag(String string, String string2, String string3, boolean bl) {
        if (string == null) {
            return;
        }
        this.flags.addElement(string);
        CmdLineOption cmdLineOption = new CmdLineOption(string);
        cmdLineOption.setComment(string3);
        cmdLineOption.setUsageText(string2);
        cmdLineOption.setOptional(bl);
        this.optionInfo.put(string, cmdLineOption);
    }

    public Properties getOptions(String[] stringArray) {
        Properties properties = new Properties();
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("-")) {
                if (string != null) {
                    ((Hashtable)properties).put(string, stringArray[n]);
                    ((Hashtable)properties).put(new Integer(n), stringArray[n]);
                }
                if (!this.flags.contains(string = stringArray[n].substring(1))) {
                    int n2 = 1;
                    while (n2 <= string.length()) {
                        if (this.flags.contains(string.substring(0, n2))) {
                            if (n2 < string.length()) {
                                ((Hashtable)properties).put(string.substring(0, n2), string.substring(n2));
                                break;
                            }
                        } else if (n2 == string.length()) {
                            this.errorWriter.println(Messages.format("misc.invalidCLIOption", "-" + string));
                            this.printUsage(this.errorWriter);
                        }
                        ++n2;
                    }
                }
            } else {
                if (string != null) {
                    ((Hashtable)properties).put(string, stringArray[n]);
                }
                ((Hashtable)properties).put(new Integer(n), stringArray[n]);
                string = null;
            }
            ++n;
        }
        if (string != null) {
            ((Hashtable)properties).put(string, "no value");
        }
        return properties;
    }

    public void printHelp(PrintWriter printWriter) {
        this.printUsage(printWriter);
        printWriter.println();
        if (this.flags.size() > 0) {
            printWriter.println("Flag               Description");
            printWriter.println("----------------------------------------------");
        }
        int n = 0;
        while (n < this.flags.size()) {
            String string = (String)this.flags.elementAt(n);
            CmdLineOption cmdLineOption = (CmdLineOption)this.optionInfo.get(string);
            printWriter.print('-');
            printWriter.print(string);
            printWriter.print(' ');
            int n2 = 17 - string.length();
            while (n2 > 0) {
                printWriter.print(' ');
                --n2;
            }
            printWriter.print(cmdLineOption.getComment());
            printWriter.println();
            ++n;
        }
        printWriter.println();
        printWriter.flush();
    }

    public void printUsage(PrintWriter printWriter) {
        printWriter.println();
        printWriter.print(Messages.message("misc.CLIUsage"));
        int n = 0;
        while (n < this.flags.size()) {
            String string = (String)this.flags.elementAt(n);
            CmdLineOption cmdLineOption = (CmdLineOption)this.optionInfo.get(string);
            if (cmdLineOption.getOptional()) {
                printWriter.print(" [-");
            } else {
                printWriter.print(" -");
            }
            printWriter.print(string);
            String string2 = cmdLineOption.getUsageText();
            if (string2 != null) {
                printWriter.print(' ');
                printWriter.print(string2);
            }
            if (cmdLineOption.getOptional()) {
                printWriter.print(']');
            }
            ++n;
        }
        printWriter.println();
        printWriter.flush();
    }

    public void setComment(String string, String string2) {
        if (string == null) {
            return;
        }
        CmdLineOption cmdLineOption = (CmdLineOption)this.optionInfo.get(string);
        if (cmdLineOption != null) {
            cmdLineOption.setComment(string2);
        }
    }

    public void setOptional(String string, boolean bl) {
        if (string == null) {
            return;
        }
        CmdLineOption cmdLineOption = (CmdLineOption)this.optionInfo.get(string);
        if (cmdLineOption != null) {
            cmdLineOption.setOptional(bl);
        }
    }

    public void setUsageInfo(String string, String string2) {
        if (string == null) {
            return;
        }
        CmdLineOption cmdLineOption = (CmdLineOption)this.optionInfo.get(string);
        if (cmdLineOption != null) {
            cmdLineOption.setUsageText(string2);
        }
    }
}

