/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.exolab.castor.types.OperationNotSupportedException;
import org.exolab.castor.types.RecurringDurationBase;

public class Time
extends RecurringDurationBase {
    private static final boolean DEBUG = false;
    private static final String TIME_FORMAT = "HH:mm:ss.SSS";

    public Time() {
        super("P0Y", "P1D");
    }

    public static Time parse(String string) throws ParseException {
        String string2;
        boolean bl;
        Time time = new Time();
        if (string.endsWith("Z")) {
            string = string.substring(0, string.indexOf("Z"));
        }
        if (string.startsWith("-")) {
            time.setNegative();
        }
        boolean bl2 = bl = (string2 = string.substring(string.length() - 6, string.length())).lastIndexOf("-") != -1 || string2.lastIndexOf("+") != -1;
        if (!bl) {
            string2 = null;
        } else {
            int n = string.lastIndexOf("+") != -1 ? string.lastIndexOf("+") : string.lastIndexOf("-");
            string = string.substring(0, n);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() < 3 && stringTokenizer.countTokens() > 5) {
            throw new ParseException("Bad time format", 11);
        }
        String string3 = stringTokenizer.nextToken();
        if ((string3 = string3.substring(string3.indexOf("T") + 1)).length() != 2) {
            throw new ParseException("Bad hour format", 11);
        }
        try {
            time.setHour(Short.parseShort(string3));
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        string3 = stringTokenizer.nextToken();
        if (string3.length() != 2) {
            throw new ParseException("Bad minute format", 14);
        }
        try {
            time.setMinute(Short.parseShort(string3));
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        string3 = stringTokenizer.nextToken();
        String string4 = "0";
        if (string3.indexOf(".") != -1) {
            string4 = string3.substring(string3.indexOf(".") + 1);
            string3 = string3.substring(0, string3.indexOf("."));
        }
        if (string3.length() != 2) {
            throw new ParseException("Bad second format", 17);
        }
        try {
            time.setSecond(Short.parseShort(string3.substring(0, 2)), Short.parseShort(string4));
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        if (bl) {
            try {
                if (string2.startsWith("-")) {
                    time.setZoneNegative();
                }
            }
            catch (OperationNotSupportedException operationNotSupportedException) {}
            if (string2.length() != 6) {
                throw new ParseException("Bad time zone format", 20);
            }
            try {
                time.setZone(Short.parseShort(string2.substring(1, 3)), Short.parseShort(string2.substring(4, 6)));
            }
            catch (OperationNotSupportedException operationNotSupportedException) {}
        } else {
            time.setUTC();
        }
        string3 = null;
        return time;
    }

    public Date toDate() throws ParseException {
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(TIME_FORMAT);
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "UTC");
        String string = this.toString();
        if (!this.isUTC()) {
            int n = 0;
            n = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            n = this.isZoneNegative() ? -n : n;
            simpleTimeZone.setRawOffset(n);
            simpleTimeZone.setID(TimeZone.getAvailableIDs(n)[0]);
        }
        simpleDateFormat.setTimeZone(simpleTimeZone);
        date = simpleDateFormat.parse(this.toString());
        return date;
    }

    public String toString() {
        String string = null;
        String string2 = null;
        String string3 = null;
        string3 = String.valueOf(this.getHour());
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        string = string3;
        string3 = String.valueOf(this.getMinute());
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        string = String.valueOf(string) + ":" + string3;
        string3 = String.valueOf(this.getSeconds());
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        string = String.valueOf(string) + ":" + string3 + "." + String.valueOf(this.getMilli());
        String string4 = string = this.isNegative() ? "-" + string : string;
        if (!this.isUTC()) {
            string3 = String.valueOf(this.getZoneHour());
            if (string3.length() == 1) {
                string3 = "0" + string3;
            }
            string2 = string3;
            string3 = String.valueOf(this.getZoneMinute());
            if (string3.length() == 1) {
                string3 = "0" + string3;
            }
            string2 = String.valueOf(string2) + ":" + string3;
            string2 = this.isZoneNegative() ? "-" + string2 : "+" + string2;
            string = String.valueOf(string) + string2;
        }
        return string;
    }
}

