/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.exolab.castor.types.OperationNotSupportedException;
import org.exolab.castor.types.RecurringDurationBase;
import org.exolab.castor.types.TimeDuration;
import org.exolab.castor.xml.ValidationException;

public class RecurringDuration
extends RecurringDurationBase {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final boolean DEBUG = false;
    private short _century = 0;
    private short _year = 0;
    private short _month = 0;
    private short _day = 0;

    public RecurringDuration() {
    }

    public RecurringDuration(String string, String string2) {
        super(string, string2);
    }

    public RecurringDuration(String string, String string2, short[] sArray) throws OperationNotSupportedException {
        new RecurringDuration(string, string2);
        if (sArray.length != 10) {
            throw new IllegalArgumentException("Wrong numbers of values");
        }
        this.setValues(sArray);
    }

    public RecurringDuration(TimeDuration timeDuration, TimeDuration timeDuration2) {
        super(timeDuration, timeDuration2);
    }

    public boolean equal(RecurringDuration recurringDuration) throws ValidationException {
        boolean bl = false;
        if (recurringDuration == null) {
            return false;
        }
        if (!this.getPeriod().equals(recurringDuration.getPeriod()) || !this.getDuration().equals(recurringDuration.getDuration())) {
            String string = " Recurring Duration which have different values for the duration and period can not be compared";
            throw new ValidationException(string);
        }
        bl = this.getCentury() == recurringDuration.getCentury();
        bl = bl && this.getYear() == recurringDuration.getYear();
        bl = bl && this.getMonth() == recurringDuration.getMonth();
        bl = bl && this.getDay() == recurringDuration.getDay();
        bl = bl && this.getHour() == recurringDuration.getHour();
        bl = bl && this.getMinute() == recurringDuration.getMinute();
        bl = bl && this.getSeconds() == recurringDuration.getSeconds();
        bl = bl && this.getMilli() == recurringDuration.getMilli();
        boolean bl2 = bl = bl && this.isNegative() == this.isNegative();
        if (!recurringDuration.isUTC()) {
            bl = bl && !this.isUTC();
            bl = bl && this.getZoneHour() == recurringDuration.getZoneHour();
            bl = bl && this.getZoneMinute() == recurringDuration.getZoneMinute();
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (object instanceof RecurringDuration) {
            try {
                return this.equal((RecurringDuration)object);
            }
            catch (ValidationException validationException) {
                validationException.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public short getCentury() {
        return this._century;
    }

    public short getDay() {
        return this._day;
    }

    public short getMonth() {
        return this._month;
    }

    public short[] getValues() {
        short[] sArray = null;
        sArray = new short[10];
        sArray[0] = this.getCentury();
        sArray[1] = this.getYear();
        sArray[2] = this.getMonth();
        sArray[3] = this.getDay();
        sArray[4] = this.getHour();
        sArray[5] = this.getMinute();
        sArray[6] = this.getSeconds();
        sArray[7] = this.getMilli();
        sArray[8] = this.getZoneHour();
        sArray[5] = this.getZoneMinute();
        return sArray;
    }

    public short getYear() {
        return this._year;
    }

    public boolean isGreater(RecurringDuration recurringDuration) throws ValidationException {
        boolean bl = false;
        if (!this.getPeriod().equals(recurringDuration.getPeriod()) || !this.getDuration().equals(recurringDuration.getDuration())) {
            String string = " Recurring Duration which have different values for the duration and period can not be compared";
            throw new ValidationException(string);
        }
        short[] sArray = this.getValues();
        short[] sArray2 = recurringDuration.getValues();
        int n = 0;
        while (!bl && n < sArray.length - 1) {
            boolean bl2 = bl = sArray[n] > sArray2[n];
            if (sArray[n] < sArray2[n]) {
                return false;
            }
            ++n;
        }
        return bl;
    }

    public boolean isLeap() {
        int n = this._century * 100 + this._year;
        boolean bl = n % 4 == 0 && n % 100 != 0;
        bl = bl || n % 400 == 0;
        return bl;
    }

    public static Object parse(String string) throws ParseException {
        return RecurringDuration.parseRecurring(string);
    }

    public static RecurringDuration parseRecurring(String string) throws ParseException {
        String string2;
        boolean bl;
        RecurringDuration recurringDuration = new RecurringDuration();
        if (string.endsWith("Z")) {
            string = string.substring(0, string.indexOf("Z"));
        }
        if (string.startsWith("-")) {
            recurringDuration.setNegative();
        }
        boolean bl2 = bl = ((string2 = string.substring(string.length() - 6, string.length())).lastIndexOf("-") != -1 || string2.lastIndexOf("+") != -1) && string2.lastIndexOf(":") != -1;
        if (!bl) {
            string2 = null;
        } else {
            int n = string.lastIndexOf("+") != -1 ? string.lastIndexOf("+") : string.lastIndexOf("-");
            string = string.substring(0, n);
        }
        if (string.indexOf(84) == -1) {
            throw new ParseException("The 'T' element is required", 0);
        }
        String string3 = string.substring(0, string.indexOf("T"));
        String string4 = string.substring(string.indexOf("T"));
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "-");
        if (stringTokenizer.countTokens() != 3) {
            throw new ParseException(String.valueOf(string) + ": Bad date format", 0);
        }
        try {
            String string5 = stringTokenizer.nextToken();
            if (string5.length() != 4) {
                throw new ParseException(String.valueOf(string) + ":Bad year format", 1);
            }
            recurringDuration.setCentury(Short.parseShort(string5.substring(0, 2)));
            recurringDuration.setYear(Short.parseShort(string5.substring(2, 4)));
            string5 = stringTokenizer.nextToken();
            if (string5.length() != 2) {
                throw new ParseException(String.valueOf(string) + ": Bad month format", 5);
            }
            recurringDuration.setMonth(Short.parseShort(string5));
            string5 = stringTokenizer.nextToken();
            if (string5.length() != 2) {
                throw new ParseException(String.valueOf(string) + ":Bad day format", 8);
            }
            recurringDuration.setDay(Short.parseShort(string5));
            stringTokenizer = new StringTokenizer(string4, ":");
            if (stringTokenizer.countTokens() < 3 && stringTokenizer.countTokens() > 5) {
                throw new ParseException(String.valueOf(string) + ": Bad time format", 11);
            }
            string5 = stringTokenizer.nextToken();
            if ((string5 = string5.substring(string5.indexOf("T") + 1)).length() != 2) {
                throw new ParseException(String.valueOf(string) + ": Bad hour format", 11);
            }
            recurringDuration.setHour(Short.parseShort(string5));
            string5 = stringTokenizer.nextToken();
            if (string5.length() != 2) {
                throw new ParseException(String.valueOf(string) + ": Bad minute format", 14);
            }
            recurringDuration.setMinute(Short.parseShort(string5));
            string5 = stringTokenizer.nextToken();
            String string6 = "0";
            if (string5.indexOf(".") != -1) {
                string6 = string5.substring(string5.indexOf(".") + 1);
                string5 = string5.substring(0, string5.indexOf("."));
            }
            if (string5.length() != 2) {
                throw new ParseException(String.valueOf(string) + ": Bad second format", 17);
            }
            recurringDuration.setSecond(Short.parseShort(string5.substring(0, 2)), Short.parseShort(string6));
            if (bl) {
                if (string2.startsWith("-")) {
                    recurringDuration.setZoneNegative();
                }
                if (string2.length() != 6) {
                    throw new ParseException(String.valueOf(string) + ": Bad time zone format", 20);
                }
                recurringDuration.setZone(Short.parseShort(string2.substring(1, 3)), Short.parseShort(string2.substring(4, 6)));
            } else {
                recurringDuration.isUTC();
            }
            string5 = null;
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        return recurringDuration;
    }

    public void setCentury(short s) {
        String string = "";
        if (s < 0) {
            string = "century : " + s + " must not be a negative value.";
            throw new IllegalArgumentException(string);
        }
        this._century = s;
    }

    public void setDay(short s) throws OperationNotSupportedException {
        String string = "";
        if (s < 1) {
            string = "day : " + s + " is not a correct value.";
            string = String.valueOf(string) + "\n 1<day";
            throw new IllegalArgumentException(string);
        }
        if (this._month == 2) {
            if (this.isLeap()) {
                if (s > 29) {
                    string = "day : " + s + " is not a correct value.";
                    string = String.valueOf(string) + "\n day<30 (leap year and month is february)";
                    throw new IllegalArgumentException(string);
                }
            } else if (s > 28) {
                string = "day : " + s + " is not a correct value.";
                string = String.valueOf(string) + "\n day<30 (not a leap year and month is february)";
                throw new IllegalArgumentException(string);
            }
        } else if (this._month == 4 || this._month == 6 || this._month == 9 || this._month == 11) {
            if (s > 30) {
                string = "day : " + s + " is not a correct value.";
                string = String.valueOf(string) + "\n day<31 ";
                throw new IllegalArgumentException(string);
            }
        } else if (s > 31) {
            string = "day : " + s + " is not a correct value.";
            string = String.valueOf(string) + "\n day<=31 ";
            throw new IllegalArgumentException(string);
        }
        this._day = s;
    }

    public void setMonth(short s) throws OperationNotSupportedException {
        String string = "";
        if (s < 1) {
            string = "month : " + s + " is not a correct value.";
            string = String.valueOf(string) + "\n 1<month<12";
            throw new IllegalArgumentException(string);
        }
        if (s > 12) {
            string = "month : " + s + " is not a correct value.";
            string = String.valueOf(string) + "\n 1<month<12";
            throw new IllegalArgumentException(string);
        }
        this._month = s;
    }

    public void setValues(short[] sArray) throws OperationNotSupportedException {
        this.setCentury(sArray[0]);
        this.setYear(sArray[1]);
        this.setMonth(sArray[2]);
        this.setDay(sArray[3]);
        this.setHour(sArray[4]);
        this.setMinute(sArray[5]);
        this.setSecond(sArray[6], sArray[7]);
        this.setZone(sArray[8], sArray[9]);
    }

    public void setYear(short s) throws OperationNotSupportedException {
        String string = "";
        if (s < 0) {
            string = "year : " + s + " must not be a negative value.";
            throw new IllegalArgumentException(string);
        }
        if (s == 0 && this._century == 0) {
            string = "0000 is not an allowed year";
            throw new IllegalArgumentException(string);
        }
        this._year = s;
    }

    public Date toDate() throws ParseException {
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "UTC");
        if (!this.isUTC()) {
            int n = 0;
            n = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            n = this.isZoneNegative() ? -n : n;
            simpleTimeZone.setRawOffset(n);
            simpleTimeZone.setID(TimeZone.getAvailableIDs(n)[0]);
        }
        simpleDateFormat.setTimeZone(simpleTimeZone);
        date = simpleDateFormat.parse(this.toPrivateString());
        return date;
    }

    private final String toPrivateString() {
        String string;
        String string2 = null;
        String string3 = null;
        string2 = String.valueOf(this._century);
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        if ((string = String.valueOf(this._year)).length() == 1) {
            string = "0" + string;
        }
        string2 = String.valueOf(string2) + string;
        string = String.valueOf(this._month);
        if (string.length() == 1) {
            string = "0" + string;
        }
        string2 = String.valueOf(string2) + "-" + string;
        string = String.valueOf(this._day);
        if (string.length() == 1) {
            string = "0" + string;
        }
        string2 = String.valueOf(string2) + "-" + string;
        string2 = String.valueOf(string2) + "T";
        string = String.valueOf(this.getHour());
        if (string.length() == 1) {
            string = "0" + string;
        }
        string2 = String.valueOf(string2) + string;
        string = String.valueOf(this.getMinute());
        if (string.length() == 1) {
            string = "0" + string;
        }
        string2 = String.valueOf(string2) + ":" + string;
        string = String.valueOf(this.getSeconds());
        if (string.length() == 1) {
            string = "0" + string;
        }
        string2 = String.valueOf(string2) + ":" + string + "." + String.valueOf(this.getMilli());
        String string4 = string2 = this.isNegative() ? "-" + string2 : string2;
        if (!this.isUTC()) {
            string = String.valueOf(this.getZoneHour());
            if (string.length() == 1) {
                string = "0" + string;
            }
            string3 = string;
            string = String.valueOf(this.getZoneMinute());
            if (string.length() == 1) {
                string = "0" + string;
            }
            string3 = String.valueOf(string3) + ":" + string;
            string3 = this.isZoneNegative() ? "-" + string3 : "+" + string3;
            string2 = String.valueOf(string2) + string3;
        }
        string = null;
        string3 = null;
        return string2;
    }

    public String toString() {
        return this.toPrivateString();
    }
}

