/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.exolab.castor.types.OperationNotSupportedException;
import org.exolab.castor.types.TimePeriod;

public class Date
extends TimePeriod {
    private static final boolean DEBUG = false;

    public Date() {
        super("P1D");
        int n = TimeZone.getDefault().getRawOffset();
        if (n < 0) {
            n = -n;
            try {
                super.setZoneNegative();
            }
            catch (OperationNotSupportedException operationNotSupportedException) {}
        }
        short s = (short)(n / 3600000);
        short s2 = (short)((n %= 3600000) / 60000);
        try {
            super.setZone(s, s2);
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
    }

    public Date(java.util.Date date) {
        new Date();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        try {
            this.setCentury((short)(gregorianCalendar.get(1) / 100));
            this.setYear((short)(gregorianCalendar.get(1) % 100));
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        try {
            this.setMonth((short)(gregorianCalendar.get(2) + 1));
            this.setDay((short)gregorianCalendar.get(5));
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
    }

    public static Object parse(String string) throws ParseException {
        return Date.parseDate(string);
    }

    public static Date parseDate(String string) throws ParseException {
        StringTokenizer stringTokenizer;
        Date date = new Date();
        if (string.startsWith("-")) {
            date.setNegative();
        }
        if ((stringTokenizer = new StringTokenizer(string, "-")).countTokens() != 3) {
            throw new ParseException(String.valueOf(string) + ": Bad XML Schema date type format (CCYY-MM-DD)", 0);
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.length() != 4) {
            throw new ParseException(String.valueOf(string) + ": Bad year format", 1);
        }
        date.setCentury(Short.parseShort(string2.substring(0, 2)));
        try {
            date.setYear(Short.parseShort(string2.substring(2, 4)));
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        string2 = stringTokenizer.nextToken();
        if (string2.length() != 2) {
            throw new ParseException(String.valueOf(string) + ": Bad month format", 5);
        }
        try {
            date.setMonth(Short.parseShort(string2));
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        string2 = stringTokenizer.nextToken();
        if (string2.length() != 2) {
            throw new ParseException(String.valueOf(string) + ": Bad day format", 8);
        }
        try {
            date.setDay(Short.parseShort(string2));
        }
        catch (OperationNotSupportedException operationNotSupportedException) {}
        string2 = null;
        return date;
    }

    public void setHour(short s) throws OperationNotSupportedException {
        String string = "In a Date : the hour field must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public void setMinute(short s) throws OperationNotSupportedException {
        String string = "In a Date : the minute field must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public void setSecond(short s, short s2) throws OperationNotSupportedException {
        String string = "In a Date : the second fields must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public void setZone(short s, short s2) throws OperationNotSupportedException {
        String string = "In a Date : the time zone fields must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public void setZoneNegative() throws OperationNotSupportedException {
        String string = "In a Date : the time zone fields must not be changed";
        throw new OperationNotSupportedException(string);
    }

    public String toString() {
        String string;
        String string2 = null;
        string2 = String.valueOf(this.getCentury());
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        if ((string = String.valueOf(this.getYear())).length() == 1) {
            string = "0" + string;
        }
        string2 = String.valueOf(string2) + string;
        string = String.valueOf(this.getMonth());
        if (string.length() == 1) {
            string = "0" + string;
        }
        string2 = String.valueOf(string2) + "-" + string;
        string = String.valueOf(this.getDay());
        if (string.length() == 1) {
            string = "0" + string;
        }
        string2 = String.valueOf(string2) + "-" + string;
        string2 = this.isNegative() ? "-" + string2 : string2;
        return string2;
    }
}

