/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.transaction.xa.Xid;
import org.exolab.castor.jdo.ClassNotPersistenceCapableException;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.jdo.ObjectDeletedException;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.ObjectNotPersistentException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.TransactionAbortedException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.ObjectDeletedWaitingForLockException;
import org.exolab.castor.persist.ObjectLock;
import org.exolab.castor.persist.PersistenceInfoGroup;
import org.exolab.castor.persist.QueryResults;
import org.exolab.castor.persist.spi.PersistenceQuery;
import org.exolab.castor.util.Messages;

public abstract class TransactionContext {
    public static int OBJECT_STATE_TRANSIENT = 0;
    public static int OBJECT_STATE_HOLLOW = 1;
    public static int OBJECT_STATE_READ_ONLY = 2;
    public static int OBJECT_STATE_PERSISTENT = 3;
    public static int OBJECT_STATE_PERSISTENT_NEW = 4;
    public static int OBJECT_STATE_PERSISTENT_DELETED = 5;
    public static int OBJECT_STATE_PERSISTENT_NEW_DELETED = 6;
    private ObjectLock _waitOnLock;
    private final Vector _objects = new Vector();
    private final Hashtable _engineOids = new Hashtable();
    private final Hashtable _readOnlyObjects = new Hashtable();
    private int _status;
    private int _lockTimeout = 30;
    private final Xid _xid;
    private int _txTimeout = 30;
    private ObjectEntry _deletedList;
    private Database _db;
    private boolean _autoStore;

    public TransactionContext(Database database) {
        this._xid = null;
        this._status = 0;
        this._db = database;
    }

    public TransactionContext(Database database, Xid xid) {
        this._xid = xid;
        this._status = 0;
        this._db = database;
    }

    ObjectEntry addObjectEntry(OID oID, Object object) {
        if (oID == null) {
            throw new IllegalArgumentException("oid cannot be null");
        }
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null");
        }
        LockEngine lockEngine = oID.getLockEngine();
        ClassMolder classMolder = oID.getMolder();
        this.removeObjectEntry(object);
        ObjectEntry objectEntry = new ObjectEntry(lockEngine, classMolder, oID, object);
        objectEntry.oid = oID;
        this._objects.addElement(objectEntry);
        Hashtable<OID, ObjectEntry> hashtable = (Hashtable<OID, ObjectEntry>)this._engineOids.get(lockEngine);
        if (hashtable == null) {
            hashtable = new Hashtable<OID, ObjectEntry>();
            this._engineOids.put(lockEngine, hashtable);
        }
        hashtable.put(oID, objectEntry);
        return objectEntry;
    }

    public synchronized void close() throws TransactionAbortedException {
        if (this._status != 0 && this._status != 1) {
            throw new IllegalStateException(Messages.message("persist.missingEnd"));
        }
        try {
            this.closeConnections();
        }
        catch (Exception exception) {
            this._status = 1;
            throw new TransactionAbortedException(Messages.format("persist.nested", exception), exception);
        }
    }

    protected abstract void closeConnections() throws TransactionAbortedException;

    public synchronized void commit() throws TransactionAbortedException {
        if (this._status == 1) {
            throw new TransactionAbortedException("persist.markedRollback");
        }
        if (this._status != 2) {
            throw new IllegalStateException(Messages.message("persist.missingPrepare"));
        }
        try {
            this._status = 8;
            this.commitConnections();
        }
        catch (Exception exception) {
            this._status = 1;
            throw new TransactionAbortedException(Messages.format("persist.nested", exception), exception);
        }
        Enumeration enumeration = this._objects.elements();
        while (enumeration.hasMoreElements()) {
            ObjectEntry objectEntry = (ObjectEntry)enumeration.nextElement();
            if (objectEntry.deleted) {
                objectEntry.engine.forgetObject(this, objectEntry.oid);
                objectEntry.molder.setFieldsNull(objectEntry.object);
            } else {
                if (objectEntry.updateCacheNeeded) {
                    objectEntry.engine.updateCache(this, objectEntry.oid, objectEntry.object);
                }
                objectEntry.engine.releaseLock(this, objectEntry.oid);
            }
            if (objectEntry.molder.getCallback() == null) continue;
            objectEntry.molder.getCallback().releasing(objectEntry.object, true);
        }
        this._objects.removeAllElements();
        this._engineOids.clear();
        this._readOnlyObjects.clear();
        this._status = 3;
    }

    protected abstract void commitConnections() throws TransactionAbortedException;

    public synchronized OID create(LockEngine lockEngine, ClassMolder classMolder, Object object, OID oID) throws DuplicateIdentityException, PersistenceException {
        if (object == null) {
            throw new NullPointerException();
        }
        Object object2 = classMolder.getIdentity(this, object);
        ObjectEntry objectEntry = this.getObjectEntry(object);
        if (this._autoStore && objectEntry != null && objectEntry.object == object) {
            return objectEntry.oid;
        }
        if (objectEntry != null && !objectEntry.deleted) {
            throw new PersistenceException(Messages.format("persist.objectAlreadyPersistent", object.getClass().getName(), objectEntry.oid.getIdentity()));
        }
        OID oID2 = new OID(lockEngine, classMolder, oID, object2);
        objectEntry = this.getObjectEntry(lockEngine, oID2);
        if (object2 != null && objectEntry != null) {
            if (!objectEntry.deleted || objectEntry.object != object) {
                throw new DuplicateIdentityException(Messages.format("persist.duplicateIdentity", object.getClass().getName(), object2));
            }
            if (this._deletedList != null) {
                if (this._deletedList == objectEntry) {
                    this._deletedList = objectEntry.nextDeleted;
                } else {
                    ObjectEntry objectEntry2 = this._deletedList;
                    while (objectEntry2.nextDeleted != null && objectEntry2.nextDeleted != objectEntry) {
                        objectEntry2 = objectEntry2.nextDeleted;
                    }
                    if (objectEntry2.nextDeleted == objectEntry) {
                        objectEntry2.nextDeleted = objectEntry.nextDeleted;
                    } else {
                        throw new PersistenceException(Messages.format("persist.deletedNotFound", object2));
                    }
                }
            }
        }
        try {
            if (classMolder.getCallback() != null) {
                classMolder.getCallback().creating(object, this._db);
            }
            if (objectEntry == null) {
                objectEntry = this.addObjectEntry(oID2, object);
            }
            if ((oID2 = lockEngine.create(this, oID2, object)).getIdentity() == null) {
                throw new IllegalStateException("oid.getIdentity() is null after create!");
            }
            this.removeObjectEntry(object);
            objectEntry = this.addObjectEntry(oID2, object);
            objectEntry.created = true;
            if (classMolder.getCallback() != null) {
                classMolder.getCallback().using(object, this._db);
                classMolder.getCallback().created(object);
            }
            return oID2;
        }
        catch (Exception exception) {
            if (classMolder.getCallback() != null) {
                classMolder.getCallback().releasing(object, false);
            }
            this.removeObjectEntry(object);
            if (exception instanceof DuplicateIdentityException) {
                throw (DuplicateIdentityException)exception;
            }
            if (exception instanceof PersistenceException) {
                throw (PersistenceException)exception;
            }
            throw new PersistenceException(Messages.format("persist.nested", exception));
        }
    }

    public synchronized void delete(Object object) throws ObjectNotPersistentException, LockNotGrantedException, PersistenceException {
        if (object == null) {
            throw new PersistenceException("Object to be deleted is null!");
        }
        ObjectEntry objectEntry = this.getObjectEntry(object);
        if (objectEntry == null) {
            throw new ObjectNotPersistentException(Messages.format("persist.objectNotPersistent", object.getClass().getName()));
        }
        if (objectEntry.deleted) {
            throw new ObjectDeletedException(Messages.format("persist.objectDeleted", object.getClass().getName(), objectEntry.oid.getIdentity()));
        }
        try {
            if (objectEntry.molder.getCallback() != null) {
                objectEntry.molder.getCallback().removing(objectEntry.object);
            }
        }
        catch (Exception exception) {
            throw new PersistenceException(Messages.format("persist.nested", exception));
        }
        try {
            objectEntry.deleted = true;
            objectEntry.engine.softLock(this, objectEntry.oid, this._lockTimeout);
            objectEntry.engine.markDelete(this, objectEntry.oid, object, this._lockTimeout);
            if (this._deletedList == null) {
                this._deletedList = objectEntry;
            } else {
                ObjectEntry objectEntry2 = this._deletedList;
                while (objectEntry2.nextDeleted != null) {
                    objectEntry2 = objectEntry2.nextDeleted;
                }
                objectEntry2.nextDeleted = objectEntry;
            }
            try {
                if (objectEntry.molder.getCallback() != null) {
                    objectEntry.molder.getCallback().removed(objectEntry.object);
                }
            }
            catch (Exception exception) {
                throw new PersistenceException(Messages.format("persist.nested", exception));
            }
        }
        catch (ObjectDeletedException objectDeletedException) {
            this.removeObjectEntry(object);
        }
    }

    public synchronized Object fetch(LockEngine lockEngine, ClassMolder classMolder, Object object, AccessMode accessMode) throws ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        ObjectEntry objectEntry = null;
        if (object == null) {
            throw new PersistenceException("Identities can't be null!");
        }
        OID oID = new OID(lockEngine, classMolder, object);
        if (accessMode == AccessMode.ReadOnly) {
            objectEntry = this.getReadOnlyObjectEntry(oID);
        }
        if (objectEntry == null) {
            objectEntry = this.getObjectEntry(lockEngine, oID);
        }
        if (objectEntry != null) {
            if (objectEntry.engine != lockEngine) {
                throw new PersistenceException(Messages.format("persist.multipleLoad", classMolder.getName(), object));
            }
            if (objectEntry.deleted) {
                return null;
            }
            if (!classMolder.isAssignableFrom(objectEntry.object.getClass())) {
                throw new PersistenceException(Messages.format("persist.typeMismatch", classMolder.getName(), object));
            }
            if (objectEntry.created) {
                return objectEntry.object;
            }
            if (!(accessMode != AccessMode.Exclusive && accessMode != AccessMode.DbLocked || objectEntry.oid.isDbLock())) {
                throw new PersistenceException(Messages.format("persist.lockConflict", classMolder.getName(), object));
            }
            return objectEntry.object;
        }
        return null;
    }

    public ClassLoader getClassLoader() {
        return this._db.getClassLoader();
    }

    public abstract Object getConnection(LockEngine var1) throws PersistenceException;

    public Object getIdentity(Object object) {
        ObjectEntry objectEntry = this.getObjectEntry(object);
        if (objectEntry != null) {
            return objectEntry.oid.getIdentity();
        }
        return null;
    }

    public int getLockTimeout() {
        return this._lockTimeout;
    }

    ObjectEntry getObjectEntry(Object object) {
        Enumeration enumeration = this._objects.elements();
        while (enumeration.hasMoreElements()) {
            ObjectEntry objectEntry = (ObjectEntry)enumeration.nextElement();
            if (objectEntry.object != object) continue;
            return objectEntry;
        }
        return null;
    }

    ObjectEntry getObjectEntry(LockEngine lockEngine, OID oID) {
        Hashtable hashtable = (Hashtable)this._engineOids.get(lockEngine);
        if (hashtable == null) {
            return null;
        }
        return (ObjectEntry)hashtable.get(oID);
    }

    public int getObjectState(Object object) {
        ObjectEntry objectEntry = this.getObjectEntry(object);
        if (objectEntry != null) {
            if (objectEntry.created && !objectEntry.deleted) {
                return OBJECT_STATE_PERSISTENT_NEW;
            }
            if (objectEntry.created && objectEntry.deleted) {
                return OBJECT_STATE_PERSISTENT_NEW_DELETED;
            }
            if (objectEntry.deleted) {
                return OBJECT_STATE_PERSISTENT_DELETED;
            }
            return OBJECT_STATE_PERSISTENT;
        }
        Iterator iterator = this._readOnlyObjects.values().iterator();
        while (iterator.hasNext()) {
            if (object != iterator.next()) continue;
            return OBJECT_STATE_READ_ONLY;
        }
        return OBJECT_STATE_TRANSIENT;
    }

    ObjectEntry getReadOnlyObjectEntry(OID oID) {
        return (ObjectEntry)this._readOnlyObjects.get(oID);
    }

    public PersistenceInfoGroup getScope() {
        return this._db.getScope();
    }

    public int getStatus() {
        return this._status;
    }

    public int getTransactionTimeout() {
        return this._txTimeout;
    }

    ObjectLock getWaitOnLock() {
        return this._waitOnLock;
    }

    protected Xid getXid() {
        return this._xid;
    }

    public boolean isAutoStore() {
        return this._autoStore;
    }

    public boolean isDeleted(Object object) {
        ObjectEntry objectEntry = this.getObjectEntry(object);
        if (objectEntry != null) {
            return objectEntry.deleted;
        }
        return false;
    }

    public boolean isDepended(OID oID, Object object) {
        ObjectEntry objectEntry = this.getObjectEntry(object);
        if (objectEntry == null) {
            return false;
        }
        OID oID2 = objectEntry.oid.getDepends();
        if (oID2 == null) {
            return false;
        }
        return oID2.equals(oID);
    }

    public boolean isOpen() {
        return this._status == 0 || this._status == 1;
    }

    public boolean isPersistent(Object object) {
        ObjectEntry objectEntry = this.getObjectEntry(object);
        return objectEntry != null && !objectEntry.deleted;
    }

    public synchronized Object load(LockEngine lockEngine, ClassMolder classMolder, Object object, AccessMode accessMode) throws ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        ObjectEntry objectEntry = null;
        Object object2 = null;
        if (object == null) {
            throw new PersistenceException("Identities can't be null!");
        }
        OID oID = new OID(lockEngine, classMolder, object);
        if (accessMode == AccessMode.ReadOnly) {
            objectEntry = this.getReadOnlyObjectEntry(oID);
        }
        if (objectEntry == null) {
            objectEntry = this.getObjectEntry(lockEngine, oID);
        }
        if (objectEntry != null) {
            if (objectEntry.engine != lockEngine) {
                throw new PersistenceException(Messages.format("persist.multipleLoad", classMolder.getName(), object));
            }
            if (objectEntry.deleted) {
                throw new ObjectNotFoundException("Object is deleted" + classMolder.getName() + object);
            }
            if (!classMolder.getJavaClass(this._db.getClassLoader()).isAssignableFrom(objectEntry.object.getClass())) {
                throw new PersistenceException(Messages.format("persist.typeMismatch", classMolder.getName(), object));
            }
            if (objectEntry.created) {
                return objectEntry.object;
            }
            if (!(accessMode != AccessMode.Exclusive && accessMode != AccessMode.DbLocked || objectEntry.oid.isDbLock())) {
                throw new PersistenceException(Messages.format("persist.lockConflict", classMolder.getName(), object));
            }
            return objectEntry.object;
        }
        accessMode = classMolder.getAccessMode(accessMode);
        try {
            object2 = classMolder.newInstance(this._db.getClassLoader());
            objectEntry = this.addObjectEntry(oID, object2);
            oID = lockEngine.load(this, oID, object2, accessMode, this._lockTimeout);
            objectEntry = this.removeObjectEntry(object2);
            if (objectEntry == null) {
                throw new IllegalStateException("to be removed after debug");
            }
            objectEntry = this.addObjectEntry(oID, object2);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            this.removeObjectEntry(object2);
            throw objectNotFoundException;
        }
        catch (LockNotGrantedException lockNotGrantedException) {
            this.removeObjectEntry(object2);
            throw lockNotGrantedException;
        }
        catch (ClassNotPersistenceCapableException classNotPersistenceCapableException) {
            this.removeObjectEntry(object2);
            throw new PersistenceException(Messages.format("persist.nested", classNotPersistenceCapableException));
        }
        try {
            if (classMolder.getCallback() != null) {
                classMolder.getCallback().using(object2, this._db);
                classMolder.getCallback().loaded(object2, TransactionContext.toDatabaseAccessMode(accessMode));
            }
        }
        catch (Exception exception) {
            this.release(object2);
            throw new PersistenceException(Messages.format("persist.nested", exception));
        }
        if (accessMode == AccessMode.ReadOnly) {
            this.makeReadOnly(object2);
        }
        return object2;
    }

    void makeReadOnly(Object object) {
        ObjectEntry objectEntry = this.removeObjectEntry(object);
        if (objectEntry == null) {
            throw new IllegalStateException(Messages.format("persist.internal", "Attempt to make read-only object that is not in transaction"));
        }
        this._readOnlyObjects.put(objectEntry.oid, objectEntry);
        objectEntry.engine.releaseLock(this, objectEntry.oid);
    }

    void markDelete(LockEngine lockEngine, Class clazz, Object object) throws LockNotGrantedException, PersistenceException {
        block10: {
            ObjectEntry objectEntry = this.getObjectEntry(lockEngine, new OID(lockEngine, lockEngine.getClassMolder(clazz), object));
            if (objectEntry == null || objectEntry.deleted) break block10;
            try {
                if (objectEntry.molder != null && objectEntry.molder.getCallback() != null) {
                    objectEntry.molder.getCallback().removing(objectEntry.object);
                }
            }
            catch (Exception exception) {
                throw new PersistenceException(Messages.format("persist.nested", exception));
            }
            try {
                objectEntry.deleted = true;
                objectEntry.engine.softLock(this, objectEntry.oid, this._lockTimeout);
                objectEntry.engine.markDelete(this, objectEntry.oid, null, this._lockTimeout);
                if (this._deletedList == null) {
                    this._deletedList = objectEntry;
                } else {
                    ObjectEntry objectEntry2 = this._deletedList;
                    while (objectEntry2.nextDeleted != null) {
                        objectEntry2 = objectEntry2.nextDeleted;
                    }
                    objectEntry2.nextDeleted = objectEntry;
                }
                try {
                    if (objectEntry.molder.getCallback() == null) break block10;
                    objectEntry.molder.getCallback().removed(objectEntry.object);
                }
                catch (Exception exception) {
                    throw new PersistenceException(Messages.format("persist.nested", exception));
                }
            }
            catch (ObjectDeletedException objectDeletedException) {
                this.removeObjectEntry(objectEntry.object);
            }
        }
    }

    public synchronized void markModified(Object object, boolean bl, boolean bl2) {
        ObjectEntry objectEntry = this.getObjectEntry(object);
        if (objectEntry != null) {
            if (bl) {
                objectEntry.updatePersistNeeded = true;
            }
            if (bl2) {
                objectEntry.updateCacheNeeded = true;
            }
            boolean bl3 = bl || bl2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean prepare() throws TransactionAbortedException {
        if (this._status == 1) {
            throw new TransactionAbortedException("persist.markedRollback");
        }
        if (this._status != 0) {
            throw new IllegalStateException(Messages.message("persist.noTransaction"));
        }
        if (this._objects.size() == 0) {
            this._status = 2;
            return false;
        }
        try {
            try {
                ObjectEntry objectEntry;
                Enumeration enumeration;
                Vector<ObjectEntry> vector = new Vector<ObjectEntry>();
                while (this._objects.size() != vector.size()) {
                    Vector<ObjectEntry> vector2 = new Vector<ObjectEntry>();
                    enumeration = this._objects.elements();
                    while (enumeration.hasMoreElements()) {
                        objectEntry = (ObjectEntry)enumeration.nextElement();
                        if (vector.contains(objectEntry)) continue;
                        vector2.addElement(objectEntry);
                    }
                    enumeration = vector2.elements();
                    while (enumeration.hasMoreElements()) {
                        OID oID;
                        objectEntry = (ObjectEntry)enumeration.nextElement();
                        if (!objectEntry.deleted && (oID = objectEntry.engine.preStore(this, objectEntry.oid, objectEntry.object, this._lockTimeout)) != null) {
                            objectEntry.oid = oID;
                            objectEntry.updateCacheNeeded = true;
                        }
                        vector.addElement(objectEntry);
                    }
                }
                enumeration = this._objects.elements();
                while (enumeration.hasMoreElements()) {
                    objectEntry = (ObjectEntry)enumeration.nextElement();
                    if (!objectEntry.deleted && objectEntry.updatePersistNeeded) {
                        objectEntry.engine.store(this, objectEntry.oid, objectEntry.object);
                    }
                    if (objectEntry.deleted || !objectEntry.updateCacheNeeded) continue;
                    objectEntry.engine.softLock(this, objectEntry.oid, this._lockTimeout);
                }
                this._status = 7;
                while (this._deletedList != null) {
                    objectEntry = this._deletedList;
                    this._deletedList = this._deletedList.nextDeleted;
                    objectEntry.engine.delete(this, objectEntry.oid, objectEntry.object);
                }
                this._status = 2;
                boolean bl = true;
                Object var7_7 = null;
                this.closeConnections();
                return bl;
            }
            catch (Exception exception) {
                this._status = 1;
                if (!(exception instanceof TransactionAbortedException)) throw new TransactionAbortedException(Messages.format("persist.nested", exception), exception);
                throw (TransactionAbortedException)exception;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.closeConnections();
            throw throwable;
        }
    }

    public synchronized QueryResults query(LockEngine lockEngine, PersistenceQuery persistenceQuery, AccessMode accessMode) throws QueryException, PersistenceException {
        persistenceQuery.execute(this.getConnection(lockEngine), accessMode);
        return new QueryResults(this, lockEngine, persistenceQuery, accessMode, this._db);
    }

    public synchronized void release(Object object) throws ObjectNotPersistentException, PersistenceException {
        if (object == null) {
            throw new PersistenceException("Object to release lock is null!");
        }
        ObjectEntry objectEntry = this.getObjectEntry(object);
        if (objectEntry == null || objectEntry.deleted) {
            throw new ObjectNotPersistentException(Messages.format("persist.objectNotPersistent", object.getClass().getName().getClass()));
        }
        objectEntry.engine.releaseLock(this, objectEntry.oid);
        this.removeObjectEntry(object);
        if (objectEntry.molder.getCallback() != null) {
            objectEntry.molder.getCallback().releasing(object, false);
        }
    }

    ObjectEntry removeObjectEntry(Object object) {
        int n = this._objects.size();
        int n2 = 0;
        while (n2 < n) {
            ObjectEntry objectEntry = (ObjectEntry)this._objects.elementAt(n2);
            if (objectEntry.object == object) {
                this._objects.removeElementAt(n2);
                ((Hashtable)this._engineOids.get(objectEntry.engine)).remove(objectEntry.oid);
                return objectEntry;
            }
            ++n2;
        }
        return null;
    }

    public synchronized void rollback() {
        ObjectEntry objectEntry;
        if (this._status != 0 && this._status != 2 && this._status != 1) {
            throw new IllegalStateException(Messages.message("persist.noTransaction"));
        }
        this.rollbackConnections();
        Enumeration enumeration = this._objects.elements();
        while (enumeration.hasMoreElements()) {
            objectEntry = (ObjectEntry)enumeration.nextElement();
            if (!objectEntry.deleted) continue;
            objectEntry.deleted = false;
        }
        enumeration = this._objects.elements();
        while (enumeration.hasMoreElements()) {
            objectEntry = (ObjectEntry)enumeration.nextElement();
            try {
                if (objectEntry.created) {
                    objectEntry.engine.revertObject(this, objectEntry.oid, objectEntry.object);
                    objectEntry.engine.forgetObject(this, objectEntry.oid);
                } else {
                    objectEntry.engine.revertObject(this, objectEntry.oid, objectEntry.object);
                    objectEntry.engine.releaseLock(this, objectEntry.oid);
                }
                if (objectEntry.molder.getCallback() == null) continue;
                objectEntry.molder.getCallback().releasing(objectEntry.object, false);
            }
            catch (Exception exception) {}
        }
        this._objects.removeAllElements();
        this._engineOids.clear();
        this._readOnlyObjects.clear();
        while (this._deletedList != null) {
            objectEntry = this._deletedList;
            this._deletedList = objectEntry.nextDeleted;
            objectEntry.nextDeleted = null;
        }
        this._status = 4;
    }

    protected abstract void rollbackConnections();

    public void setAutoStore(boolean bl) {
        this._autoStore = bl;
    }

    public void setLockTimeout(int n) {
        this._lockTimeout = n >= 0 ? n : 0;
    }

    public void setTransactionTimeout(int n) {
        this._txTimeout = n;
    }

    void setWaitOnLock(ObjectLock objectLock) {
        this._waitOnLock = objectLock;
    }

    public synchronized void softLock(Object object, int n) throws LockNotGrantedException, ObjectNotPersistentException {
        if (object == null) {
            throw new ObjectNotPersistentException("Object to acquire lock is null!");
        }
        ObjectEntry objectEntry = this.getObjectEntry(object);
        if (objectEntry == null) {
            throw new ObjectNotPersistentException(Messages.format("persist.objectNotPersistent", object.getClass().getName()));
        }
        if (objectEntry.deleted) {
            throw new ObjectDeletedException(Messages.format("persist.objectDeleted", object.getClass().getName(), objectEntry.oid.getIdentity()));
        }
        try {
            objectEntry.engine.softLock(this, objectEntry.oid, n);
        }
        catch (ObjectDeletedWaitingForLockException objectDeletedWaitingForLockException) {
            this.removeObjectEntry(object);
            throw objectDeletedWaitingForLockException;
        }
        catch (LockNotGrantedException lockNotGrantedException) {
            throw lockNotGrantedException;
        }
    }

    static short toDatabaseAccessMode(AccessMode accessMode) {
        if (accessMode == AccessMode.Shared) {
            return 1;
        }
        if (accessMode == AccessMode.ReadOnly) {
            return 0;
        }
        if (accessMode == AccessMode.DbLocked) {
            return 3;
        }
        if (accessMode == AccessMode.Exclusive) {
            return 2;
        }
        return -1;
    }

    public synchronized OID update(LockEngine lockEngine, ClassMolder classMolder, Object object, OID oID) throws DuplicateIdentityException, ObjectModifiedException, ClassNotPersistenceCapableException, PersistenceException {
        AccessMode accessMode = null;
        if (object == null) {
            throw new NullPointerException();
        }
        Object object2 = classMolder.getActualIdentity(this, object);
        OID oID2 = new OID(lockEngine, classMolder, oID, object2);
        ObjectEntry objectEntry = this.getObjectEntry(lockEngine, oID2);
        if (this._autoStore && objectEntry.object == object) {
            return objectEntry.oid;
        }
        if (objectEntry != null) {
            if (objectEntry.deleted) {
                throw new ObjectDeletedException(Messages.format("persist.objectDeleted", object.getClass(), object2));
            }
            throw new DuplicateIdentityException("update object which is already in the transaction");
        }
        accessMode = classMolder.getAccessMode(accessMode);
        try {
            this.addObjectEntry(oID2, object);
            oID2 = lockEngine.update(this, oID2, object, accessMode, this._lockTimeout);
        }
        catch (ObjectModifiedException objectModifiedException) {
            this.removeObjectEntry(object);
            throw objectModifiedException;
        }
        catch (DuplicateIdentityException duplicateIdentityException) {
            this.removeObjectEntry(object);
            throw new ObjectModifiedException("Object modified and can not be updated!");
        }
        try {
            if (classMolder.getCallback() != null) {
                classMolder.getCallback().using(object, this._db);
                classMolder.getCallback().updated(object);
            }
        }
        catch (Exception exception) {
            this.release(object);
            if (exception instanceof PersistenceException) {
                throw (PersistenceException)exception;
            }
            throw new PersistenceException(exception.getMessage(), exception);
        }
        return oID2;
    }

    public synchronized void writeLock(Object object, int n) throws ObjectNotPersistentException, LockNotGrantedException, PersistenceException {
        if (object == null) {
            throw new PersistenceException("Object to acquire lock is null!");
        }
        ObjectEntry objectEntry = this.getObjectEntry(object);
        if (objectEntry == null) {
            throw new ObjectNotPersistentException(Messages.format("persist.objectNotPersistent", object.getClass().getName()));
        }
        if (objectEntry.deleted) {
            throw new ObjectDeletedException(Messages.format("persist.objectDeleted", object.getClass(), objectEntry.oid.getIdentity()));
        }
        try {
            objectEntry.engine.writeLock(this, objectEntry.oid, n);
        }
        catch (ObjectDeletedException objectDeletedException) {
            this.removeObjectEntry(object);
            throw new ObjectNotPersistentException(Messages.format("persist.objectNotPersistent", object.getClass().getName()));
        }
        catch (LockNotGrantedException lockNotGrantedException) {
            throw lockNotGrantedException;
        }
    }

    static final class ObjectEntry {
        final LockEngine engine;
        final ClassMolder molder;
        final Object object;
        OID oid;
        boolean deleted;
        boolean created;
        boolean updateCacheNeeded;
        boolean updatePersistNeeded;
        ObjectEntry nextDeleted;

        ObjectEntry(LockEngine lockEngine, ClassMolder classMolder, OID oID, Object object) {
            this.engine = lockEngine;
            this.molder = classMolder;
            this.oid = oID;
            this.object = object;
        }
    }
}

