/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dsml.mozilla;

import java.util.Enumeration;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSearchResults;
import org.exolab.castor.dsml.Consumer;
import org.exolab.castor.dsml.Exporter;
import org.exolab.castor.dsml.ImportExportException;
import org.exolab.castor.dsml.mozilla.MozillaConsumer;
import org.exolab.castor.dsml.mozilla.MozillaProducer;
import org.exolab.castor.util.Messages;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;

public class MozillaExporter
extends Exporter {
    private LDAPConnection _conn;

    public MozillaExporter(LDAPConnection lDAPConnection) {
        this._conn = lDAPConnection;
    }

    protected Consumer createConsumer() {
        return new MozillaConsumer();
    }

    public void export(DocumentHandler documentHandler, boolean bl, boolean bl2) throws ImportExportException {
        LDAPSearchResults lDAPSearchResults;
        if (this.getSearchDescriptor() == null) {
            throw new IllegalStateException(Messages.message("dsml.searchDescriptorRequired"));
        }
        String[] stringArray = this.getSearchDescriptor().getReturnAttrs();
        try {
            int n = this.getSearchDescriptor().getScope();
            switch (n) {
                case 0: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 0;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
            }
            lDAPSearchResults = this._conn.search(this.getSearchDescriptor().getBaseDN(), n, this.getSearchDescriptor().getFilter(), stringArray, false);
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() != 32) {
                throw new ImportExportException((Exception)((Object)lDAPException));
            }
            lDAPSearchResults = null;
        }
        try {
            MozillaProducer mozillaProducer = new MozillaProducer(documentHandler, false);
            mozillaProducer.startDocument();
            if (bl) {
                LDAPSchema lDAPSchema = new LDAPSchema();
                lDAPSchema.fetchSchema(this._conn);
                mozillaProducer.produce(lDAPSchema);
            }
            if (lDAPSearchResults != null) {
                mozillaProducer.produce((Enumeration)lDAPSearchResults);
            }
            if (bl2 && this.getImportDescriptor() != null) {
                mozillaProducer.produce(this.getImportDescriptor());
            }
            mozillaProducer.endDocument();
        }
        catch (SAXException sAXException) {
            throw new ImportExportException(sAXException);
        }
        catch (LDAPException lDAPException) {
            throw new ImportExportException((Exception)((Object)lDAPException));
        }
    }
}

