/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dsml;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.exolab.castor.util.Messages;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class ImportDescriptor
extends HandlerBase
implements Serializable {
    private Hashtable _policies = new Hashtable();
    private boolean _insideRoot;

    public void addPolicy(String string, int n) {
        this._policies.put(string, new Integer(n));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endElement(String string) throws SAXException {
        if (string.equals("dsml")) {
            if (!this._insideRoot) throw new SAXException(Messages.format("dsml.closingOutsideRoot", string));
            this._insideRoot = false;
            return;
        } else {
            if (!this._insideRoot) {
                throw new SAXException(Messages.format("dsml.closingOutsideRoot", string));
            }
            if (string.equals("import-policies") || string.equals("import-policy")) return;
            throw new SAXException(Messages.format("dsml.expectingClosingTag", "import-policies", string));
        }
    }

    public int getDirectPolicy(String string) {
        Integer n = (Integer)this._policies.get(string);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public int getPolicy(String string) {
        Integer n = (Integer)this._policies.get(string);
        if (n != null) {
            return n;
        }
        DN dN = new DN(string);
        int n2 = 1;
        while (n2 < dN.size()) {
            string = dN.suffix(n2);
            n = (Integer)this._policies.get(string);
            if (n != null) {
                return n;
            }
            ++n2;
        }
        return 0;
    }

    public Enumeration listDNs() {
        return this._policies.keys();
    }

    public void produce(DocumentHandler documentHandler) throws SAXException {
        AttributeListImpl attributeListImpl = new AttributeListImpl();
        documentHandler.startElement("dsml", attributeListImpl);
        attributeListImpl = new AttributeListImpl();
        documentHandler.startElement("import-policies", attributeListImpl);
        Enumeration enumeration = this.listDNs();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n = this.getDirectPolicy(string);
            attributeListImpl = new AttributeListImpl();
            attributeListImpl.addAttribute("dn", "ID", string);
            if ((n & 1) != 0) {
                attributeListImpl.addAttribute("delete-empty", null, "true");
            }
            if ((n & 2) != 0) {
                attributeListImpl.addAttribute("replace-attr", null, "true");
            }
            if ((n & 4) != 0) {
                attributeListImpl.addAttribute("refresh-only", null, "true");
            }
            if ((n & 0x10) != 0) {
                attributeListImpl.addAttribute("update-only", null, "true");
            }
            if ((n & 8) != 0) {
                attributeListImpl.addAttribute("new-attr-only", null, "true");
            }
            documentHandler.startElement("import-policy", attributeListImpl);
            documentHandler.endElement("import-policy");
        }
        documentHandler.endElement("import-policies");
        documentHandler.endElement("dsml");
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (string.equals("dsml")) {
            if (this._insideRoot) {
                throw new SAXException(Messages.format("dsml.elementNested", "dsml"));
            }
            this._insideRoot = true;
        } else {
            if (!this._insideRoot) {
                throw new SAXException(Messages.format("dsml.expectingOpeningTag", "dsml", string));
            }
            if (!string.equals("import-policies")) {
                if (string.equals("import-policy")) {
                    String string2 = attributeList.getValue("dn");
                    if (string2 == null) {
                        throw new SAXException(Messages.format("dsml.missingAttribute", "import-policy", "dn"));
                    }
                    int n = 0;
                    if ("true".equals(attributeList.getValue("delete-empty"))) {
                        n |= 1;
                    }
                    if ("true".equals(attributeList.getValue("refresh-only"))) {
                        n |= 4;
                    }
                    if ("true".equals(attributeList.getValue("replace-attr"))) {
                        n |= 2;
                    }
                    if ("true".equals(attributeList.getValue("new-attr-only"))) {
                        n |= 8;
                    }
                    if ("true".equals(attributeList.getValue("update-only"))) {
                        n |= 0x10;
                    }
                    this.addPolicy(string2, n);
                } else {
                    throw new SAXException(Messages.format("dsml.expectingOpeningTag", "import-policies", string));
                }
            }
        }
    }

    public static class Policy {
        public static final int DeleteEmpty = 1;
        public static final int ReplaceAttr = 2;
        public static final int RefreshOnly = 4;
        public static final int NewAttrOnly = 8;
        public static final int UpdateOnly = 16;
        public static final int DefaultPolicy = 0;
    }

    static class Names {
        Names() {
        }

        static class Element {
            public static final String Policies = "import-policies";
            public static final String Policy = "import-policy";

            Element() {
            }
        }

        static class Attribute {
            public static final String DN = "dn";
            public static final String DeleteEmpty = "delete-empty";
            public static final String ReplaceAttr = "replace-attr";
            public static final String RefreshOnly = "refresh-only";
            public static final String UpdateOnly = "update-only";
            public static final String NewAttrOnly = "new-attr-only";

            Attribute() {
            }
        }
    }

    static class DN {
        private String[] _names;

        DN(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            this._names = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this._names[n] = stringTokenizer.nextToken();
                ++n;
            }
        }

        int size() {
            return this._names.length;
        }

        String suffix(int n) {
            StringBuffer stringBuffer = new StringBuffer(this._names[n]);
            ++n;
            while (n < this._names.length) {
                stringBuffer.append(',').append(this._names[n]);
                ++n;
            }
            return stringBuffer.toString();
        }
    }
}

