/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.math.BigDecimal;
import org.exolab.castor.builder.ClassInfo;
import org.exolab.castor.builder.CollectionInfo;
import org.exolab.castor.builder.FieldInfo;
import org.exolab.castor.builder.types.XSCData;
import org.exolab.castor.builder.types.XSClass;
import org.exolab.castor.builder.types.XSDecimal;
import org.exolab.castor.builder.types.XSFloat;
import org.exolab.castor.builder.types.XSInt;
import org.exolab.castor.builder.types.XSInteger;
import org.exolab.castor.builder.types.XSList;
import org.exolab.castor.builder.types.XSLong;
import org.exolab.castor.builder.types.XSReal;
import org.exolab.castor.builder.types.XSRecurringDuration;
import org.exolab.castor.builder.types.XSString;
import org.exolab.castor.builder.types.XSTime;
import org.exolab.castor.builder.types.XSTimeDuration;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.builder.util.DescriptorJClass;
import org.exolab.castor.types.RecurringDuration;
import org.exolab.castor.types.TimeDuration;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class DescriptorSourceFactory {
    private static JClass _ClassDescriptorClass = new JClass("org.exolab.castor.mapping.ClassDescriptor");
    private static JClass _FieldDescriptorClass = new JClass("org.exolab.castor.mapping.FieldDescriptor");
    private static JClass fdImplClass = new JClass("org.exolab.castor.xml.util.XMLFieldDescriptorImpl");
    private static JClass fdClass = new JClass("org.exolab.castor.xml.XMLFieldDescriptor");
    private static JType fdArrayClass = fdClass.createArray();
    private static JClass gvrClass = new JClass("org.exolab.castor.xml.GroupValidationRule");
    private static JClass vrClass = new JClass("org.exolab.castor.xml.ValidationRule");

    private static String classType(JType jType) {
        if (jType.isPrimitive()) {
            if (jType == JType.Int) {
                return "java.lang.Integer.TYPE";
            }
            if (jType == JType.Double) {
                return "java.lang.Double.TYPE";
            }
            if (jType == JType.Boolean) {
                return "java.lang.Boolean.TYPE";
            }
        }
        return String.valueOf(jType.toString()) + ".class";
    }

    private static void createDescriptor(FieldInfo fieldInfo, String string, String string2, JSourceCode jSourceCode) {
        String string3;
        XSType xSType = fieldInfo.getSchemaType();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = fieldInfo.getNodeType() == 2;
        boolean bl4 = fieldInfo.getNodeType() == 0;
        boolean bl5 = fieldInfo.getNodeType() == 3;
        jSourceCode.add("//-- ");
        jSourceCode.append(fieldInfo.getName());
        if (fieldInfo.getName().equals("_anyList")) {
            bl = true;
            jSourceCode.add("desc = (new XMLFieldDescriptorImpl(");
            jSourceCode.append("Object.class, \"");
            jSourceCode.append(fieldInfo.getName());
            jSourceCode.append("\", (String)null, NodeType.Element) { ");
            jSourceCode.indent();
            jSourceCode.add("public boolean matches(String xmlName) {");
            jSourceCode.add("    return true;");
            jSourceCode.add("}");
            jSourceCode.unindent();
            jSourceCode.add("});");
        } else {
            if (xSType.getType() == 4) {
                xSType = ((CollectionInfo)fieldInfo).getContent().getSchemaType();
            }
            jSourceCode.add("desc = new XMLFieldDescriptorImpl(");
            jSourceCode.append(DescriptorSourceFactory.classType(xSType.getJType()));
            jSourceCode.append(", \"");
            jSourceCode.append(fieldInfo.getName());
            jSourceCode.append("\", ");
            string3 = fieldInfo.getNodeName();
            if (string3 != null && !bl5) {
                jSourceCode.append("\"");
                jSourceCode.append(fieldInfo.getNodeName());
                jSourceCode.append("\"");
            } else if (bl5) {
                jSourceCode.append("\"PCDATA\"");
            } else {
                jSourceCode.append("(String)null");
            }
            if (bl3) {
                jSourceCode.append(", NodeType.Element);");
            } else if (bl4) {
                jSourceCode.append(", NodeType.Attribute);");
            } else if (bl5) {
                jSourceCode.append(", NodeType.Text);");
            }
            switch (xSType.getType()) {
                case 0: {
                    bl2 = ((XSClass)xSType).isEnumerated();
                    break;
                }
                case 23: {
                    jSourceCode.add("desc.setImmutable(true);");
                    break;
                }
                case 10: {
                    jSourceCode.add("desc.setReference(true);");
                    break;
                }
                case 9: {
                    jSourceCode.add("this.identity = desc;");
                    break;
                }
            }
        }
        jSourceCode.add("handler = (new XMLFieldHandler() {");
        jSourceCode.indent();
        jSourceCode.add("public Object getValue( Object object ) ");
        jSourceCode.indent();
        jSourceCode.add("throws IllegalStateException");
        jSourceCode.unindent();
        jSourceCode.add("{");
        jSourceCode.indent();
        jSourceCode.add(string);
        jSourceCode.append(" target = (");
        jSourceCode.append(string);
        jSourceCode.append(") object;");
        if (!xSType.isEnumerated() && xSType.isPrimitive() && !fieldInfo.isMultivalued()) {
            jSourceCode.add("if(!target." + fieldInfo.getHasMethodName() + "())");
            jSourceCode.indent();
            jSourceCode.add("return null;");
            jSourceCode.unindent();
        }
        jSourceCode.add("return ");
        string3 = "target." + fieldInfo.getReadMethodName() + "()";
        if (fieldInfo.isMultivalued()) {
            jSourceCode.append(string3);
        } else {
            jSourceCode.append(xSType.createToJavaObjectCode(string3));
        }
        jSourceCode.append(";");
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.add("public void setValue( Object object, Object value) ");
        jSourceCode.indent();
        jSourceCode.add("throws IllegalStateException, IllegalArgumentException");
        jSourceCode.unindent();
        jSourceCode.add("{");
        jSourceCode.indent();
        jSourceCode.add("try {");
        jSourceCode.indent();
        jSourceCode.add(string);
        jSourceCode.append(" target = (");
        jSourceCode.append(string);
        jSourceCode.append(") object;");
        if (xSType.isPrimitive()) {
            if (!(fieldInfo.isRequired() || xSType.isEnumerated() || fieldInfo.isMultivalued())) {
                jSourceCode.add("// if null, use delete method for optional primitives ");
                jSourceCode.add("if (value == null) {");
                jSourceCode.indent();
                jSourceCode.add("target.");
                jSourceCode.append(fieldInfo.getDeleteMethodName());
                jSourceCode.append("();");
                jSourceCode.add("return;");
                jSourceCode.unindent();
                jSourceCode.add("}");
            } else {
                jSourceCode.add("// ignore null values for non optional primitives");
                jSourceCode.add("if (value == null) return;");
                jSourceCode.add("");
            }
        }
        jSourceCode.add("target.");
        jSourceCode.append(fieldInfo.getWriteMethodName());
        jSourceCode.append("( ");
        if (xSType.isPrimitive()) {
            jSourceCode.append(xSType.createFromJavaObjectCode("value"));
        } else if (bl) {
            jSourceCode.append(" value ");
        } else {
            jSourceCode.append("(");
            jSourceCode.append(xSType.getJType().toString());
            jSourceCode.append(") value");
        }
        jSourceCode.append(");");
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.add("catch (Exception ex) {");
        jSourceCode.indent();
        jSourceCode.add("throw new IllegalStateException(ex.toString());");
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.add("public Object newInstance( Object parent ) {");
        jSourceCode.indent();
        jSourceCode.add("return ");
        if (bl || bl2 || xSType.isPrimitive() || xSType.getJType().isArray() || xSType.getType() == 23) {
            jSourceCode.append("null;");
        } else {
            jSourceCode.append(xSType.newInstanceCode());
        }
        jSourceCode.unindent();
        jSourceCode.add("}");
        jSourceCode.unindent();
        jSourceCode.add("} );");
        if (bl2) {
            jSourceCode.add("desc.setHandler( new EnumFieldHandler(");
            jSourceCode.append(DescriptorSourceFactory.classType(xSType.getJType()));
            jSourceCode.append(", handler));");
            jSourceCode.add("desc.setImmutable(true);");
        } else if (xSType.getType() == 26) {
            jSourceCode.add("desc.setHandler( new DateFieldHandler(");
            jSourceCode.append("handler));");
            jSourceCode.add("desc.setImmutable(true);");
        } else if (xSType.getType() == 6) {
            jSourceCode.add("desc.setHandler( new DecimalFieldHandler(");
            jSourceCode.append("handler));");
            jSourceCode.add("desc.setImmutable(true);");
        } else if (xSType.getType() == 33) {
            jSourceCode.add("desc.setHandler( new CollectionFieldHandler(");
            jSourceCode.append("handler));");
        } else {
            jSourceCode.add("desc.setHandler(handler);");
        }
        if (string2 != null) {
            jSourceCode.add("desc.setNameSpaceURI(\"");
            jSourceCode.append(string2);
            jSourceCode.append("\");");
        }
        if (fieldInfo.isRequired()) {
            jSourceCode.add("desc.setRequired(true);");
        }
        if (bl3) {
            jSourceCode.add("desc.setMultivalued(" + fieldInfo.isMultivalued());
            jSourceCode.append(");");
        }
        jSourceCode.add("addFieldDescriptor(desc);");
        jSourceCode.add("");
        jSourceCode.add("//-- validation code for: ");
        jSourceCode.append(fieldInfo.getName());
        jSourceCode.add("fieldValidator = new FieldValidator();");
        DescriptorSourceFactory.validationCode(fieldInfo, jSourceCode);
        jSourceCode.add("desc.setValidator(fieldValidator);");
        jSourceCode.add("");
    }

    public static JClass createSource(ClassInfo classInfo) {
        Object object;
        String string;
        String string2;
        Object var1_1 = null;
        JSourceCode jSourceCode = null;
        Object var3_3 = null;
        JClass jClass = classInfo.getJClass();
        String string3 = jClass.getName();
        String string4 = jClass.getLocalName();
        String string5 = "_" + string3;
        DescriptorJClass descriptorJClass = new DescriptorJClass(String.valueOf(string3) + "Descriptor", jClass);
        JConstructor jConstructor = descriptorJClass.getConstructor(0);
        jSourceCode = jConstructor.getSourceCode();
        jSourceCode.add("super();");
        String string6 = classInfo.getNamespacePrefix();
        if (string6 != null && string6.length() > 0) {
            jSourceCode.add("nsPrefix = \"");
            jSourceCode.append(string6);
            jSourceCode.append("\";");
        }
        if ((string2 = classInfo.getNamespaceURI()) != null && string2.length() > 0) {
            jSourceCode.add("nsURI = \"");
            jSourceCode.append(string2);
            jSourceCode.append("\";");
        }
        if ((string = classInfo.getNodeName()) != null) {
            jSourceCode.add("xmlName = \"");
            jSourceCode.append(string);
            jSourceCode.append("\";");
        }
        jSourceCode.add("XMLFieldDescriptorImpl  desc           = null;");
        jSourceCode.add("XMLFieldHandler         handler        = null;");
        jSourceCode.add("FieldValidator          fieldValidator = null;");
        if (classInfo.isChoice()) {
            jSourceCode.add("");
            jSourceCode.add("//-- set grouping compositor");
            jSourceCode.add("setCompositorAsChoice();");
        } else if (classInfo.isSequence()) {
            jSourceCode.add("");
            jSourceCode.add("//-- set grouping compositor");
            jSourceCode.add("setCompositorAsSequence();");
        }
        if (classInfo.allowContent()) {
            DescriptorSourceFactory.createDescriptor(classInfo.getTextField(), string4, null, jSourceCode);
        }
        FieldInfo[] fieldInfoArray = classInfo.getAttributeFields();
        jSourceCode.add("//-- initialize attribute descriptors");
        jSourceCode.add("");
        int n = 0;
        while (n < fieldInfoArray.length) {
            object = fieldInfoArray[n];
            if (!((FieldInfo)object).isTransient()) {
                DescriptorSourceFactory.createDescriptor((FieldInfo)object, string4, string2, jSourceCode);
            }
            ++n;
        }
        object = classInfo.getElementFields();
        jSourceCode.add("//-- initialize element descriptors");
        jSourceCode.add("");
        int n2 = 0;
        while (n2 < ((Object)object).length) {
            Object object2 = object[n2];
            if (!((FieldInfo)object2).isTransient()) {
                DescriptorSourceFactory.createDescriptor((FieldInfo)object2, string4, string2, jSourceCode);
            }
            ++n2;
        }
        return descriptorJClass;
    }

    private static String escapePattern(String string) {
        if (string == null) {
            return string;
        }
        if (string.indexOf(92) < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            if (c == '\\') {
                stringBuffer.append(c);
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    private static void validationCode(FieldInfo fieldInfo, JSourceCode jSourceCode) {
        if (fieldInfo.getName().equals("_anyObject")) {
            return;
        }
        XSType xSType = fieldInfo.getSchemaType();
        if (xSType.getType() != 4 && fieldInfo.isRequired()) {
            jSourceCode.add("fieldValidator.setMinOccurs(1);");
        }
        String string = fieldInfo.getFixedValue();
        String string2 = null;
        switch (xSType.getType()) {
            case 6: {
                BigDecimal bigDecimal;
                jSourceCode.add("{ //-- local scope");
                jSourceCode.indent();
                jSourceCode.add("DecimalValidator dv = new DecimalValidator();");
                XSDecimal xSDecimal = (XSDecimal)xSType;
                if (xSDecimal.hasMinimum()) {
                    bigDecimal = xSDecimal.getMinExclusive();
                    if (bigDecimal != null) {
                        jSourceCode.add("dv.setMinExclusive(new java.math.BigDecimal(");
                    } else {
                        bigDecimal = xSDecimal.getMinInclusive();
                        jSourceCode.add("dv.setMinInclusive(new java.math.BigDecimal(");
                    }
                    jSourceCode.append(String.valueOf(bigDecimal.toString()) + ")");
                    jSourceCode.append(");");
                }
                if (xSDecimal.hasMaximum()) {
                    bigDecimal = xSDecimal.getMaxExclusive();
                    if (bigDecimal != null) {
                        jSourceCode.add("dv.setMaxExclusive(new java.math.BigDecimal(");
                    } else {
                        bigDecimal = xSDecimal.getMaxInclusive();
                        jSourceCode.add("dv.setMaxInclusive(new java.math.BigDecimal(");
                    }
                    jSourceCode.append(String.valueOf(bigDecimal.toString()) + ")");
                    jSourceCode.append(");");
                }
                if (xSDecimal.getScale() != null) {
                    jSourceCode.add("dv.setScale(");
                    jSourceCode.append(xSDecimal.getScale().toString());
                    jSourceCode.append(");");
                }
                if (xSDecimal.getPrecision() != null) {
                    jSourceCode.add("dv.setPrecision(");
                    jSourceCode.append(xSDecimal.getPrecision().toString());
                    jSourceCode.append(");");
                }
                jSourceCode.add("fieldValidator.setValidator(dv);");
                jSourceCode.unindent();
                jSourceCode.add("}");
                break;
            }
            case 8: {
                Float f;
                jSourceCode.add("{ //-- local scope");
                jSourceCode.indent();
                jSourceCode.add("FloatValidator fv = new FloatValidator();");
                XSFloat xSFloat = (XSFloat)xSType;
                if (xSFloat.hasMinimum()) {
                    f = xSFloat.getMinExclusive();
                    if (f != null) {
                        jSourceCode.add("fv.setMinExclusive( new Float(");
                    } else {
                        f = xSFloat.getMinInclusive();
                        jSourceCode.add("fv.setMinInclusive( new Float(");
                    }
                    if (f.equals(new Float(Float.NEGATIVE_INFINITY))) {
                        jSourceCode.append("Float.NEGATIVE_INFINITY");
                    } else if (f.equals(new Float(Float.POSITIVE_INFINITY))) {
                        jSourceCode.append("Float.POSITIVE_INFINITY");
                    } else {
                        jSourceCode.append(f.toString());
                    }
                    jSourceCode.append("));");
                }
                if (xSFloat.hasMaximum()) {
                    f = xSFloat.getMaxExclusive();
                    if (f != null) {
                        jSourceCode.add("fv.setMaxExclusive( new Float(");
                    } else {
                        f = xSFloat.getMaxInclusive();
                        jSourceCode.add("fv.setMaxInclusive( )");
                    }
                    if (f.equals(new Float(Float.NEGATIVE_INFINITY))) {
                        jSourceCode.append("Float.NEGATIVE_INFINITY");
                    } else if (f.equals(new Float(Float.POSITIVE_INFINITY))) {
                        jSourceCode.append("Float.POSITIVE_INFINITY");
                    } else {
                        jSourceCode.append(f.toString());
                    }
                    jSourceCode.append("));");
                }
                if (string != null) {
                    f = new Float(string);
                    jSourceCode.add("fv.setFixedValue( new Float(");
                    jSourceCode.append(string);
                    jSourceCode.append("));");
                }
                if ((string2 = xSFloat.getPattern()) != null) {
                    jSourceCode.add("fv.setPattern(\"");
                    jSourceCode.append(DescriptorSourceFactory.escapePattern(string2));
                    jSourceCode.append("\");");
                }
                jSourceCode.add("fieldValidator.setValidator(fv);");
                jSourceCode.unindent();
                jSourceCode.add("}");
                break;
            }
            case 7: {
                Double d;
                jSourceCode.add("{ //-- local scope");
                jSourceCode.indent();
                jSourceCode.add("DoubleValidator dv = new DoubleValidator();");
                XSReal xSReal = (XSReal)xSType;
                if (xSReal.hasMinimum()) {
                    d = xSReal.getMinExclusive();
                    if (d != null) {
                        jSourceCode.add("dv.setMinExclusive(");
                    } else {
                        d = xSReal.getMinInclusive();
                        jSourceCode.add("dv.setMinInclusive(");
                    }
                    jSourceCode.append(d.toString());
                    jSourceCode.append(");");
                }
                if (xSReal.hasMaximum()) {
                    d = xSReal.getMaxExclusive();
                    if (d != null) {
                        jSourceCode.add("dv.setMaxExclusive(");
                    } else {
                        d = xSReal.getMaxInclusive();
                        jSourceCode.add("dv.setMaxInclusive(");
                    }
                    jSourceCode.append(d.toString());
                    jSourceCode.append(");");
                }
                if (string != null) {
                    d = new Double(string);
                    jSourceCode.add("dv.setFixedValue(");
                    jSourceCode.append(string);
                    jSourceCode.append(");");
                }
                if ((string2 = xSReal.getPattern()) != null) {
                    jSourceCode.add("dv.setPattern(\"");
                    jSourceCode.append(DescriptorSourceFactory.escapePattern(string2));
                    jSourceCode.append("\");");
                }
                jSourceCode.add("fieldValidator.setValidator(dv);");
                jSourceCode.unindent();
                jSourceCode.add("}");
                break;
            }
            case 13: 
            case 17: 
            case 19: 
            case 31: 
            case 32: {
                Integer n;
                jSourceCode.add("{ //-- local scope");
                jSourceCode.indent();
                jSourceCode.add("IntegerValidator iv = new IntegerValidator();");
                XSInteger xSInteger = (XSInteger)xSType;
                if (xSInteger.hasMinimum()) {
                    n = xSInteger.getMinExclusive();
                    if (n != null) {
                        jSourceCode.add("iv.setMinExclusive(");
                    } else {
                        n = xSInteger.getMinInclusive();
                        jSourceCode.add("iv.setMinInclusive(");
                    }
                    jSourceCode.append(n.toString());
                    jSourceCode.append(");");
                }
                if (xSInteger.hasMaximum()) {
                    n = xSInteger.getMaxExclusive();
                    if (n != null) {
                        jSourceCode.add("iv.setMaxExclusive(");
                    } else {
                        n = xSInteger.getMaxInclusive();
                        jSourceCode.add("iv.setMaxInclusive(");
                    }
                    jSourceCode.append(n.toString());
                    jSourceCode.append(");");
                }
                if (string != null) {
                    Integer.parseInt(string);
                    jSourceCode.add("iv.setFixedValue(");
                    jSourceCode.append(string);
                    jSourceCode.append(");");
                }
                if ((string2 = xSInteger.getPattern()) != null) {
                    jSourceCode.add("iv.setPattern(\"");
                    jSourceCode.append(DescriptorSourceFactory.escapePattern(string2));
                    jSourceCode.append("\");");
                }
                jSourceCode.add("fieldValidator.setValidator(iv);");
                jSourceCode.unindent();
                jSourceCode.add("}");
                break;
            }
            case 12: {
                Integer n;
                jSourceCode.add("{ //-- local scope");
                jSourceCode.indent();
                jSourceCode.add("IntegerValidator iv = new IntegerValidator();");
                XSInt xSInt = (XSInt)xSType;
                if (xSInt.hasMinimum()) {
                    n = xSInt.getMinExclusive();
                    if (n != null) {
                        jSourceCode.add("iv.setMinExclusive(");
                    } else {
                        n = xSInt.getMinInclusive();
                        jSourceCode.add("iv.setMinInclusive(");
                    }
                    jSourceCode.append(n.toString());
                    jSourceCode.append(");");
                }
                if (xSInt.hasMaximum()) {
                    n = xSInt.getMaxExclusive();
                    if (n != null) {
                        jSourceCode.add("iv.setMaxExclusive(");
                    } else {
                        n = xSInt.getMaxInclusive();
                        jSourceCode.add("iv.setMaxInclusive(");
                    }
                    jSourceCode.append(n.toString());
                    jSourceCode.append(");");
                }
                if (string != null) {
                    Integer.parseInt(string);
                    jSourceCode.add("iv.setFixedValue(");
                    jSourceCode.append(string);
                    jSourceCode.append(");");
                }
                if ((string2 = xSInt.getPattern()) != null) {
                    jSourceCode.add("iv.setPattern(\"");
                    jSourceCode.append(DescriptorSourceFactory.escapePattern(string2));
                    jSourceCode.append("\");");
                }
                jSourceCode.add("fieldValidator.setValidator(iv);");
                jSourceCode.unindent();
                jSourceCode.add("}");
                break;
            }
            case 14: {
                Long l;
                jSourceCode.add("{ //-- local scope");
                jSourceCode.indent();
                jSourceCode.add("LongValidator lv = new LongValidator();");
                XSLong xSLong = (XSLong)xSType;
                if (xSLong.hasMinimum()) {
                    l = xSLong.getMinExclusive();
                    if (l != null) {
                        jSourceCode.add("lv.setMinExclusive(");
                    } else {
                        l = xSLong.getMinInclusive();
                        jSourceCode.add("lv.setMinInclusive(");
                    }
                    jSourceCode.append(l.toString());
                    jSourceCode.append("L);");
                }
                if (xSLong.hasMaximum()) {
                    l = xSLong.getMaxExclusive();
                    if (l != null) {
                        jSourceCode.add("lv.setMaxExclusive(");
                    } else {
                        l = xSLong.getMaxInclusive();
                        jSourceCode.add("lv.setMaxInclusive(");
                    }
                    jSourceCode.append(l.toString());
                    jSourceCode.append("L);");
                }
                if (string != null) {
                    Long.parseLong(string);
                    jSourceCode.add("lv.setFixedValue(");
                    jSourceCode.append(string);
                    jSourceCode.append(");");
                }
                if ((string2 = xSLong.getPattern()) != null) {
                    jSourceCode.add("lv.setPattern(\"");
                    jSourceCode.append(DescriptorSourceFactory.escapePattern(string2));
                    jSourceCode.append("\");");
                }
                jSourceCode.add("fieldValidator.setValidator(lv);");
                jSourceCode.unindent();
                jSourceCode.add("}");
                break;
            }
            case 23: {
                jSourceCode.add("{ //-- local scope");
                jSourceCode.indent();
                jSourceCode.add("StringValidator sv = new StringValidator();");
                XSString xSString = (XSString)xSType;
                if (xSString.hasMinLength() && !xSString.hasLength()) {
                    jSourceCode.add("sv.setMinLength(");
                    jSourceCode.append(Integer.toString(xSString.getMinLength()));
                    jSourceCode.append(");");
                }
                if (xSString.hasMaxLength() && !xSString.hasLength()) {
                    jSourceCode.add("sv.setMaxLength(");
                    jSourceCode.append(Integer.toString(xSString.getMaxLength()));
                    jSourceCode.append(");");
                }
                if (xSString.hasLength()) {
                    jSourceCode.add("sv.setLength(");
                    jSourceCode.append(Integer.toString(xSString.getLength()));
                    jSourceCode.append(");");
                }
                if (xSString.hasWhiteSpace()) {
                    jSourceCode.add("sv.setWhiteSpace(\"");
                    jSourceCode.append(xSString.getWhiteSpace());
                    jSourceCode.append("\");");
                }
                if (string != null) {
                    jSourceCode.add("sv.setFixedValue(");
                    jSourceCode.append(string);
                    jSourceCode.append(");");
                }
                if ((string2 = xSString.getPattern()) != null) {
                    jSourceCode.add("sv.setPattern(\"");
                    jSourceCode.append(DescriptorSourceFactory.escapePattern(string2));
                    jSourceCode.append("\");");
                }
                jSourceCode.add("fieldValidator.setValidator(sv);");
                jSourceCode.unindent();
                jSourceCode.add("}");
                break;
            }
            case 30: {
                jSourceCode.add("{ //-- local scope");
                jSourceCode.indent();
                jSourceCode.add("NameValidator nv = new NameValidator(NameValidator.CDATA);");
                XSCData xSCData = (XSCData)xSType;
                if (xSCData.hasMinLength() && !xSCData.hasLength()) {
                    jSourceCode.add("nv.setMinLength(");
                    jSourceCode.append(Integer.toString(xSCData.getMinLength()));
                    jSourceCode.append(");");
                }
                if (xSCData.hasMaxLength() && !xSCData.hasLength()) {
                    jSourceCode.add("nv.setMaxLength(");
                    jSourceCode.append(Integer.toString(xSCData.getMaxLength()));
                    jSourceCode.append(");");
                }
                if (xSCData.hasLength()) {
                    jSourceCode.add("nv.setLength(");
                    jSourceCode.append(Integer.toString(xSCData.getLength()));
                    jSourceCode.append(");");
                }
                if (string != null) {
                    jSourceCode.add("nv.setFixedValue(\"");
                    jSourceCode.append(string);
                    jSourceCode.append("\");");
                }
                if ((string2 = xSCData.getPattern()) != null) {
                    jSourceCode.add("nv.setPattern(\"");
                    jSourceCode.append(DescriptorSourceFactory.escapePattern(string2));
                    jSourceCode.append("\");");
                }
                jSourceCode.add("fieldValidator.setValidator(nv);");
                jSourceCode.unindent();
                jSourceCode.add("}");
                break;
            }
            case 16: {
                jSourceCode.add("fieldValidator.setValidator(new NameValidator());");
                break;
            }
            case 18: {
                jSourceCode.add("fieldValidator.setValidator(new NameValidator(");
                jSourceCode.append("NameValidator.NMTOKEN));");
                break;
            }
            case 4: {
                XSList xSList = (XSList)xSType;
                CollectionInfo collectionInfo = (CollectionInfo)fieldInfo;
                FieldInfo fieldInfo2 = collectionInfo.getContent();
                jSourceCode.add("fieldValidator.setMinOccurs(");
                jSourceCode.append(Integer.toString(xSList.getMinimumSize()));
                jSourceCode.append(");");
                if (xSList.getMaximumSize() <= 0) break;
                jSourceCode.add("fieldValidator.setMaxOccurs(");
                jSourceCode.append(Integer.toString(xSList.getMaximumSize()));
                jSourceCode.append(");");
                break;
            }
            case 24: {
                RecurringDuration recurringDuration;
                jSourceCode.add("{ //-- local scope");
                jSourceCode.indent();
                jSourceCode.add("TimeValidator tv = new TimeValidator();");
                XSTime xSTime = (XSTime)xSType;
                if (xSTime.hasMinimum()) {
                    jSourceCode.add("try {");
                    jSourceCode.indent();
                    recurringDuration = xSTime.getMinExclusive();
                    if (recurringDuration != null) {
                        jSourceCode.add("tv.setMinExclusive(");
                    } else {
                        recurringDuration = xSTime.getMinInclusive();
                        jSourceCode.add("tv.setMinInclusive(");
                    }
                    jSourceCode.append("org.exolab.castor.types.Time.parse(\"" + recurringDuration.toString() + "\"");
                    jSourceCode.append(");");
                    jSourceCode.unindent();
                    jSourceCode.add("} catch (java.text.ParseException e) {");
                    jSourceCode.indent();
                    jSourceCode.add("System.out.println(e);");
                    jSourceCode.add("e.printStackTrace();");
                    jSourceCode.add("return;");
                    jSourceCode.unindent();
                    jSourceCode.add("}");
                }
                if (xSTime.hasMaximum()) {
                    jSourceCode.add("try {");
                    jSourceCode.indent();
                    recurringDuration = xSTime.getMaxExclusive();
                    if (recurringDuration != null) {
                        jSourceCode.add("tv.setMaxExclusive(");
                    } else {
                        recurringDuration = xSTime.getMaxInclusive();
                        jSourceCode.add("tv.setMaxInclusive(");
                    }
                    jSourceCode.append("org.exolab.castor.types.Time.parse(\"" + recurringDuration.toString() + "\"");
                    jSourceCode.append(");");
                    jSourceCode.unindent();
                    jSourceCode.add("} catch (java.text.ParseException e) {");
                    jSourceCode.indent();
                    jSourceCode.add("System.out.println(e);");
                    jSourceCode.add("e.printStackTrace();");
                    jSourceCode.add("return;");
                    jSourceCode.unindent();
                    jSourceCode.add("}");
                }
                jSourceCode.add("fieldValidator.setValidator(tv);");
                jSourceCode.unindent();
                jSourceCode.add("}");
                break;
            }
            case 3: 
            case 5: 
            case 15: 
            case 21: 
            case 27: 
            case 29: {
                RecurringDuration recurringDuration;
                jSourceCode.add("{ //-- local scope");
                jSourceCode.indent();
                jSourceCode.add("RecurringDurationValidator rv = new RecurringDurationValidator();");
                XSRecurringDuration xSRecurringDuration = (XSRecurringDuration)xSType;
                if (xSRecurringDuration.hasMinimum()) {
                    jSourceCode.add("try {");
                    jSourceCode.indent();
                    recurringDuration = xSRecurringDuration.getMinExclusive();
                    if (recurringDuration != null) {
                        jSourceCode.add("org.exolab.castor.types.RecurringDuration min =org.exolab.castor.types.RecurringDuration.parseRecurring(\"" + recurringDuration.toString() + "\");");
                        jSourceCode.add("min.setDuration(\"" + recurringDuration.getDuration().toString() + "\");");
                        jSourceCode.add("min.setPeriod(\"" + recurringDuration.getPeriod().toString() + "\");");
                        jSourceCode.add("rv.setMinExclusive(");
                    } else {
                        recurringDuration = xSRecurringDuration.getMinInclusive();
                        jSourceCode.add("org.exolab.castor.types.RecurringDuration min =org.exolab.castor.types.RecurringDuration.parseRecurring(\"" + recurringDuration.toString() + "\");");
                        jSourceCode.add("min.setDuration(\"" + recurringDuration.getDuration().toString() + "\");");
                        jSourceCode.add("min.setPeriod(\"" + recurringDuration.getPeriod().toString() + "\");");
                        jSourceCode.add("rv.setMinInclusive(");
                    }
                    jSourceCode.append("min");
                    jSourceCode.append(");");
                    jSourceCode.unindent();
                    jSourceCode.add("} catch (java.text.ParseException e) {");
                    jSourceCode.indent();
                    jSourceCode.add("System.out.println(e);");
                    jSourceCode.add("e.printStackTrace();");
                    jSourceCode.add("return;");
                    jSourceCode.unindent();
                    jSourceCode.add("}");
                }
                if (xSRecurringDuration.hasMaximum()) {
                    jSourceCode.add("try {");
                    jSourceCode.indent();
                    recurringDuration = xSRecurringDuration.getMaxExclusive();
                    if (recurringDuration != null) {
                        jSourceCode.add("org.exolab.castor.types.RecurringDuration max =org.exolab.castor.types.RecurringDuration.parseRecurring(\"" + recurringDuration.toString() + "\");");
                        jSourceCode.add("max.setDuration(\"" + recurringDuration.getDuration().toString() + "\");");
                        jSourceCode.add("max.setPeriod(\"" + recurringDuration.getPeriod().toString() + "\");");
                        jSourceCode.add("rv.setMaxExclusive(");
                    } else {
                        recurringDuration = xSRecurringDuration.getMaxInclusive();
                        jSourceCode.add("org.exolab.castor.types.RecurringDuration max =org.exolab.castor.types.RecurringDuration.parseRecurring(\"" + recurringDuration.toString() + "\");");
                        jSourceCode.add("max.setDuration(\"" + recurringDuration.getDuration().toString() + "\");");
                        jSourceCode.add("max.setPeriod(\"" + recurringDuration.getPeriod().toString() + "\");");
                        jSourceCode.add("rv.setMaxInclusive(");
                    }
                    jSourceCode.append("max");
                    jSourceCode.append(");");
                    jSourceCode.unindent();
                    jSourceCode.add("} catch (java.text.ParseException e) {");
                    jSourceCode.indent();
                    jSourceCode.add("System.out.println(e);");
                    jSourceCode.add("e.printStackTrace();");
                    jSourceCode.add("return;");
                    jSourceCode.unindent();
                    jSourceCode.add("}");
                }
                jSourceCode.add("fieldValidator.setValidator(rv);");
                jSourceCode.unindent();
                jSourceCode.add("}");
                break;
            }
            case 25: {
                TimeDuration timeDuration;
                jSourceCode.add("{ //-- local scope");
                jSourceCode.indent();
                jSourceCode.add("TimeDurationValidator tv = new TimeDurationValidator();");
                XSTimeDuration xSTimeDuration = (XSTimeDuration)xSType;
                if (xSTimeDuration.hasMinimum()) {
                    timeDuration = xSTimeDuration.getMinExclusive();
                    if (timeDuration != null) {
                        jSourceCode.add("tv.setMinExclusive(");
                    } else {
                        timeDuration = xSTimeDuration.getMinInclusive();
                        jSourceCode.add("tv.setMinInclusive(");
                    }
                    jSourceCode.append("new org.exolab.castor.types.TimeDuration(" + timeDuration.toLong() + "L)");
                    jSourceCode.append(");");
                }
                if (xSTimeDuration.hasMaximum()) {
                    timeDuration = xSTimeDuration.getMaxExclusive();
                    if (timeDuration != null) {
                        jSourceCode.add("tv.setMaxExclusive(");
                    } else {
                        timeDuration = xSTimeDuration.getMaxInclusive();
                        jSourceCode.add("tv.setMaxInclusive(");
                    }
                    jSourceCode.append("new org.exolab.castor.types.TimeDuration(" + timeDuration.toLong() + "L)");
                    jSourceCode.append(");");
                }
                jSourceCode.add("fieldValidator.setValidator(tv);");
                jSourceCode.unindent();
                jSourceCode.add("}");
                break;
            }
        }
    }
}

