/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.util.ServiceMBeanSupport;
import org.jboss.web.WebServer;
import org.jboss.web.WebServiceMBean;

public class WebService
extends ServiceMBeanSupport
implements WebServiceMBean {
    private WebServer server = new WebServer();
    private String host;

    public WebService() {
        Properties mimeTypes = new Properties();
        try {
            mimeTypes.load(this.getClass().getResourceAsStream("mime.types"));
            Enumeration keys = ((Hashtable)mimeTypes).keys();
            while (keys.hasMoreElements()) {
                String extension = (String)keys.nextElement();
                String type = mimeTypes.getProperty(extension);
                this.server.addMimeType(extension, type);
            }
        }
        catch (IOException e) {
            this.log.error("Failed to load mime.types", e);
        }
        try {
            this.host = System.getProperty("java.rmi.server.hostname");
        }
        catch (SecurityException securityException) {}
        try {
            if (this.host == null) {
                this.host = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (IOException e) {
            this.log.error("Failed to get localhost name", e);
        }
    }

    public URL addClassLoader(ClassLoader cl) {
        return this.server.addClassLoader(cl);
    }

    public int getBacklog() {
        return this.server.getBacklog();
    }

    public String getBindAddress() {
        return this.server.getBindAddress();
    }

    public boolean getDownloadServerClasses() {
        return this.server.getDownloadServerClasses();
    }

    public String getHost() {
        return this.host;
    }

    public String getName() {
        return "Webserver";
    }

    public ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return new ObjectName(":service=Webserver");
    }

    public int getPort() {
        return this.server.getPort();
    }

    public void removeClassLoader(ClassLoader cl) {
        this.server.removeClassLoader(cl);
    }

    public void setBacklog(int backlog) {
        this.server.setBacklog(backlog);
    }

    public void setBindAddress(String host) throws UnknownHostException {
        this.server.setBindAddress(host);
    }

    public void setDownloadServerClasses(boolean flag) {
        this.server.setDownloadServerClasses(flag);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.server.setPort(port);
    }

    public void startService() throws Exception {
        this.server.start();
        this.log.info("Started webserver with address: " + this.server.getBindAddress() + " port: " + this.server.getPort());
        String codebase = System.getProperty("java.rmi.server.codebase");
        if (codebase == null) {
            codebase = "http://" + this.host + ":" + this.getPort() + "/";
            System.setProperty("java.rmi.server.codebase", codebase);
        }
        this.log.info("Codebase set to: " + codebase);
    }

    public void stopService() {
        this.server.stop();
    }
}

