/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.web.ThreadPool;

public class WebServer
implements Runnable {
    private static Logger log = Logger.getLogger(class$org$jboss$web$WebServer != null ? class$org$jboss$web$WebServer : (class$org$jboss$web$WebServer = WebServer.class$("org.jboss.web.WebServer")));
    private int port = 8083;
    private InetAddress bindAddress;
    private int backlog = 50;
    private HashMap loaderMap = new HashMap();
    private ServerSocket server = null;
    private boolean downloadServerClasses = true;
    private static Properties mimeTypes = new Properties();
    private ThreadPool threadPool = new ThreadPool();
    static /* synthetic */ Class class$org$jboss$web$WebServer;

    public URL addClassLoader(ClassLoader cl) {
        String key = this.getClassLoaderKey(cl);
        this.loaderMap.put(key, cl);
        URL loaderURL = null;
        String codebase = System.getProperty("java.rmi.server.codebase");
        if (codebase != null) {
            if (!codebase.endsWith("/")) {
                codebase = String.valueOf(codebase) + '/';
            }
            codebase = String.valueOf(codebase) + key;
            try {
                loaderURL = new URL(codebase);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        log.trace("Added ClassLoader: " + cl + " URL: " + loaderURL);
        return loaderURL;
    }

    public void addMimeType(String extension, String type) {
        ((Hashtable)mimeTypes).put(extension, type);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public String getBindAddress() {
        String address = null;
        if (this.bindAddress != null) {
            address = this.bindAddress.getHostAddress();
        }
        return address;
    }

    protected byte[] getBytes(URL url) throws IOException {
        int bytes;
        BufferedInputStream in = new BufferedInputStream(url.openStream());
        log.debug("Retrieving " + url.toString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] tmp = new byte[1024];
        while ((bytes = ((InputStream)in).read(tmp)) != -1) {
            out.write(tmp, 0, bytes);
        }
        return out.toByteArray();
    }

    protected String getClassLoaderKey(ClassLoader cl) {
        String className = cl.getClass().getName();
        int dot = className.lastIndexOf(46);
        if (dot >= 0) {
            className = className.substring(dot + 1);
        }
        String key = String.valueOf(className) + '@' + cl.hashCode() + '/';
        return key;
    }

    public boolean getDownloadServerClasses() {
        return this.downloadServerClasses;
    }

    protected String getMimeType(String path) {
        String suffix;
        String mimeType;
        int dot = path.lastIndexOf(".");
        String type = "text/html";
        if (dot >= 0 && (mimeType = mimeTypes.getProperty(suffix = path.substring(dot + 1))) != null) {
            type = mimeType;
        }
        return type;
    }

    protected String getPath(BufferedReader in) throws IOException {
        String line = in.readLine();
        log.trace("raw request=" + line);
        int start = line.indexOf(32) + 1;
        int end = line.indexOf(32, start + 1);
        String filePath = line.substring(start + 1, end);
        return filePath;
    }

    public int getPort() {
        return this.port;
    }

    protected void listen() {
        this.threadPool.run(this);
    }

    public void removeClassLoader(ClassLoader cl) {
        String key = this.getClassLoaderKey(cl);
        this.loaderMap.remove(key);
    }

    public void run() {
        if (this.server == null) {
            return;
        }
        Socket socket = null;
        try {
            socket = this.server.accept();
        }
        catch (IOException e) {
            if (this.server != null) {
                log.error("Failed to accept connection", e);
            }
            return;
        }
        this.listen();
        try {
            try {
                DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                try {
                    String httpCode = "200 OK";
                    BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    String rawPath = this.getPath(in);
                    int separator = rawPath.indexOf(47);
                    String filePath = rawPath.substring(separator + 1);
                    String loaderKey = rawPath.substring(0, separator + 1);
                    log.trace("loaderKey = " + loaderKey);
                    log.trace("filePath = " + filePath);
                    ClassLoader loader = (ClassLoader)this.loaderMap.get(loaderKey);
                    if (loader == null && rawPath.indexOf(64) < 0 && this.downloadServerClasses) {
                        filePath = rawPath;
                        log.trace("No loader, reset filePath = " + filePath);
                        loader = Thread.currentThread().getContextClassLoader();
                    }
                    log.trace("loader = " + loader);
                    byte[] bytes = new byte[]{};
                    if (loader != null && filePath.endsWith(".class")) {
                        String className = filePath.substring(0, filePath.length() - 6).replace('/', '.');
                        log.trace("loading className = " + className);
                        Class<?> clazz = loader.loadClass(className);
                        URL clazzUrl = clazz.getProtectionDomain().getCodeSource().getLocation();
                        log.trace("clazzUrl = " + clazzUrl);
                        clazzUrl = clazzUrl.getFile().endsWith(".jar") ? new URL("jar:" + clazzUrl + "!/" + filePath) : new URL(clazzUrl, filePath);
                        if (clazzUrl == null) {
                            throw new Exception("Class not found:" + className);
                        }
                        bytes = this.getBytes(clazzUrl);
                    } else if (loader != null && filePath.length() > 0 && this.downloadServerClasses) {
                        log.trace("loading resource = " + filePath);
                        URL resourceURL = loader.getResource(filePath);
                        if (resourceURL == null) {
                            httpCode = "404 Resource not found:" + filePath;
                        } else {
                            log.trace("resourceURL = " + resourceURL);
                            bytes = this.getBytes(resourceURL);
                        }
                    } else {
                        httpCode = "404 Not Found";
                    }
                    try {
                        log.trace("HTTP code=" + httpCode + ", Content-Length: " + bytes.length);
                        out.writeBytes("HTTP/1.0 " + httpCode + "\r\n");
                        out.writeBytes("Content-Length: " + bytes.length + "\r\n");
                        out.writeBytes("Content-Type: " + this.getMimeType(filePath));
                        out.writeBytes("\r\n\r\n");
                        out.write(bytes);
                        out.flush();
                    }
                    catch (IOException iOException) {
                        Object var3_19 = null;
                        try {
                            socket.close();
                        }
                        catch (IOException iOException2) {}
                        return;
                    }
                }
                catch (Throwable e) {
                    try {
                        log.trace("HTTP code=404 " + e.getMessage());
                        out.writeBytes("HTTP/1.0 404 " + e.getMessage() + "\r\n");
                        out.writeBytes("Content-Type: text/html\r\n\r\n");
                        out.flush();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException ex) {
                log.debug("error writing response: " + ex.getMessage());
                ex.printStackTrace();
            }
            Object var3_20 = null;
        }
        catch (Throwable throwable) {
            Object var3_21 = null;
            try {
                socket.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {}
    }

    public void setBacklog(int backlog) {
        if (backlog <= 0) {
            backlog = 50;
        }
        this.backlog = backlog;
    }

    public void setBindAddress(String host) {
        try {
            if (host != null) {
                this.bindAddress = InetAddress.getByName(host);
            }
        }
        catch (UnknownHostException e) {
            String msg = "Invalid host address specified: " + host;
            log.error(msg, e);
        }
    }

    public void setDownloadServerClasses(boolean flag) {
        this.downloadServerClasses = flag;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public void start() throws IOException {
        this.server = new ServerSocket(this.port, this.backlog, this.bindAddress);
        log.debug("Started server: " + this.server);
        this.listen();
    }

    public void stop() {
        try {
            ServerSocket srv = this.server;
            this.server = null;
            srv.close();
        }
        catch (Exception exception) {}
    }
}

