/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.verifier.strategy;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.SessionMetaData;
import org.jboss.verifier.Section;
import org.jboss.verifier.factory.DefaultEventFactory;
import org.jboss.verifier.strategy.AbstractVerifier;
import org.jboss.verifier.strategy.VerificationContext;

public class EJBVerifier11
extends AbstractVerifier {
    public EJBVerifier11(VerificationContext context) {
        super(context, new DefaultEventFactory());
    }

    public void checkEntity(EntityMetaData entity) {
        boolean pkVerified = false;
        boolean beanVerified = false;
        boolean homeVerified = false;
        boolean remoteVerified = false;
        beanVerified = this.verifyEntityBean(entity);
        homeVerified = this.verifyEntityHome(entity);
        remoteVerified = this.verifyEntityRemote(entity);
        pkVerified = this.verifyPrimaryKey(entity);
        if (beanVerified && homeVerified && remoteVerified && pkVerified) {
            this.fireBeanVerifiedEvent(entity);
        }
    }

    public void checkSession(SessionMetaData session) {
        boolean beanVerified = false;
        boolean homeVerified = false;
        boolean remoteVerified = false;
        beanVerified = this.verifySessionBean(session);
        homeVerified = this.verifySessionHome(session);
        remoteVerified = this.verifySessionRemote(session);
        if (beanVerified && homeVerified && remoteVerified) {
            this.fireBeanVerifiedEvent(session);
        }
    }

    private boolean verifyEntityBean(EntityMetaData entity) {
        boolean status = true;
        String name = entity.getEjbClass();
        try {
            Method ejbCreate;
            Iterator it;
            Class<?> bean = this.classloader.loadClass(name);
            if (!this.hasEntityBeanInterface(bean)) {
                this.fireSpecViolationEvent(entity, new Section("9.2.2.a"));
                status = false;
            }
            if (!this.isPublic(bean)) {
                this.fireSpecViolationEvent(entity, new Section("9.2.2.b"));
                status = false;
            }
            if (this.isAbstract(bean)) {
                this.fireSpecViolationEvent(entity, new Section("9.2.2.c"));
                status = false;
            }
            if (this.isFinal(bean)) {
                this.fireSpecViolationEvent(entity, new Section("9.2.2.d"));
                status = false;
            }
            if (!this.hasDefaultConstructor(bean)) {
                this.fireSpecViolationEvent(entity, new Section("9.2.2.e"));
                status = false;
            }
            if (this.hasFinalizer(bean)) {
                this.fireSpecViolationEvent(entity, new Section("9.2.2.f"));
                status = false;
            }
            if (this.hasEJBCreateMethod(bean, false)) {
                it = this.getEJBCreateMethods(bean);
                while (it.hasNext()) {
                    ejbCreate = (Method)it.next();
                    if (!this.isPublic(ejbCreate)) {
                        this.fireSpecViolationEvent(entity, ejbCreate, new Section("9.2.3.a"));
                        status = false;
                    }
                    if (this.isFinal(ejbCreate) || this.isStatic(ejbCreate)) {
                        this.fireSpecViolationEvent(entity, ejbCreate, new Section("9.2.3.b"));
                        status = false;
                    }
                    if (!this.hasPrimaryKeyReturnType(entity, ejbCreate)) {
                        this.fireSpecViolationEvent(entity, ejbCreate, new Section("9.2.3.c"));
                        status = false;
                    }
                    if (!this.hasLegalRMIIIOPArguments(ejbCreate)) {
                        this.fireSpecViolationEvent(entity, ejbCreate, new Section("9.2.3.d"));
                        status = false;
                    }
                    if (this.hasLegalRMIIIOPReturnType(ejbCreate)) continue;
                    this.fireSpecViolationEvent(entity, ejbCreate, new Section("9.2.3.e"));
                    status = false;
                }
            }
            if (this.hasEJBCreateMethod(bean, false)) {
                it = this.getEJBCreateMethods(bean);
                while (it.hasNext()) {
                    ejbCreate = (Method)it.next();
                    if (!this.hasMatchingEJBPostCreate(bean, ejbCreate)) {
                        this.fireSpecViolationEvent(entity, ejbCreate, new Section("9.2.4.a"));
                        status = false;
                    }
                    if (!this.hasMatchingEJBPostCreate(bean, ejbCreate)) continue;
                    Method ejbPostCreate = this.getMatchingEJBPostCreate(bean, ejbCreate);
                    if (!this.isPublic(ejbPostCreate)) {
                        this.fireSpecViolationEvent(entity, ejbPostCreate, new Section("9.2.4.b"));
                        status = false;
                    }
                    if (this.isStatic(ejbPostCreate)) {
                        this.fireSpecViolationEvent(entity, ejbPostCreate, new Section("9.2.4.c"));
                        status = false;
                    }
                    if (this.isFinal(ejbPostCreate)) {
                        this.fireSpecViolationEvent(entity, ejbPostCreate, new Section("9.2.4.d"));
                        status = false;
                    }
                    if (this.hasVoidReturnType(ejbPostCreate)) continue;
                    this.fireSpecViolationEvent(entity, ejbPostCreate, new Section("9.2.4.e"));
                    status = false;
                }
            }
            if (entity.isBMP() && !this.hasEJBFindByPrimaryKey(bean)) {
                this.fireSpecViolationEvent(entity, new Section("9.2.5.a"));
                status = false;
            }
            if (this.hasEJBFindByPrimaryKey(bean)) {
                Method ejbFindByPrimaryKey = this.getEJBFindByPrimaryKey(bean);
                if (!this.hasPrimaryKeyReturnType(entity, ejbFindByPrimaryKey)) {
                    this.fireSpecViolationEvent(entity, ejbFindByPrimaryKey, new Section("9.2.5.b"));
                    status = false;
                }
                if (!this.isSingleObjectFinder(entity, ejbFindByPrimaryKey)) {
                    this.fireSpecViolationEvent(entity, ejbFindByPrimaryKey, new Section("9.2.5.c"));
                    status = false;
                }
            }
            if (this.hasFinderMethod(bean)) {
                it = this.getEJBFindMethods(bean);
                while (it.hasNext()) {
                    Method finder = (Method)it.next();
                    if (!this.isPublic(finder)) {
                        this.fireSpecViolationEvent(entity, finder, new Section("9.2.5.d"));
                        status = false;
                    }
                    if (this.isFinal(finder)) {
                        this.fireSpecViolationEvent(entity, finder, new Section("9.2.5.e"));
                        status = false;
                    }
                    if (this.isStatic(finder)) {
                        this.fireSpecViolationEvent(entity, finder, new Section("9.2.5.f"));
                        status = false;
                    }
                    if (!this.hasLegalRMIIIOPArguments(finder)) {
                        this.fireSpecViolationEvent(entity, finder, new Section("9.2.5.g"));
                        status = false;
                    }
                    if (this.isSingleObjectFinder(entity, finder) || this.isMultiObjectFinder(finder)) continue;
                    this.fireSpecViolationEvent(entity, finder, new Section("9.2.5.h"));
                    status = false;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.fireSpecViolationEvent(entity, new Section("16.2.b"));
            status = false;
        }
        return status;
    }

    private boolean verifyEntityHome(EntityMetaData entity) {
        boolean status = true;
        String name = entity.getHome();
        if (name == null) {
            return false;
        }
        try {
            Method method;
            Class<?> home = this.classloader.loadClass(name);
            if (!this.hasEJBHomeInterface(home)) {
                this.fireSpecViolationEvent(entity, new Section("9.2.8.a"));
                status = false;
            }
            Iterator<Method> homeMethods = Arrays.asList(home.getMethods()).iterator();
            while (homeMethods.hasNext()) {
                method = homeMethods.next();
                if (!this.hasLegalRMIIIOPArguments(method)) {
                    this.fireSpecViolationEvent(entity, method, new Section("9.2.8.b"));
                    status = false;
                }
                if (!this.hasLegalRMIIIOPReturnType(method)) {
                    this.fireSpecViolationEvent(entity, method, new Section("9.2.8.c"));
                    status = false;
                }
                if (this.throwsRemoteException(method)) continue;
                this.fireSpecViolationEvent(entity, method, new Section("9.2.8.d"));
                status = false;
            }
            homeMethods = Arrays.asList(home.getMethods()).iterator();
            while (homeMethods.hasNext()) {
                method = homeMethods.next();
                if (method.getDeclaringClass().getName().equals("javax.ejb.EJBHome") || this.isCreateMethod(method) || this.isFinderMethod(method)) continue;
                this.fireSpecViolationEvent(entity, method, new Section("9.2.8.e"));
                status = false;
            }
            Iterator createMethods = this.getCreateMethods(home);
            try {
                String beanClass = entity.getEjbClass();
                Class<?> bean = this.classloader.loadClass(beanClass);
                while (createMethods.hasNext()) {
                    Method create = (Method)createMethods.next();
                    if (!this.hasMatchingEJBCreate(bean, create)) {
                        this.fireSpecViolationEvent(entity, create, new Section("9.2.8.f"));
                        status = false;
                    }
                    if (!this.hasRemoteReturnType(entity, create)) {
                        this.fireSpecViolationEvent(entity, create, new Section("9.2.8.g"));
                        status = false;
                    }
                    if (this.hasMatchingEJBCreate(bean, create) && this.hasMatchingEJBPostCreate(bean, create)) {
                        Method ejbCreate = this.getMatchingEJBCreate(bean, create);
                        Method ejbPostCreate = this.getMatchingEJBPostCreate(bean, create);
                        if (!this.hasMatchingExceptions(ejbCreate, create) || !this.hasMatchingExceptions(ejbPostCreate, create)) {
                            this.fireSpecViolationEvent(entity, create, new Section("9.2.8.h"));
                        }
                    }
                    if (this.throwsCreateException(create)) continue;
                    this.fireSpecViolationEvent(entity, create, new Section("9.2.8.i"));
                    status = false;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
            Iterator finderMethods = this.getFinderMethods(home);
            try {
                String beanClass = entity.getEjbClass();
                Class<?> bean = this.classloader.loadClass(beanClass);
                while (finderMethods.hasNext()) {
                    Method ejbFind;
                    Method finder = (Method)finderMethods.next();
                    if (entity.isBMP() && !this.hasMatchingEJBFind(bean, finder)) {
                        this.fireSpecViolationEvent(entity, finder, new Section("9.2.8.j"));
                        status = false;
                    }
                    if (!this.hasRemoteReturnType(entity, finder) && !this.isMultiObjectFinder(finder)) {
                        this.fireSpecViolationEvent(entity, finder, new Section("9.2.8.k"));
                        status = false;
                    }
                    if (entity.isBMP() && this.hasMatchingEJBFind(bean, finder) && !this.hasMatchingExceptions(ejbFind = this.getMatchingEJBFind(bean, finder), finder)) {
                        this.fireSpecViolationEvent(entity, finder, new Section("9.2.8.l"));
                    }
                    if (this.throwsFinderException(finder)) continue;
                    this.fireSpecViolationEvent(entity, finder, new Section("9.2.8.m"));
                    status = false;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.fireSpecViolationEvent(entity, new Section("16.2.c"));
            status = false;
        }
        return status;
    }

    private boolean verifyEntityRemote(EntityMetaData entity) {
        boolean status = true;
        String name = entity.getRemote();
        if (name == null) {
            return false;
        }
        try {
            Class<?> remote = this.classloader.loadClass(name);
            if (!this.hasEJBObjectInterface(remote)) {
                this.fireSpecViolationEvent(entity, new Section("9.2.7.a"));
                status = false;
            }
            Iterator<Method> remoteMethods = Arrays.asList(remote.getMethods()).iterator();
            while (remoteMethods.hasNext()) {
                Method method = remoteMethods.next();
                if (!this.hasLegalRMIIIOPArguments(method)) {
                    this.fireSpecViolationEvent(entity, method, new Section("9.2.7.b"));
                    status = false;
                }
                if (!this.hasLegalRMIIIOPReturnType(method)) {
                    this.fireSpecViolationEvent(entity, method, new Section("9.2.7.c"));
                    status = false;
                }
                if (!this.hasLegalRMIIIOPExceptionTypes(method)) {
                    this.fireSpecViolationEvent(entity, method, new Section("9.2.7.h"));
                    status = false;
                }
                if (this.throwsRemoteException(method)) continue;
                this.fireSpecViolationEvent(entity, method, new Section("9.2.7.d"));
                status = false;
            }
            remoteMethods = Arrays.asList(remote.getMethods()).iterator();
            try {
                String beanClass = entity.getEjbClass();
                Class<?> bean = this.classloader.loadClass(beanClass);
                while (remoteMethods.hasNext()) {
                    Method method = remoteMethods.next();
                    if (method.getDeclaringClass().getName().equals("javax.ejb.EJBObject")) continue;
                    if (!this.hasMatchingMethod(bean, method)) {
                        this.fireSpecViolationEvent(entity, method, new Section("9.2.7.e"));
                        status = false;
                    }
                    if (!this.hasMatchingMethod(bean, method)) continue;
                    try {
                        Method beanMethod = bean.getMethod(method.getName(), method.getParameterTypes());
                        if (!this.hasMatchingReturnType(beanMethod, method)) {
                            this.fireSpecViolationEvent(entity, method, new Section("9.2.7.f"));
                            status = false;
                        }
                        if (this.hasMatchingExceptions(beanMethod, method)) continue;
                        this.fireSpecViolationEvent(entity, method, new Section("9.2.7.g"));
                        status = false;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.fireSpecViolationEvent(entity, new Section("16.2.d"));
            status = false;
        }
        return status;
    }

    private boolean verifyPrimaryKey(EntityMetaData entity) {
        boolean status;
        block25: {
            status = true;
            if (entity.getPrimaryKeyClass() == null || entity.getPrimaryKeyClass().length() == 0) {
                this.fireSpecViolationEvent(entity, new Section("16.5.a"));
                return false;
            }
            if (entity.getPrimKeyField() == null || entity.getPrimKeyField().length() == 0) {
                Class<?> cls = null;
                try {
                    cls = this.classloader.loadClass(entity.getPrimaryKeyClass());
                    if (entity.isCMP()) {
                        if (!this.isPublic(cls)) {
                            status = false;
                            this.fireSpecViolationEvent(entity, new Section("9.4.7.2.a"));
                        }
                        if (!this.isAllFieldsPublic(cls)) {
                            status = false;
                            this.fireSpecViolationEvent(entity, new Section("9.4.7.2.b"));
                        }
                        if (!this.hasANonStaticField(cls)) {
                            status = false;
                            this.fireSpecViolationEvent(entity, new Section("9.4.7.2.c"));
                        }
                    }
                    if (cls.getName().equals("java.lang.Object")) break block25;
                    try {
                        Object one = cls.newInstance();
                        Object two = cls.newInstance();
                        try {
                            if (!one.equals(two)) {
                                status = false;
                                this.fireSpecViolationEvent(entity, new Section("9.2.9.b"));
                            }
                        }
                        catch (NullPointerException nullPointerException) {}
                        try {
                            if (one.hashCode() != two.hashCode()) {
                                status = false;
                                this.fireSpecViolationEvent(entity, new Section("9.2.9.c"));
                            }
                        }
                        catch (NullPointerException nullPointerException) {}
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.fireSpecViolationEvent(entity, new Section("16.2.e"));
                    status = false;
                }
            } else {
                if (entity.isBMP()) {
                    this.fireSpecViolationEvent(entity, new Section("9.4.7.1.a"));
                    status = false;
                }
                try {
                    Class<?> fieldClass = this.classloader.loadClass(entity.getEjbClass());
                    Field field = null;
                    try {
                        field = fieldClass.getField(entity.getPrimKeyField());
                        if (!entity.getPrimaryKeyClass().equals(field.getType().getName())) {
                            status = false;
                            this.fireSpecViolationEvent(entity, new Section("9.4.7.1.c"));
                        }
                        Iterator it = entity.getCMPFields();
                        boolean found = false;
                        while (it.hasNext()) {
                            String fieldName = (String)it.next();
                            if (!fieldName.equals(entity.getPrimKeyField())) continue;
                            found = true;
                            break;
                        }
                        if (found) break block25;
                        status = false;
                        this.fireSpecViolationEvent(entity, new Section("9.4.7.1.d"));
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        status = false;
                        this.fireSpecViolationEvent(entity, new Section("9.4.7.1.b"));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        return status;
    }

    private boolean verifySessionBean(SessionMetaData session) {
        boolean status = true;
        String name = session.getEjbClass();
        try {
            Class<?> bean = this.classloader.loadClass(name);
            if (!this.hasSessionBeanInterface(bean)) {
                this.fireSpecViolationEvent(session, new Section("6.5.1"));
                status = false;
            }
            if (this.hasSessionSynchronizationInterface(bean)) {
                if (session.isStateless()) {
                    this.fireSpecViolationEvent(session, new Section("6.5.3.a"));
                    status = false;
                }
                if (session.isBeanManagedTx()) {
                    this.fireSpecViolationEvent(session, new Section("6.5.3.b"));
                    status = false;
                }
            }
            if (!this.hasEJBCreateMethod(bean, true)) {
                this.fireSpecViolationEvent(session, new Section("6.5.5"));
                status = false;
            }
            if (this.hasSessionSynchronizationInterface(bean) && session.isBeanManagedTx()) {
                this.fireSpecViolationEvent(session, new Section("6.6.1"));
                status = false;
            }
            if (!this.isPublic(bean)) {
                this.fireSpecViolationEvent(session, new Section("6.10.2.a"));
                status = false;
            }
            if (this.isFinal(bean)) {
                this.fireSpecViolationEvent(session, new Section("6.10.2.b"));
                status = false;
            }
            if (this.isAbstract(bean)) {
                this.fireSpecViolationEvent(session, new Section("6.10.2.c"));
                status = false;
            }
            if (!this.hasDefaultConstructor(bean)) {
                this.fireSpecViolationEvent(session, new Section("6.10.2.d"));
                status = false;
            }
            if (this.hasFinalizer(bean)) {
                this.fireSpecViolationEvent(session, new Section("6.10.2.e"));
                status = false;
            }
            if (this.hasEJBCreateMethod(bean, true)) {
                Iterator it = this.getEJBCreateMethods(bean);
                while (it.hasNext()) {
                    Method ejbCreate = (Method)it.next();
                    if (!this.isPublic(ejbCreate)) {
                        this.fireSpecViolationEvent(session, ejbCreate, new Section("6.10.3.a"));
                        status = false;
                    }
                    if (this.isFinal(ejbCreate) || this.isStatic(ejbCreate)) {
                        this.fireSpecViolationEvent(session, ejbCreate, new Section("6.10.3.b"));
                        status = false;
                    }
                    if (!this.hasVoidReturnType(ejbCreate)) {
                        this.fireSpecViolationEvent(session, ejbCreate, new Section("6.10.3.c"));
                        status = false;
                    }
                    if (this.hasLegalRMIIIOPArguments(ejbCreate)) continue;
                    this.fireSpecViolationEvent(session, ejbCreate, new Section("6.10.3.d"));
                    status = false;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.fireSpecViolationEvent(session, new Section("16.2.b"));
            status = false;
        }
        return status;
    }

    private boolean verifySessionHome(SessionMetaData session) {
        boolean status = true;
        String name = session.getHome();
        if (name == null) {
            return false;
        }
        try {
            Class<?> home = this.classloader.loadClass(name);
            if (session.isStateless()) {
                if (!this.hasDefaultCreateMethod(home)) {
                    this.fireSpecViolationEvent(session, new Section("6.8.a"));
                    status = false;
                } else {
                    Method create = this.getDefaultCreateMethod(home);
                    if (!this.hasRemoteReturnType(session, create)) {
                        this.fireSpecViolationEvent(session, create, new Section("6.8.b"));
                        status = false;
                    }
                    if (this.hasMoreThanOneCreateMethods(home)) {
                        this.fireSpecViolationEvent(session, new Section("6.8.c"));
                        status = false;
                    }
                }
            }
            if (!this.hasEJBHomeInterface(home)) {
                this.fireSpecViolationEvent(session, new Section("6.10.6.a"));
                status = false;
            }
            Iterator<Method> it = Arrays.asList(home.getMethods()).iterator();
            while (it.hasNext()) {
                Method method = it.next();
                if (!this.hasLegalRMIIIOPArguments(method)) {
                    this.fireSpecViolationEvent(session, method, new Section("6.10.6.b"));
                    status = false;
                }
                if (!this.hasLegalRMIIIOPReturnType(method)) {
                    this.fireSpecViolationEvent(session, method, new Section("6.10.6.c"));
                    status = false;
                }
                if (this.throwsRemoteException(method)) continue;
                this.fireSpecViolationEvent(session, method, new Section("6.10.6.d"));
                status = false;
            }
            if (!this.hasCreateMethod(home)) {
                this.fireSpecViolationEvent(session, new Section("6.10.6.e"));
                status = false;
            }
            Iterator createMethods = this.getCreateMethods(home);
            try {
                String beanClass = session.getEjbClass();
                Class<?> bean = this.classloader.loadClass(beanClass);
                while (createMethods.hasNext()) {
                    Method ejbCreate;
                    Method create = (Method)createMethods.next();
                    if (!this.hasMatchingEJBCreate(bean, create)) {
                        this.fireSpecViolationEvent(session, create, new Section("6.10.6.f"));
                        status = false;
                    }
                    if (!this.hasRemoteReturnType(session, create)) {
                        this.fireSpecViolationEvent(session, create, new Section("6.10.6.g"));
                        status = false;
                    }
                    if (this.hasMatchingEJBCreate(bean, create) && !this.hasMatchingExceptions(ejbCreate = this.getMatchingEJBCreate(bean, create), create)) {
                        this.fireSpecViolationEvent(session, create, new Section("6.10.6.h"));
                    }
                    if (this.throwsCreateException(create)) continue;
                    this.fireSpecViolationEvent(session, create, new Section("6.10.6.i"));
                    status = false;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.fireSpecViolationEvent(session, new Section("16.2.c"));
            status = false;
        }
        return status;
    }

    private boolean verifySessionRemote(SessionMetaData session) {
        boolean status = true;
        String name = session.getRemote();
        if (name == null) {
            return false;
        }
        try {
            Class<?> remote = this.classloader.loadClass(name);
            if (!this.hasEJBObjectInterface(remote)) {
                this.fireSpecViolationEvent(session, new Section("6.10.5.a"));
                status = false;
            }
            Iterator<Method> it = Arrays.asList(remote.getMethods()).iterator();
            while (it.hasNext()) {
                Method method = it.next();
                if (!this.hasLegalRMIIIOPArguments(method)) {
                    this.fireSpecViolationEvent(session, method, new Section("6.10.5.b"));
                    status = false;
                }
                if (!this.hasLegalRMIIIOPReturnType(method)) {
                    this.fireSpecViolationEvent(session, method, new Section("6.10.5.c"));
                    status = false;
                }
                if (this.throwsRemoteException(method)) continue;
                this.fireSpecViolationEvent(session, method, new Section("6.10.5.d"));
                status = false;
            }
            String beanName = session.getEjbClass();
            Class<?> bean = this.classloader.loadClass(beanName);
            Iterator<Method> iterator = Arrays.asList(remote.getDeclaredMethods()).iterator();
            while (iterator.hasNext()) {
                Method remoteMethod = iterator.next();
                if (!this.hasMatchingMethod(bean, remoteMethod)) {
                    this.fireSpecViolationEvent(session, remoteMethod, new Section("6.10.5.e"));
                    status = false;
                }
                if (!this.hasMatchingMethod(bean, remoteMethod)) continue;
                try {
                    Method beanMethod = bean.getMethod(remoteMethod.getName(), remoteMethod.getParameterTypes());
                    if (!this.hasMatchingReturnType(remoteMethod, beanMethod)) {
                        this.fireSpecViolationEvent(session, remoteMethod, new Section("6.10.5.f"));
                        status = false;
                    }
                    if (this.hasMatchingExceptions(beanMethod, remoteMethod)) continue;
                    this.fireSpecViolationEvent(session, remoteMethod, new Section("6.10.5.g"));
                    status = false;
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.fireSpecViolationEvent(session, new Section("16.2.d"));
            status = false;
        }
        return status;
    }
}

