/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.verifier;

import java.net.URL;
import java.util.Iterator;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.MessageDrivenMetaData;
import org.jboss.metadata.SessionMetaData;
import org.jboss.verifier.event.VerificationEvent;
import org.jboss.verifier.event.VerificationEventGeneratorSupport;
import org.jboss.verifier.event.VerificationListener;
import org.jboss.verifier.factory.DefaultEventFactory;
import org.jboss.verifier.factory.VerificationEventFactory;
import org.jboss.verifier.strategy.EJBVerifier11;
import org.jboss.verifier.strategy.EJBVerifier20;
import org.jboss.verifier.strategy.VerificationContext;
import org.jboss.verifier.strategy.VerificationStrategy;

public class BeanVerifier
implements VerificationContext {
    private ApplicationMetaData ejbMetaData = null;
    private URL ejbURL = null;
    private ClassLoader ejbClassLoader = null;
    private VerificationStrategy verifier = null;
    private VerificationEventGeneratorSupport events = new VerificationEventGeneratorSupport();
    private VerificationEventFactory eventFactory = new DefaultEventFactory();
    private static final String UNRECOGNIZED_VERSION = "Unknown version string";

    public void addVerificationListener(VerificationListener listener) {
        this.events.addVerificationListener(listener);
    }

    public void fireBeanChecked(VerificationEvent event) {
        this.events.fireBeanChecked(event);
    }

    public void fireSpecViolation(VerificationEvent event) {
        this.events.fireSpecViolation(event);
    }

    public ApplicationMetaData getApplicationMetaData() {
        return this.ejbMetaData;
    }

    public ClassLoader getClassLoader() {
        return this.ejbClassLoader;
    }

    public String getEJBVersion() {
        return "Enterprise JavaBeans v1.1, Final Release";
    }

    public URL getJarLocation() {
        return this.ejbURL;
    }

    protected VerificationStrategy getVerifier() {
        return this.verifier;
    }

    public void removeVerificationListener(VerificationListener listener) {
        this.events.removeVerificationListener(listener);
    }

    protected void setVerifier(String version) {
        if ("Enterprise JavaBeans v1.1, Final Release".equals(version)) {
            this.verifier = new EJBVerifier11(this);
        } else if ("No public release yet.".equals(version)) {
            this.verifier = new EJBVerifier20(this);
        } else {
            throw new IllegalArgumentException("Unknown version string: " + version);
        }
    }

    public void verify(URL url, ApplicationMetaData metaData) {
        this.verify(url, metaData, null);
    }

    public void verify(URL url, ApplicationMetaData metaData, ClassLoader cl) {
        this.ejbURL = url;
        this.ejbMetaData = metaData;
        this.ejbClassLoader = cl;
        this.setVerifier("Enterprise JavaBeans v1.1, Final Release");
        Iterator beans = this.ejbMetaData.getEnterpriseBeans();
        while (beans.hasNext()) {
            BeanMetaData bean = (BeanMetaData)beans.next();
            if (bean.isEntity()) {
                this.verifier.checkEntity((EntityMetaData)bean);
                continue;
            }
            if (bean.isSession()) {
                this.verifier.checkSession((SessionMetaData)bean);
                continue;
            }
            this.verifier.checkMessageBean((MessageDrivenMetaData)bean);
        }
    }
}

