/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import org.jboss.util.Executable;
import org.jboss.util.Heap;
import org.jboss.util.TimerTask;
import org.jboss.util.WorkerQueue;

public class TimerQueue
extends WorkerQueue {
    private Heap m_heap = new Heap();

    public TimerQueue() {
        this("TimerTask Thread");
    }

    public TimerQueue(String threadName) {
        super(threadName);
    }

    protected void clear() {
        super.clear();
        TimerQueue timerQueue = this;
        synchronized (timerQueue) {
            this.m_heap.clear();
        }
    }

    protected Runnable createQueueLoop() {
        return new TimerTaskLoop();
    }

    protected Executable getJobImpl() throws InterruptedException {
        while (this.m_heap.peek() == null) {
            this.wait();
        }
        TimerTask task = (TimerTask)this.m_heap.extract();
        switch (task.getState()) {
            case 3: 
            case 4: {
                return this.getJobImpl();
            }
            case 1: 
            case 2: {
                return task;
            }
        }
        throw new IllegalStateException("TimerTask has an illegal state");
    }

    protected void putJobImpl(Executable task) {
        this.m_heap.insert(task);
        ((TimerTask)task).setState(2);
        this.notifyAll();
    }

    public void schedule(TimerTask t) {
        this.schedule(t, 0L);
    }

    public void schedule(TimerTask t, long delay) {
        if (t == null) {
            throw new IllegalArgumentException("Can't schedule a null TimerTask");
        }
        if (delay < 0L) {
            delay = 0L;
        }
        t.setNextExecutionTime(System.currentTimeMillis() + delay);
        this.putJob(t);
    }

    protected class TimerTaskLoop
    implements Runnable {
        protected TimerTaskLoop() {
        }

        public void run() {
            try {
                while (true) {
                    try {
                        while (true) {
                            boolean runTask;
                            TimerTask task = (TimerTask)TimerQueue.this.getJob();
                            long now = System.currentTimeMillis();
                            long executionTime = task.getNextExecutionTime();
                            long timeToWait = executionTime - now;
                            boolean bl = runTask = timeToWait <= 0L;
                            if (!runTask) {
                                TimerQueue mutex;
                                TimerQueue.this.putJob(task);
                                TimerQueue timerQueue = mutex = TimerQueue.this;
                                synchronized (timerQueue) {
                                    mutex.wait(timeToWait);
                                }
                            }
                            if (task.isPeriodic()) {
                                task.setNextExecutionTime(executionTime + task.getPeriod());
                                TimerQueue.this.putJob(task);
                            } else {
                                task.setState(3);
                            }
                            task.execute();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                        continue;
                    }
                    break;
                }
                Object var2_9 = null;
                TimerQueue.this.clear();
            }
            catch (Throwable throwable) {
                Object var2_10 = null;
                TimerQueue.this.clear();
                throw throwable;
            }
        }
    }
}

