/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.util.Service;
import org.jboss.util.ServiceControlMBean;

public class ServiceControl
implements ServiceControlMBean,
MBeanRegistration {
    public static final String OBJECT_NAME = ":service=ServiceControl";
    static Logger log = Logger.getLogger(class$org$jboss$util$ServiceControl != null ? class$org$jboss$util$ServiceControl : (class$org$jboss$util$ServiceControl = ServiceControl.class$("org.jboss.util.ServiceControl")));
    List mbeans = new ArrayList();
    static /* synthetic */ Class class$org$jboss$util$ServiceControl;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void destroy() {
        log.info("Destroying " + this.mbeans.size() + " MBeans");
        ArrayList mbeansCopy = new ArrayList(this.mbeans);
        ListIterator listIterator = mbeansCopy.listIterator();
        int serviceCounter = 0;
        while (listIterator.hasNext()) {
            listIterator.next();
        }
        while (listIterator.hasPrevious()) {
            Service service = (Service)listIterator.previous();
            try {
                service.destroy();
                ++serviceCounter;
            }
            catch (Throwable e) {
                log.error("Could not destroy" + service, e);
            }
        }
        log.info("Destroyed " + mbeansCopy.size() + " services");
    }

    public void init() throws Exception {
        log.info("Initializing " + this.mbeans.size() + " MBeans");
        ArrayList mbeansCopy = new ArrayList(this.mbeans);
        Iterator iterator = mbeansCopy.iterator();
        int serviceCounter = 0;
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            try {
                service.init();
                ++serviceCounter;
            }
            catch (Throwable e) {
                log.error("Could not initialize " + service, e);
            }
        }
        log.info("Initialized " + mbeansCopy.size() + " services");
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return name == null ? new ObjectName(OBJECT_NAME) : name;
    }

    public void register(Service service) {
        this.mbeans.add(service);
    }

    public void start() throws Exception {
        log.info("Starting " + this.mbeans.size() + " MBeans");
        ArrayList mbeansCopy = new ArrayList(this.mbeans);
        Iterator iterator = mbeansCopy.iterator();
        int serviceCounter = 0;
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            try {
                service.start();
                ++serviceCounter;
            }
            catch (Throwable e) {
                log.error("Could not start " + service, e);
            }
        }
        log.info("Started " + mbeansCopy.size() + " services");
    }

    public void stop() {
        log.info("Stopping " + this.mbeans.size() + " MBeans");
        ArrayList mbeansCopy = new ArrayList(this.mbeans);
        ListIterator listIterator = mbeansCopy.listIterator();
        int serviceCounter = 0;
        while (listIterator.hasNext()) {
            listIterator.next();
        }
        while (listIterator.hasPrevious()) {
            Service service = (Service)listIterator.previous();
            try {
                service.stop();
                ++serviceCounter;
            }
            catch (Throwable e) {
                log.error("Could not stop " + service, e);
            }
        }
        log.info("Stopped " + mbeansCopy.size() + " services");
    }

    public void unregister(Service service) {
        this.mbeans.remove(service);
    }
}

