/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.plugins.tyrex;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.transaction.TransactionManager;
import org.jboss.tm.plugins.tyrex.TransactionManagerServiceMBean;
import org.jboss.tm.plugins.tyrex.TyrexTransactionPropagationContextManager;
import org.jboss.util.ServiceMBeanSupport;
import org.omg.CosTransactions.TransactionFactory;
import tyrex.tm.TransactionDomain;

public class TransactionManagerService
extends ServiceMBeanSupport
implements TransactionManagerServiceMBean,
ObjectFactory {
    public static String JNDI_NAME = "java:/TransactionManager";
    public static String JNDI_TPC_SENDER = "java:/TPCSender";
    public static String JNDI_TPC_RECEIVER = "java:/TPCReceiver";
    public static String JNDI_IMPORTER = "java:/TransactionPropagationContextImporter";
    public static String JNDI_EXPORTER = "java:/TransactionPropagationContextExporter";
    MBeanServer server;
    String configFile = "domain.xml";
    static TransactionDomain txDomain = null;
    static TransactionManager tm = null;
    static TransactionFactory txFactory = null;
    static TyrexTransactionPropagationContextManager tpcManager = null;

    private void bindRef(String jndiName, String className) throws NamingException {
        Reference ref = new Reference(className, this.getClass().getName(), null);
        new InitialContext().bind(jndiName, (Object)ref);
    }

    public String getConfigFileName() {
        return this.configFile;
    }

    public String getName() {
        return "Tyrex Transaction manager";
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        NameParser parser;
        Name tmName = null;
        Name senderName = null;
        Name receiverName = null;
        Name exporterName = null;
        Name importerName = null;
        if (nameCtx != null) {
            parser = nameCtx.getNameParser(nameCtx.getNameInNamespace());
        } else {
            InitialContext ctx = new InitialContext();
            parser = ctx.getNameParser(ctx.getNameInNamespace());
        }
        try {
            tmName = parser.parse("TransactionManager");
            senderName = parser.parse("TPCSender");
            receiverName = parser.parse("TPCReceiver");
            exporterName = parser.parse("TransactionPropagationContextImporter");
            importerName = parser.parse("TransactionPropagationContextExporter");
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        if (name.endsWith(tmName)) {
            return tm;
        }
        if (name.endsWith(senderName) || name.endsWith(receiverName)) {
            return txFactory;
        }
        if (name.endsWith(exporterName) || name.endsWith(importerName)) {
            return tpcManager;
        }
        this.log.warn("TransactionManagerService: requested an unknown object:" + name);
        return null;
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        this.server = server;
        return new ObjectName(":service=TransactionManager");
    }

    public void setConfigFileName(String name) throws IOException {
        try {
            URL url = new URL(name);
            this.configFile = url.toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            URL url = loader.getResource(name);
            if (url == null) {
                String msg = "Failed to find name: " + name + " as either a URL or a classpath resource";
                this.log.error(msg);
                throw new IOException(msg);
            }
            this.configFile = url.toExternalForm();
        }
        this.log.info("Using configFile: " + this.configFile);
    }

    protected void startService() throws Exception {
        if (txDomain == null) {
            txDomain = TransactionDomain.createDomain((String)this.configFile);
            txDomain.recover();
            tm = txDomain.getTransactionManager();
            txFactory = txDomain.getTransactionFactory();
        }
        this.bindRef(JNDI_NAME, "javax.transaction.TransactionManager");
        this.bindRef(JNDI_TPC_SENDER, "org.omg.CosTSPortability.Sender");
        this.bindRef(JNDI_TPC_RECEIVER, "org.omg.CosTSPortability.Receiver");
        if (tpcManager == null) {
            tpcManager = new TyrexTransactionPropagationContextManager();
        }
        this.bindRef(JNDI_IMPORTER, "org.jboss.tm.TransactionPropagationContextImporter");
        this.bindRef(JNDI_EXPORTER, "org.jboss.tm.TransactionPropagationContextFactory");
    }

    protected void stopService() {
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind(JNDI_NAME);
            ctx.unbind(JNDI_TPC_SENDER);
            ctx.unbind(JNDI_TPC_RECEIVER);
            ctx.unbind(JNDI_IMPORTER);
            ctx.unbind(JNDI_EXPORTER);
        }
        catch (NamingException e) {
            this.log.warn("Failed to stop service", e);
        }
    }
}

