/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.tm.GlobalId;
import org.jboss.tm.TransactionImpl;
import org.jboss.tm.TransactionPropagationContextFactory;
import org.jboss.tm.TransactionPropagationContextImporter;
import org.jboss.tm.TxCapsule;

public class TxManager
implements TransactionManager,
TransactionPropagationContextImporter,
TransactionPropagationContextFactory {
    private static Logger log = Logger.getLogger(class$org$jboss$tm$TxManager != null ? class$org$jboss$tm$TxManager : (class$org$jboss$tm$TxManager = TxManager.class$("org.jboss.tm.TxManager")));
    long timeOut = 300000L;
    private static TxManager singleton = new TxManager();
    private long numTransactions = 0L;
    private long numSuspendedTransactions = 0L;
    private ThreadLocal threadTx = new ThreadLocal();
    private Map globalIdTx = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$org$jboss$tm$TxManager;

    private TxManager() {
    }

    public void associateThread(Transaction transaction) {
        if (transaction != null && !(transaction instanceof TransactionImpl)) {
            throw new RuntimeException("Not a TransactionImpl, but a " + transaction.getClass().getName() + ".");
        }
        this.setTxImpl((TransactionImpl)transaction);
    }

    public void begin() throws NotSupportedException, SystemException {
        TransactionImpl tx;
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null && !current.isDone()) {
            throw new NotSupportedException("Transaction already active, cannot nest transactions.");
        }
        long timeout = ti.timeout == 0L ? this.timeOut : ti.timeout;
        TxCapsule txCapsule = TxCapsule.getInstance(timeout);
        ti.tx = tx = txCapsule.getTransactionImpl();
        this.globalIdTx.put(tx.getGlobalId(), tx);
        ++this.numTransactions;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current == null) {
            throw new IllegalStateException("No transaction.");
        }
        current.commit();
        ti.tx = null;
        --this.numTransactions;
    }

    public Transaction disassociateThread() {
        TransactionImpl current = this.getTxImpl();
        this.setTxImpl(null);
        return current;
    }

    public int getDefaultTransactionTimeout() {
        return (int)(this.timeOut / 1000L);
    }

    public static TxManager getInstance() {
        return singleton;
    }

    public long getNumSuspendedTransactions() {
        return this.numSuspendedTransactions;
    }

    public long getNumTransactions() {
        return this.numTransactions;
    }

    public int getStatus() throws SystemException {
        TransactionImpl current = this.getTxImpl();
        if (current != null) {
            return current.getStatus();
        }
        return 6;
    }

    private ThreadInfo getThreadInfo() {
        ThreadInfo ret = (ThreadInfo)this.threadTx.get();
        if (ret == null) {
            ret = new ThreadInfo();
            ret.timeout = this.timeOut;
            this.threadTx.set(ret);
        }
        return ret;
    }

    public Transaction getTransaction() throws SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null && current.isDone()) {
            ti.tx = null;
            return null;
        }
        return current;
    }

    public Object getTransactionPropagationContext() {
        return this.getTransactionPropagationContext(this.getTxImpl());
    }

    public Object getTransactionPropagationContext(Transaction tx) {
        if (tx == null || !(tx instanceof TransactionImpl)) {
            return null;
        }
        return ((TransactionImpl)tx).getGlobalId();
    }

    private TransactionImpl getTxImpl() {
        return this.getThreadInfo().tx;
    }

    public Transaction importTransactionPropagationContext(Object tpc) {
        if (tpc instanceof GlobalId) {
            return (Transaction)this.globalIdTx.get((GlobalId)tpc);
        }
        log.warn("Cannot import transaction propagation context: " + tpc.toString());
        return null;
    }

    void releaseTransactionImpl(TransactionImpl tx) {
        this.globalIdTx.remove(tx.getGlobalId());
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (transaction != null && !(transaction instanceof TransactionImpl)) {
            throw new RuntimeException("Not a TransactionImpl, but a " + transaction.getClass().getName() + ".");
        }
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            throw new IllegalStateException("Already associated with a tx");
        }
        if (current != transaction) {
            ti.tx = (TransactionImpl)transaction;
        }
        --this.numSuspendedTransactions;
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current == null) {
            throw new IllegalStateException("No transaction.");
        }
        current.rollback();
        ti.tx = null;
        --this.numTransactions;
    }

    public void setDefaultTransactionTimeout(int seconds) {
        this.timeOut = 1000L * (long)seconds;
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        TransactionImpl current = this.getTxImpl();
        if (current == null) {
            throw new IllegalStateException("No transaction.");
        }
        current.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.getThreadInfo().timeout = 1000 * seconds;
    }

    private void setTxImpl(TransactionImpl tx) {
        this.getThreadInfo().tx = tx;
    }

    public Transaction suspend() throws SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            ti.tx = null;
        }
        ++this.numSuspendedTransactions;
        return current;
    }

    static class ThreadInfo {
        long timeout = 0L;
        TransactionImpl tx = null;

        ThreadInfo() {
        }
    }
}

