/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import org.jboss.proxy.InvocationHandler;
import org.jboss.proxy.Proxies;
import org.jboss.proxy.ProxyAssembler;
import org.jboss.proxy.ProxyProxy;

class ProxyCompiler {
    Class superclass;
    Runtime runtime;
    Class[] targetTypes;
    Method[] methods;
    Class proxyType;
    private static String IMPL_SUFFIX = "$Proxy";
    private static String INFO_FIELD = "$info";
    private static String InvocationHandler_FIELD = "$InvocationHandler";
    private static final Class[] invokeParams = new Class[]{class$org$jboss$proxy$InvocationHandler != null ? class$org$jboss$proxy$InvocationHandler : (class$org$jboss$proxy$InvocationHandler = ProxyCompiler.class$("org.jboss.proxy.InvocationHandler")), Integer.TYPE, array$Ljava$lang$Object != null ? array$Ljava$lang$Object : (array$Ljava$lang$Object = ProxyCompiler.class$("[Ljava.lang.Object;"))};
    private static final Class[] toStringParams = new Class[]{class$org$jboss$proxy$Proxies$ProxyTarget != null ? class$org$jboss$proxy$Proxies$ProxyTarget : (class$org$jboss$proxy$Proxies$ProxyTarget = ProxyCompiler.class$("org.jboss.proxy.Proxies$ProxyTarget"))};
    static /* synthetic */ Class class$org$jboss$proxy$InvocationHandler;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$org$jboss$proxy$Proxies$ProxyTarget;
    static /* synthetic */ Class class$org$jboss$proxy$ProxyCompiler$Runtime;
    static /* synthetic */ Class array$Ljava$lang$Class;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    ProxyCompiler(ClassLoader parent, Class superclass, Class[] targetTypes, Method[] methods) {
        this.superclass = superclass;
        this.targetTypes = targetTypes;
        this.methods = methods;
        this.runtime = new Runtime(parent);
        this.runtime.targetTypes = targetTypes;
        this.runtime.methods = methods;
        this.runtime.makeProxyType(this);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private byte[] getCode() {
        String pClass = this.getProxyClassName();
        int icount = 1;
        int i = 0;
        while (i < this.targetTypes.length) {
            Class targetType = this.targetTypes[i];
            if (targetType.isInterface()) {
                ++icount;
            }
            ++i;
        }
        Class[] interfaces = new Class[icount];
        interfaces[0] = class$org$jboss$proxy$Proxies$ProxyTarget != null ? class$org$jboss$proxy$Proxies$ProxyTarget : (class$org$jboss$proxy$Proxies$ProxyTarget = ProxyCompiler.class$("org.jboss.proxy.Proxies$ProxyTarget"));
        icount = 1;
        int i2 = 0;
        while (i2 < this.targetTypes.length) {
            Class targetType = this.targetTypes[i2];
            if (targetType.isInterface()) {
                interfaces[icount++] = targetType;
            } else if (!this.superclass.isAssignableFrom(targetType)) {
                throw new RuntimeException("unexpected: " + targetType);
            }
            ++i2;
        }
        ProxyAssembler asm = new ProxyAssembler(pClass, 17, this.superclass, interfaces);
        Class rClass = class$org$jboss$proxy$ProxyCompiler$Runtime != null ? class$org$jboss$proxy$ProxyCompiler$Runtime : (class$org$jboss$proxy$ProxyCompiler$Runtime = ProxyCompiler.class$("org.jboss.proxy.ProxyCompiler$Runtime"));
        asm.addMember(9, rClass, null, INFO_FIELD);
        Class iClass = class$org$jboss$proxy$InvocationHandler != null ? class$org$jboss$proxy$InvocationHandler : (class$org$jboss$proxy$InvocationHandler = ProxyCompiler.class$("org.jboss.proxy.InvocationHandler"));
        asm.addMember(2, iClass, null, InvocationHandler_FIELD);
        asm.addMember(1, iClass, "getInvocationHandler", new Class[0], null);
        asm.pushLocal(0);
        asm.pushField(asm, InvocationHandler_FIELD);
        asm.ret();
        asm.addMember(1, array$Ljava$lang$Class != null ? array$Ljava$lang$Class : (array$Ljava$lang$Class = ProxyCompiler.class$("[Ljava.lang.Class;")), "getTargetTypes", new Class[0], null);
        asm.pushLocal(0);
        asm.pushField(asm, INFO_FIELD);
        asm.invoke(rClass, "copyTargetTypes", new Class[0]);
        asm.ret();
        boolean haveToString = false;
        int i3 = 0;
        while (i3 < this.methods.length) {
            Method m = this.methods[i3];
            String name = m.getName();
            Class<?> rtype = m.getReturnType();
            Class[] ptypes = m.getParameterTypes();
            Class[] exceptions = m.getExceptionTypes();
            if (name.equals("toString") && ptypes.length == 0) {
                haveToString = true;
            }
            asm.addMember(17, rtype, name, ptypes, exceptions);
            asm.pushField(asm, INFO_FIELD);
            asm.pushLocal(0);
            asm.pushField(asm, InvocationHandler_FIELD);
            asm.pushConstant(i3);
            if (ptypes.length == 0) {
                asm.pushField(rClass, "NOARGS");
            } else {
                asm.pushConstant(ptypes.length);
                asm.pushNewArray(class$java$lang$Object != null ? class$java$lang$Object : ProxyCompiler.class$("java.lang.Object"));
                int j = 0;
                while (j < ptypes.length) {
                    Class t = ptypes[j];
                    asm.dup();
                    asm.pushConstant(j);
                    asm.pushLocal(1 + j);
                    if (t.isPrimitive()) {
                        asm.invoke(rClass, "wrap", new Class[]{t});
                    }
                    asm.setElement(class$java$lang$Object != null ? class$java$lang$Object : ProxyCompiler.class$("java.lang.Object"));
                    ++j;
                }
            }
            String invoke = "invoke";
            if (rtype.isPrimitive() && rtype != Void.TYPE) {
                String tn = rtype.getName();
                invoke = String.valueOf(invoke) + Character.toUpperCase(tn.charAt(0)) + tn.substring(1);
            }
            asm.invoke(rClass, invoke, invokeParams);
            if (!rtype.isPrimitive() && rtype != (class$java$lang$Object != null ? class$java$lang$Object : ProxyCompiler.class$("java.lang.Object"))) {
                asm.checkCast(rtype);
            }
            asm.ret();
            ++i3;
        }
        if (!haveToString) {
            asm.addMember(1, class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ProxyCompiler.class$("java.lang.String")), "toString", new Class[0], null);
            asm.pushLocal(0);
            asm.invoke(rClass, "toString", toStringParams);
            asm.ret();
        }
        asm.addMember(1, Void.TYPE, "<init>", new Class[]{iClass}, null);
        asm.pushLocal(0);
        asm.invoke(this.superclass, "<init>", new Class[0]);
        asm.pushLocal(0);
        asm.pushLocal(1);
        asm.setField(asm, InvocationHandler_FIELD);
        asm.ret();
        return asm.getCode();
    }

    String getProxyClassName() {
        String tName = this.targetTypes[0].getName();
        return String.valueOf(tName) + IMPL_SUFFIX;
    }

    Class getProxyType() {
        return this.proxyType;
    }

    public static class Runtime
    extends ClassLoader {
        private ClassLoader parent;
        Class[] targetTypes;
        Method[] methods;
        ProxyCompiler compiler;
        public static final Object[] NOARGS = new Object[0];

        public Runtime(ClassLoader parent) {
            super(parent);
            this.parent = parent;
        }

        public Class[] copyTargetTypes() {
            try {
                return (Class[])this.targetTypes.clone();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return new Class[0];
            }
        }

        public URL getResource(String name) {
            ClassLoader cl = this.getTargetClassLoader();
            if (cl == null) {
                return ClassLoader.getSystemResource(name);
            }
            return cl.getResource(name);
        }

        public InputStream getResourceAsStream(String name) {
            ClassLoader cl = this.getTargetClassLoader();
            if (cl == null) {
                return ClassLoader.getSystemResourceAsStream(name);
            }
            return cl.getResourceAsStream(name);
        }

        ClassLoader getTargetClassLoader() {
            return this.parent;
        }

        public Object invoke(InvocationHandler invocationHandler, int methodNum, Object[] values) throws Throwable {
            Method method = this.methods[methodNum];
            if (method.getName().equals("writeReplace")) {
                return new ProxyProxy(invocationHandler, this.copyTargetTypes());
            }
            return invocationHandler.invoke(null, this.methods[methodNum], values);
        }

        public boolean invokeBoolean(InvocationHandler InvocationHandler2, int methodNum, Object[] values) throws Throwable {
            Object result = this.invoke(InvocationHandler2, methodNum, values);
            return (Boolean)result;
        }

        public byte invokeByte(InvocationHandler InvocationHandler2, int methodNum, Object[] values) throws Throwable {
            Object result = this.invoke(InvocationHandler2, methodNum, values);
            return ((Number)result).byteValue();
        }

        public char invokeChar(InvocationHandler InvocationHandler2, int methodNum, Object[] values) throws Throwable {
            Object result = this.invoke(InvocationHandler2, methodNum, values);
            return ((Character)result).charValue();
        }

        public double invokeDouble(InvocationHandler InvocationHandler2, int methodNum, Object[] values) throws Throwable {
            Object result = this.invoke(InvocationHandler2, methodNum, values);
            return ((Number)result).doubleValue();
        }

        public float invokeFloat(InvocationHandler InvocationHandler2, int methodNum, Object[] values) throws Throwable {
            Object result = this.invoke(InvocationHandler2, methodNum, values);
            return ((Number)result).floatValue();
        }

        public int invokeInt(InvocationHandler InvocationHandler2, int methodNum, Object[] values) throws Throwable {
            Object result = this.invoke(InvocationHandler2, methodNum, values);
            return ((Number)result).intValue();
        }

        public long invokeLong(InvocationHandler InvocationHandler2, int methodNum, Object[] values) throws Throwable {
            Object result = this.invoke(InvocationHandler2, methodNum, values);
            return ((Number)result).longValue();
        }

        public short invokeShort(InvocationHandler InvocationHandler2, int methodNum, Object[] values) throws Throwable {
            Object result = this.invoke(InvocationHandler2, methodNum, values);
            return ((Number)result).shortValue();
        }

        public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name.endsWith(IMPL_SUFFIX) && name.equals(this.compiler.getProxyClassName())) {
                return this.compiler.proxyType;
            }
            ClassLoader cl = this.getTargetClassLoader();
            if (cl == null) {
                return super.findSystemClass(name);
            }
            return cl.loadClass(name);
        }

        void makeProxyType(ProxyCompiler compiler) {
            this.compiler = compiler;
            byte[] code = compiler.getCode();
            compiler.proxyType = super.defineClass(compiler.getProxyClassName(), code, 0, code.length);
            super.resolveClass(compiler.proxyType);
            try {
                Field infoField = compiler.proxyType.getField(INFO_FIELD);
                infoField.set(null, this);
            }
            catch (IllegalAccessException ee) {
                throw new RuntimeException("unexpected: " + ee);
            }
            catch (NoSuchFieldException ee) {
                throw new RuntimeException("unexpected: " + ee);
            }
            compiler = null;
        }

        public static String toString(Proxies.ProxyTarget target) {
            InvocationHandler invocationHandler = target.getInvocationHandler();
            return "ProxyTarget[" + invocationHandler + "]";
        }

        public static Byte wrap(byte x) {
            return new Byte(x);
        }

        public static Character wrap(char x) {
            return new Character(x);
        }

        public static Double wrap(double x) {
            return new Double(x);
        }

        public static Float wrap(float x) {
            return new Float(x);
        }

        public static Integer wrap(int x) {
            return new Integer(x);
        }

        public static Long wrap(long x) {
            return new Long(x);
        }

        public static Short wrap(short x) {
            return new Short(x);
        }

        public static Boolean wrap(boolean x) {
            return new Boolean(x);
        }
    }
}

