/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.jboss.logging.Logger;
import org.jboss.proxy.InvocationHandler;
import org.jboss.proxy.ProxyCompiler;

public final class Proxies {
    static Logger log = Logger.getLogger(class$org$jboss$proxy$Proxies != null ? class$org$jboss$proxy$Proxies : (class$org$jboss$proxy$Proxies = Proxies.class$("org.jboss.proxy.Proxies")));
    static /* synthetic */ Class class$org$jboss$proxy$Proxies;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$jboss$proxy$InvocationHandler;

    private Proxies() {
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static InvocationHandler getInvocationHandler(Object target, Class targetType) {
        if (targetType == null) {
            return Proxies.getInvocationHandler(target, null);
        }
        return Proxies.getInvocationHandler(target, new Class[]{targetType});
    }

    public static InvocationHandler getInvocationHandler(Object target, Class[] targetTypes) {
        if (target instanceof ProxyTarget) {
            ProxyTarget tproxy = (ProxyTarget)target;
            InvocationHandler InvocationHandler2 = tproxy.getInvocationHandler();
            if (targetTypes == null || Impl.sameTypes(tproxy.getTargetTypes(), targetTypes)) {
                return InvocationHandler2;
            }
        }
        return Proxies.newInvocationHandler(target, targetTypes);
    }

    public static Method[] getMethods(Class targetType) {
        return Impl.getImpl(targetType).copyMethods();
    }

    public static Method[] getMethods(Class[] targetTypes) {
        return Impl.getImpl(targetTypes).copyMethods();
    }

    public static Object getTarget(InvocationHandler InvocationHandler2) {
        Object target;
        if (InvocationHandler2 instanceof ProxyInvocationHandler && (target = ((ProxyInvocationHandler)InvocationHandler2).getTarget()) != null) {
            return target;
        }
        return null;
    }

    public static ProxyInvocationHandler newInvocationHandler(Object target, Class targetType) {
        return Impl.getImpl(targetType).newInvocationHandler(target);
    }

    public static ProxyInvocationHandler newInvocationHandler(Object target, Class[] targetTypes) {
        return Impl.getImpl(targetTypes).newInvocationHandler(target);
    }

    public static ProxyTarget newTarget(ClassLoader parent, InvocationHandler InvocationHandler2, Class[] targetTypes) {
        return Impl.getImpl(targetTypes).newTarget(InvocationHandler2, parent);
    }

    public static interface ProxyTarget
    extends Serializable {
        public InvocationHandler getInvocationHandler();

        public Class[] getTargetTypes();
    }

    public static interface ProxyInvocationHandler
    extends InvocationHandler,
    Serializable {
        public Object getTarget();
    }

    static class Impl
    implements Serializable {
        static Hashtable impls = new Hashtable();
        Class[] targetTypes;
        Method[] methods;
        Impl more;
        Class superclass = class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = Proxies.class$("java.lang.Object"));
        String proxyString;
        Constructor proxyConstructor;

        Impl(Class[] targetTypes) {
            this.targetTypes = targetTypes;
            Method[][] methodLists = new Method[targetTypes.length][];
            int i = 0;
            while (i < targetTypes.length) {
                methodLists[i] = this.checkTargetType(targetTypes[i]);
                ++i;
            }
            this.checkSuperclass();
            this.methods = Impl.combineMethodLists(methodLists);
        }

        static boolean checkSameMethod(Method m1, Method m2) {
            Class<?>[] p2;
            if (!m1.getName().equals(m2.getName())) {
                return false;
            }
            Class<?>[] p1 = m1.getParameterTypes();
            if (p1.length != (p2 = m2.getParameterTypes()).length) {
                return false;
            }
            int i = 0;
            while (i < p1.length) {
                if (p1[i] != p2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        void checkSuperclass() {
            Constructor<?>[] constructors = this.superclass.getConstructors();
            int i = 0;
            while (i < constructors.length) {
                Constructor<?> c = constructors[i];
                int mod = c.getModifiers();
                if (Modifier.isPublic(mod) && c.getParameterTypes().length == 0) {
                    return;
                }
                ++i;
            }
            throw new IllegalArgumentException("cannot subclass without nullary constructor: " + this.superclass.getName());
        }

        Method[] checkTargetType(Class targetType) {
            if (targetType.isArray()) {
                throw new IllegalArgumentException("cannot subclass an array type: " + targetType.getName());
            }
            if (targetType.isPrimitive()) {
                throw new IllegalArgumentException("cannot subclass a primitive type: " + targetType);
            }
            int tmod = targetType.getModifiers();
            if (Modifier.isFinal(tmod)) {
                throw new IllegalArgumentException("cannot subclass a final type: " + targetType);
            }
            if (!Modifier.isPublic(tmod)) {
                throw new IllegalArgumentException("cannot subclass a non-public type: " + targetType);
            }
            if (!targetType.isInterface() && !targetType.isAssignableFrom(this.superclass)) {
                if (this.superclass.isAssignableFrom(targetType)) {
                    this.superclass = targetType;
                } else {
                    throw new IllegalArgumentException("inconsistent superclass: " + targetType);
                }
            }
            Method[] methodList = targetType.getMethods();
            int nm = 0;
            int i = 0;
            while (i < methodList.length) {
                Method m = methodList[i];
                if (Impl.eligibleForInvocationHandler(m)) {
                    methodList[nm++] = m;
                }
                ++i;
            }
            while (nm < methodList.length) {
                methodList[nm++] = null;
            }
            return methodList;
        }

        static Method[] combineMethodLists(Method[][] methodLists) {
            int nm = 0;
            int i = 0;
            while (i < methodLists.length) {
                nm += methodLists[i].length;
                ++i;
            }
            Method[] methods = new Method[nm];
            nm = 0;
            int i2 = 0;
            while (i2 < methodLists.length) {
                Method[] mlist = methodLists[i2];
                int prev = nm;
                int j = 0;
                while (j < mlist.length) {
                    block7: {
                        Method m = mlist[j];
                        if (m != null) {
                            int k = 0;
                            while (k < prev) {
                                if (!Impl.checkSameMethod(m, methods[k])) {
                                    ++k;
                                    continue;
                                }
                                break block7;
                            }
                            methods[nm++] = m;
                        }
                    }
                    ++j;
                }
                ++i2;
            }
            Method[] methodsCopy = new Method[nm];
            int i3 = 0;
            while (i3 < nm) {
                methodsCopy[i3] = methods[i3];
                ++i3;
            }
            return methodsCopy;
        }

        static Class[] copyAndUniquify(Class[] targetTypes) {
            int n = targetTypes.length;
            Class[] tt = new Class[n];
            int k = 0;
            int i = 0;
            while (i < n) {
                block5: {
                    Class c = targetTypes[i];
                    int j = i;
                    while (--j >= 0) {
                        if (c != targetTypes[j]) {
                            continue;
                        }
                        break block5;
                    }
                    tt[k++] = c;
                }
                ++i;
            }
            if (k < n) {
                Class[] tt0 = new Class[k];
                int i2 = 0;
                while (i2 < k) {
                    tt0[i2] = tt[i2];
                    ++i2;
                }
                tt = tt0;
            }
            return tt;
        }

        Method[] copyMethods() {
            try {
                return (Method[])this.methods.clone();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return new Method[0];
            }
        }

        Class[] copyTargetTypes() {
            try {
                return (Class[])this.targetTypes.clone();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return new Class[0];
            }
        }

        static boolean eligibleForInvocationHandler(Method m) {
            int mod = m.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) {
                return false;
            }
            return Modifier.isAbstract(mod);
        }

        static synchronized Impl getImpl(Class targetType) {
            Impl impl = (Impl)impls.get(targetType);
            if (impl == null) {
                impl = new Impl(new Class[]{targetType});
                impls.put(targetType, impl);
            }
            return impl;
        }

        static synchronized Impl getImpl(Class[] targetTypes) {
            int n = targetTypes.length;
            if (n == 1) {
                return Impl.getImpl(targetTypes[0]);
            }
            int i = 0;
            while (i < n) {
                Impl impl = (Impl)impls.get(targetTypes[i]);
                while (impl != null) {
                    if (Impl.sameTypes(targetTypes, impl.targetTypes)) {
                        return impl;
                    }
                    impl = impl.more;
                }
                ++i;
            }
            targetTypes = Impl.copyAndUniquify(targetTypes);
            Impl impl1 = Impl.getImpl(new Class[]{targetTypes[0]});
            Impl impl = new Impl(targetTypes);
            impl.more = impl1.more;
            impl1.more = impl;
            return impl;
        }

        Object invoke(Object target, Member method, Object[] values) throws Throwable {
            try {
                Method[] methods = this.methods;
                int i = methods.length;
                while (--i >= 0) {
                    if (methods[i] != method) continue;
                    return methods[i].invoke(target, values);
                }
                if (method == null) {
                    if (methods.length == 1) {
                        return methods[0].invoke(target, values);
                    }
                    throw new IllegalArgumentException("non-unique method");
                }
                int i2 = methods.length;
                while (--i2 >= 0) {
                    if (!methods[i2].equals(method)) continue;
                    return methods[i2].invoke(target, values);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException("method access " + method);
            }
            catch (InvocationTargetException ee) {
                Throwable te = ee.getTargetException();
                if (te instanceof Error) {
                    throw (Error)te;
                }
                if (te instanceof RuntimeException) {
                    throw (RuntimeException)te;
                }
                throw te;
            }
            throw new IllegalArgumentException("method unexpected " + method);
        }

        void makeProxyConstructor(ClassLoader parent) {
            ProxyCompiler pc = new ProxyCompiler(parent, this.superclass, this.targetTypes, this.methods);
            try {
                Class[] type = new Class[]{class$org$jboss$proxy$InvocationHandler != null ? class$org$jboss$proxy$InvocationHandler : (class$org$jboss$proxy$InvocationHandler = Proxies.class$("org.jboss.proxy.InvocationHandler"))};
                this.proxyConstructor = pc.getProxyType().getConstructor(type);
            }
            catch (NoSuchMethodException ee) {
                log.error("unexpected error", ee);
                throw new RuntimeException("unexpected: " + ee);
            }
        }

        ProxyInvocationHandler newInvocationHandler(Object target) {
            if (this.proxyString == null) {
                String s = "InvocationHandler@" + this.targetTypes[0].getName();
                int i = 1;
                while (i < this.targetTypes.length) {
                    s = String.valueOf(s) + "," + this.targetTypes[i].getName();
                    ++i;
                }
                this.proxyString = s;
            }
            return new ProxyInvocationHandler(target, this){
                private final /* synthetic */ Impl this$0;
                private final /* synthetic */ Object val$target;
                {
                    this.val$target = val$target;
                    this.this$0 = this$0;
                }

                public Object getTarget() {
                    return this.val$target;
                }

                public Class[] getTargetTypes() {
                    return this.this$0.copyTargetTypes();
                }

                public Object invoke(Object dummy, Method method, Object[] values) throws Throwable {
                    return this.this$0.invoke(this.val$target, method, values);
                }

                public String toString() {
                    return String.valueOf(this.this$0.proxyString) + "[" + this.val$target + "]";
                }
            };
        }

        ProxyTarget newTarget(InvocationHandler InvocationHandler2, ClassLoader parent) {
            if (this.proxyConstructor == null) {
                try {
                    this.makeProxyConstructor(parent);
                }
                catch (LinkageError ee) {
                    log.error("unexpected error", ee);
                    throw new RuntimeException("unexpected: " + ee);
                }
            }
            try {
                Object[] arg = new Object[]{InvocationHandler2};
                return (ProxyTarget)this.proxyConstructor.newInstance(arg);
            }
            catch (InvocationTargetException ee) {
                throw new RuntimeException("unexpected: " + ee);
            }
            catch (InstantiationException ee) {
                throw new RuntimeException("unexpected: " + ee);
            }
            catch (IllegalAccessException ee) {
                throw new RuntimeException("unexpected: " + ee);
            }
        }

        static boolean sameTypes(Class[] tt1, Class[] tt2) {
            if (tt1.length == 1 && tt2.length == 0) {
                return tt1[0] == tt2[0];
            }
            int totalSeen2 = 0;
            int i = tt1.length;
            block0: while (--i >= 0) {
                Class c = tt1[i];
                int j = i;
                while (--j >= 0) {
                    if (c == tt1[j]) continue block0;
                }
                int seen2 = 0;
                int j2 = tt2.length;
                while (--j2 >= 0) {
                    if (c != tt2[j2]) continue;
                    ++seen2;
                }
                if (seen2 == 0) {
                    return false;
                }
                totalSeen2 += seen2;
            }
            return totalSeen2 != tt2.length;
        }
    }
}

