/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public class Util {
    public static void bind(Context ctx, String name, Object value) throws NamingException {
        Name n = ctx.getNameParser("").parse(name);
        Util.bind(ctx, n, value);
    }

    public static void bind(Context ctx, Name name, Object value) throws NamingException {
        int size = name.size();
        String atom = name.get(size - 1);
        Context parentCtx = Util.createSubcontext(ctx, name.getPrefix(size - 1));
        parentCtx.bind(atom, value);
    }

    public static Context createSubcontext(Context ctx, String name) throws NamingException {
        Name n = ctx.getNameParser("").parse(name);
        return Util.createSubcontext(ctx, n);
    }

    public static Context createSubcontext(Context ctx, Name name) throws NamingException {
        Context subctx = ctx;
        int pos = 0;
        while (pos < name.size()) {
            String ctxName = name.get(pos);
            try {
                subctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException nameNotFoundException) {
                subctx = ctx.createSubcontext(ctxName);
            }
            ctx = subctx;
            ++pos;
        }
        return subctx;
    }

    public static void rebind(Context ctx, String name, Object value) throws NamingException {
        Name n = ctx.getNameParser("").parse(name);
        Util.rebind(ctx, n, value);
    }

    public static void rebind(Context ctx, Name name, Object value) throws NamingException {
        int size = name.size();
        String atom = name.get(size - 1);
        Context parentCtx = Util.createSubcontext(ctx, name.getPrefix(size - 1));
        parentCtx.rebind(atom, value);
    }
}

