/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.naming.NamingAliasMBean;
import org.jboss.util.ServiceMBeanSupport;

public class NamingAlias
extends ServiceMBeanSupport
implements NamingAliasMBean {
    private String fromName;
    private String toName;

    public NamingAlias() {
    }

    public NamingAlias(String fromName, String toName) {
    }

    private void createLinkRef() throws NamingException {
        if (super.getState() == 2 || super.getState() == 3) {
            InitialContext ctx = new InitialContext();
            LinkRef link = new LinkRef(this.toName);
            Context fromCtx = ctx;
            Name name = ctx.getNameParser("").parse(this.fromName);
            String atom = name.get(name.size() - 1);
            int n = 0;
            while (n < name.size() - 1) {
                String comp = name.get(n);
                try {
                    fromCtx = (Context)fromCtx.lookup(comp);
                }
                catch (NameNotFoundException nameNotFoundException) {
                    fromCtx = fromCtx.createSubcontext(comp);
                }
                ++n;
            }
            fromCtx.rebind(atom, (Object)link);
        }
    }

    public String getFromName() {
        return this.fromName;
    }

    public String getName() {
        return "NamingAlias(" + this.fromName + " -> " + this.toName + ")";
    }

    public String getToName() {
        return this.toName;
    }

    private void removeLinkRef(String name) throws NamingException {
        if (super.getState() == 3) {
            InitialContext ctx = new InitialContext();
            ctx.unbind(name);
        }
    }

    public void setFromName(String name) throws NamingException {
        this.removeLinkRef(this.fromName);
        this.fromName = name;
        this.createLinkRef();
    }

    public void setToName(String name) throws NamingException {
        this.toName = name;
        this.createLinkRef();
    }

    public void startService() throws Exception {
        if (this.fromName == null) {
            throw new IllegalStateException("fromName is null");
        }
        if (this.toName == null) {
            throw new IllegalStateException("toName is null");
        }
        this.createLinkRef();
    }

    public void stopService() {
        try {
            this.removeLinkRef(this.fromName);
        }
        catch (Exception exception) {}
    }
}

