/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.ObjectFactory;
import org.jboss.naming.ExternalContextMBean;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.util.ServiceMBeanSupport;

public class ExternalContext
extends ServiceMBeanSupport
implements ExternalContextMBean {
    private boolean remoteAccess;
    private SerializableInitialContext contextInfo = new SerializableInitialContext();
    static /* synthetic */ Class class$javax$naming$InitialContext;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class array$Ljavax$naming$ldap$Control;
    static /* synthetic */ Class class$javax$naming$Context;

    public ExternalContext() {
    }

    public ExternalContext(String jndiName, String contextPropsURL) throws IOException, NamingException {
        this.setJndiName(jndiName);
        this.setProperties(contextPropsURL);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private static Context createContext(Context rootContext, Name name) throws NamingException {
        Context subctx = rootContext;
        int n = 0;
        while (n < name.size()) {
            String atom = name.get(n);
            try {
                Object obj = subctx.lookup(atom);
                subctx = (Context)obj;
            }
            catch (NamingException namingException) {
                subctx = subctx.createSubcontext(atom);
            }
            ++n;
        }
        return subctx;
    }

    public boolean getCacheContext() {
        return this.contextInfo.getCacheContext();
    }

    public String getInitialContext() {
        return this.contextInfo.getInitialContext();
    }

    public String getJndiName() {
        return this.contextInfo.getJndiName();
    }

    public String getName() {
        return "ExternalContext(" + this.contextInfo.getJndiName() + ")";
    }

    public boolean getRemoteAccess() {
        return this.remoteAccess;
    }

    public void initService() throws Exception {
    }

    private void rebind() throws Exception {
        Context ctx = this.contextInfo.newContext();
        InitialContext rootCtx = new InitialContext();
        this.log.debug("ctx=" + ctx + ", env=" + ctx.getEnvironment());
        String jndiName = this.contextInfo.getJndiName();
        Name fullName = rootCtx.getNameParser("").parse(jndiName);
        this.log.debug("fullName=" + fullName);
        Name parentName = fullName;
        parentName = fullName.size() > 1 ? fullName.getPrefix(fullName.size() - 1) : new CompositeName();
        this.log.debug("parentName=" + parentName);
        Context parentCtx = ExternalContext.createContext(rootCtx, parentName);
        this.log.debug("parentCtx=" + parentCtx);
        Name atomName = fullName.getSuffix(fullName.size() - 1);
        String atom = atomName.get(0);
        boolean cacheContext = this.contextInfo.getCacheContext();
        if (this.remoteAccess) {
            parentCtx.rebind(atom, (Object)this.contextInfo);
            if (cacheContext) {
                ctx = CachedContext.createProxyContext(ctx);
                NonSerializableFactory.rebind(jndiName, (Object)ctx);
            }
        } else if (cacheContext) {
            Context proxyCtx = CachedContext.createProxyContext(ctx);
            NonSerializableFactory.rebind(rootCtx, jndiName, proxyCtx);
        } else {
            parentCtx.rebind(atom, (Object)this.contextInfo);
        }
    }

    public void setCacheContext(boolean cacheContext) {
        this.contextInfo.setCacheContext(cacheContext);
    }

    public void setInitialContext(String className) throws ClassNotFoundException {
        this.contextInfo.loadClass(className);
    }

    public void setJndiName(String jndiName) throws NamingException {
        this.contextInfo.setJndiName(jndiName);
        if (super.getState() == 3) {
            this.unbind(jndiName);
            try {
                this.rebind();
            }
            catch (Exception e) {
                NamingException ne = new NamingException("Failed to update jndiName");
                ne.setRootCause(e);
                throw ne;
            }
        }
    }

    public void setProperties(String contextPropsURL) throws IOException {
        this.contextInfo.loadProperties(contextPropsURL);
    }

    public void setRemoteAccess(boolean remoteAccess) {
        this.remoteAccess = remoteAccess;
    }

    public void startService() throws Exception {
        this.rebind();
    }

    public void stopService() {
        if (this.contextInfo.getCacheContext()) {
            this.unbind(this.contextInfo.getJndiName());
        }
    }

    private void unbind(String jndiName) {
        try {
            InitialContext rootCtx = new InitialContext();
            Context ctx = (Context)rootCtx.lookup(jndiName);
            if (ctx != null) {
                ctx.close();
            }
            rootCtx.unbind(jndiName);
            NonSerializableFactory.unbind(jndiName);
        }
        catch (NamingException e) {
            this.log.error("unbind failed", e);
        }
    }

    public static class SerializableInitialContext
    extends RefAddr
    implements Referenceable,
    Serializable,
    ObjectFactory {
        private static final long serialVersionUID = -6512260531255770463L;
        private String jndiName;
        private Class contextClass = class$javax$naming$InitialContext != null ? class$javax$naming$InitialContext : (class$javax$naming$InitialContext = ExternalContext.class$("javax.naming.InitialContext"));
        private Properties contextProps;
        private boolean cacheContext = true;
        private transient Context initialContext;

        public SerializableInitialContext() {
            this("SerializableInitialContext");
        }

        public SerializableInitialContext(String addrType) {
            super(addrType);
        }

        public boolean getCacheContext() {
            return this.cacheContext;
        }

        public Object getContent() {
            return null;
        }

        public String getInitialContext() {
            return this.contextClass.getName();
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
            Reference ref = (Reference)obj;
            SerializableInitialContext sic = (SerializableInitialContext)ref.get(0);
            return sic.newContext();
        }

        public Reference getReference() throws NamingException {
            Reference ref = new Reference((class$javax$naming$Context != null ? class$javax$naming$Context : (class$javax$naming$Context = ExternalContext.class$("javax.naming.Context"))).getName(), this, this.getClass().getName(), null);
            return ref;
        }

        public void loadClass(String className) throws ClassNotFoundException {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            this.contextClass = loader.loadClass(className);
        }

        public void loadProperties(String contextPropsURL) throws IOException {
            InputStream is = null;
            IOException ex = null;
            this.contextProps = new Properties();
            try {
                URL url = new URL(contextPropsURL);
                is = url.openStream();
                this.contextProps.load(is);
                return;
            }
            catch (IOException e) {
                is = null;
                ex = e;
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(contextPropsURL);
                if (is == null) {
                    if (ex != null) {
                        throw ex;
                    }
                    throw new IOException("Failed to locate context props as URL or resource:" + contextPropsURL);
                }
                this.contextProps.load(is);
                return;
            }
        }

        Context newContext() throws Exception {
            this.initialContext = (Context)NonSerializableFactory.lookup(this.jndiName);
            if (this.initialContext == null) {
                this.initialContext = SerializableInitialContext.newContext(this.contextClass, this.contextProps);
            }
            return this.initialContext;
        }

        static Context newContext(Class contextClass, Properties contextProps) throws Exception {
            Context ctx = null;
            try {
                ctx = SerializableInitialContext.newDefaultContext(contextClass, contextProps);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ctx = SerializableInitialContext.newLdapContext(contextClass, contextProps);
            }
            return ctx;
        }

        private static Context newDefaultContext(Class contextClass, Properties contextProps) throws Exception {
            Context ctx = null;
            Class[] types = new Class[]{class$java$util$Hashtable != null ? class$java$util$Hashtable : (class$java$util$Hashtable = ExternalContext.class$("java.util.Hashtable"))};
            Constructor ctor = contextClass.getConstructor(types);
            Object[] args = new Object[]{contextProps};
            ctx = (Context)ctor.newInstance(args);
            return ctx;
        }

        private static Context newLdapContext(Class contextClass, Properties contextProps) throws Exception {
            Context ctx = null;
            Class[] types = new Class[]{class$java$util$Hashtable != null ? class$java$util$Hashtable : (class$java$util$Hashtable = ExternalContext.class$("java.util.Hashtable")), array$Ljavax$naming$ldap$Control != null ? array$Ljavax$naming$ldap$Control : (array$Ljavax$naming$ldap$Control = ExternalContext.class$("[Ljavax.naming.ldap.Control;"))};
            Constructor ctor = contextClass.getConstructor(types);
            Object[] args = new Object[]{contextProps, null};
            ctx = (Context)ctor.newInstance(args);
            return ctx;
        }

        public void setCacheContext(boolean cacheContext) {
            this.cacheContext = cacheContext;
        }

        public void setJndiName(String jndiName) {
            this.jndiName = jndiName;
        }
    }

    static class CachedContext
    implements InvocationHandler {
        Context externalCtx;

        CachedContext(Context externalCtx) {
            this.externalCtx = externalCtx;
        }

        static Context createProxyContext(Context ctx) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?>[] interfaces = ctx.getClass().getInterfaces();
            CachedContext handler = new CachedContext(ctx);
            Context proxyCtx = (Context)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)handler);
            return proxyCtx;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object value = null;
            if (!method.getName().equals("close")) {
                try {
                    value = method.invoke((Object)this.externalCtx, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            return value;
        }
    }
}

