/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public class SessionMetaData
extends BeanMetaData {
    private boolean stateful;

    public SessionMetaData(ApplicationMetaData app) {
        super(app, 'S');
    }

    public String getDefaultConfigurationName() {
        if (this.isStateful()) {
            return this.jdk13Enabled() ? "Standard Stateful SessionBean" : "jdk1.2.2 Stateful SessionBean";
        }
        return this.jdk13Enabled() ? "Standard Stateless SessionBean" : "jdk1.2.2 Stateless SessionBean";
    }

    public void importEjbJarXml(Element element) throws DeploymentException {
        super.importEjbJarXml(element);
        String sessionType = MetaData.getElementContent(MetaData.getUniqueChild(element, "session-type"));
        if (sessionType.equals("Stateful")) {
            this.stateful = true;
        } else if (sessionType.equals("Stateless")) {
            this.stateful = false;
        } else {
            throw new DeploymentException("session type should be 'Stateful' or 'Stateless'");
        }
        String transactionType = MetaData.getElementContent(MetaData.getUniqueChild(element, "transaction-type"));
        if (transactionType.equals("Bean")) {
            this.containerManagedTx = false;
        } else if (transactionType.equals("Container")) {
            this.containerManagedTx = true;
        } else {
            throw new DeploymentException("transaction type should be 'Bean' or 'Container'");
        }
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public boolean isStateless() {
        return this.stateful ^ true;
    }
}

