/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public class EntityMetaData
extends BeanMetaData {
    private boolean cmp;
    private String primaryKeyClass;
    private boolean reentrant;
    private ArrayList cmpFields = new ArrayList();
    private String primKeyField;

    public EntityMetaData(ApplicationMetaData app) {
        super(app, 'E');
    }

    public Iterator getCMPFields() {
        return ((AbstractList)this.cmpFields).iterator();
    }

    public String getDefaultConfigurationName() {
        if (this.isCMP()) {
            return this.jdk13Enabled() ? "Standard CMP EntityBean" : "jdk1.2.2 CMP EntityBean";
        }
        return this.jdk13Enabled() ? "Standard BMP EntityBean" : "jdk1.2.2 BMP EntityBean";
    }

    public String getPrimKeyField() {
        return this.primKeyField;
    }

    public String getPrimaryKeyClass() {
        return this.primaryKeyClass;
    }

    public void importEjbJarXml(Element element) throws DeploymentException {
        super.importEjbJarXml(element);
        String persistenceType = MetaData.getElementContent(MetaData.getUniqueChild(element, "persistence-type"));
        if (persistenceType.equals("Bean")) {
            this.cmp = false;
        } else if (persistenceType.equals("Container")) {
            this.cmp = true;
        } else {
            throw new DeploymentException("persistence-type should be 'Bean' or 'Container'");
        }
        this.primaryKeyClass = MetaData.getElementContent(MetaData.getUniqueChild(element, "prim-key-class"));
        this.reentrant = Boolean.valueOf(MetaData.getElementContent(MetaData.getUniqueChild(element, "reentrant")));
        if (this.isCMP()) {
            Iterator iterator = MetaData.getChildrenByTagName(element, "cmp-field");
            while (iterator.hasNext()) {
                Element field = (Element)iterator.next();
                this.cmpFields.add(MetaData.getElementContent(MetaData.getUniqueChild(field, "field-name")));
            }
        }
        if (this.isCMP()) {
            this.primKeyField = MetaData.getElementContent(MetaData.getOptionalChild(element, "primkey-field"));
            if (this.primKeyField != null && !this.cmpFields.contains(this.primKeyField)) {
                throw new DeploymentException("primkey-field " + this.primKeyField + " is not a cmp-field");
            }
        }
    }

    public boolean isBMP() {
        return this.cmp ^ true;
    }

    public boolean isCMP() {
        return this.cmp;
    }

    public boolean isReentrant() {
        return this.reentrant;
    }
}

