/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public class ConfigurationMetaData
extends MetaData {
    public static final String CMP_13 = "Standard CMP EntityBean";
    public static final String BMP_13 = "Standard BMP EntityBean";
    public static final String STATELESS_13 = "Standard Stateless SessionBean";
    public static final String STATEFUL_13 = "Standard Stateful SessionBean";
    public static final String MESSAGE_DRIVEN_13 = "Standard Message Driven Bean";
    public static final String CMP_12 = "jdk1.2.2 CMP EntityBean";
    public static final String BMP_12 = "jdk1.2.2 BMP EntityBean";
    public static final String STATELESS_12 = "jdk1.2.2 Stateless SessionBean";
    public static final String STATEFUL_12 = "jdk1.2.2 Stateful SessionBean";
    public static final String MESSAGE_DRIVEN_12 = "jdk1.2.2 Message Driven Bean";
    public static final byte A_COMMIT_OPTION = 0;
    public static final byte B_COMMIT_OPTION = 1;
    public static final byte C_COMMIT_OPTION = 2;
    public static final byte D_COMMIT_OPTION = 3;
    public static final String[] commitOptionStrings = new String[]{"A", "B", "C", "D"};
    private String lockClass = "org.jboss.ejb.plugins.lock.QueuedPessimisticEJBLock";
    private String name;
    private String containerInvoker;
    private String instancePool;
    private String instanceCache;
    private String persistenceManager;
    private String transactionManager;
    private byte commitOption;
    private long optionDRefreshRate = 30000L;
    private boolean callLogging;
    private boolean readOnlyGetMethods;
    private String securityDomain;
    private String authenticationModule;
    private String roleMappingManager;
    private Element containerInvokerConf;
    private Element containerPoolConf;
    private Element containerCacheConf;
    private Element containerInterceptorsConf;

    public ConfigurationMetaData(String name) {
        this.name = name;
    }

    private static String commitOptionToString(byte commitOption) throws DeploymentException {
        try {
            return commitOptionStrings[commitOption];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new DeploymentException("Invalid commit option: " + commitOption);
        }
    }

    public String getAuthenticationModule() {
        return this.authenticationModule;
    }

    public boolean getCallLogging() {
        return this.callLogging;
    }

    public byte getCommitOption() {
        return this.commitOption;
    }

    public Element getContainerCacheConf() {
        return this.containerCacheConf;
    }

    public Element getContainerInterceptorsConf() {
        return this.containerInterceptorsConf;
    }

    public String getContainerInvoker() {
        return this.containerInvoker;
    }

    public Element getContainerInvokerConf() {
        return this.containerInvokerConf;
    }

    public Element getContainerPoolConf() {
        return this.containerPoolConf;
    }

    public String getInstanceCache() {
        return this.instanceCache;
    }

    public String getInstancePool() {
        return this.instancePool;
    }

    public String getLockClass() {
        return this.lockClass;
    }

    public String getName() {
        return this.name;
    }

    public long getOptionDRefreshRate() {
        return this.optionDRefreshRate;
    }

    public String getPersistenceManager() {
        return this.persistenceManager;
    }

    public boolean getReadOnlyGetMethods() {
        return this.readOnlyGetMethods;
    }

    public String getRoleMappingManager() {
        return this.roleMappingManager;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public String getTransactionManager() {
        return this.transactionManager;
    }

    public void importJbossXml(Element element) throws DeploymentException {
        this.callLogging = Boolean.valueOf(MetaData.getElementContent(MetaData.getOptionalChild(element, "call-logging"), String.valueOf(this.callLogging)));
        this.readOnlyGetMethods = Boolean.valueOf(MetaData.getElementContent(MetaData.getOptionalChild(element, "read-only-get-methods")));
        this.containerInvoker = MetaData.getElementContent(MetaData.getOptionalChild(element, "container-invoker"), this.containerInvoker);
        this.instancePool = MetaData.getElementContent(MetaData.getOptionalChild(element, "instance-pool"), this.instancePool);
        this.instanceCache = MetaData.getElementContent(MetaData.getOptionalChild(element, "instance-cache"), this.instanceCache);
        this.persistenceManager = MetaData.getElementContent(MetaData.getOptionalChild(element, "persistence-manager"), this.persistenceManager);
        this.transactionManager = MetaData.getElementContent(MetaData.getOptionalChild(element, "transaction-manager"), this.transactionManager);
        this.lockClass = MetaData.getElementContent(MetaData.getOptionalChild(element, "locking-policy"), this.lockClass);
        this.securityDomain = MetaData.getElementContent(MetaData.getOptionalChild(element, "security-domain"), this.securityDomain);
        if (this.securityDomain != null && this.securityDomain.length() == 0) {
            this.securityDomain = null;
        }
        this.authenticationModule = MetaData.getElementContent(MetaData.getOptionalChild(element, "authentication-module"), this.authenticationModule);
        this.roleMappingManager = MetaData.getElementContent(MetaData.getOptionalChild(element, "role-mapping-manager"), this.roleMappingManager);
        if (this.authenticationModule != null && this.roleMappingManager != null && this.roleMappingManager.equals(this.authenticationModule)) {
            this.securityDomain = this.authenticationModule;
            this.authenticationModule = null;
            this.roleMappingManager = null;
        } else if (this.authenticationModule == null && this.roleMappingManager != null || this.authenticationModule != null && this.roleMappingManager == null) {
            String msg = "Either a security-domain or both authentication-module and role-mapping-manager must be specified";
            throw new DeploymentException(msg);
        }
        String commit = MetaData.getElementContent(MetaData.getOptionalChild(element, "commit-option"), ConfigurationMetaData.commitOptionToString(this.commitOption));
        this.commitOption = ConfigurationMetaData.stringToCommitOption(commit);
        String refresh = MetaData.getElementContent(MetaData.getOptionalChild(element, "optiond-refresh-rate"), Long.toString(this.optionDRefreshRate));
        this.optionDRefreshRate = ConfigurationMetaData.stringToRefreshRate(refresh);
        this.containerInterceptorsConf = MetaData.getOptionalChild(element, "container-interceptors", this.containerInterceptorsConf);
        this.containerInvokerConf = MetaData.getOptionalChild(element, "container-invoker-conf", this.containerInvokerConf);
        this.containerPoolConf = MetaData.getOptionalChild(element, "container-pool-conf", this.containerPoolConf);
        this.containerCacheConf = MetaData.getOptionalChild(element, "container-cache-conf", this.containerCacheConf);
        if (this.containerInvoker.equals("org.jboss.ejb.plugins.jrmp12.server.JRMPContainerInvoker") || this.containerInvoker.equals("org.jboss.ejb.plugins.jrmp13.server.JRMPContainerInvoker")) {
            System.out.println("Deprecated container invoker. Change to org.jboss.ejb.plugins.jrmp.server.JRMPContainerInvoker");
            this.containerInvoker = "org.jboss.ejb.plugins.jrmp.server.JRMPContainerInvoker";
        }
    }

    private static byte stringToCommitOption(String commitOption) throws DeploymentException {
        byte i = 0;
        while (i < commitOptionStrings.length) {
            if (commitOptionStrings[i].equals(commitOption)) {
                return i;
            }
            i = (byte)(i + 1);
        }
        throw new DeploymentException("Invalid commit option: '" + commitOption + "'");
    }

    private static long stringToRefreshRate(String refreshRate) throws DeploymentException {
        try {
            return Long.parseLong(refreshRate);
        }
        catch (Exception exception) {
            throw new DeploymentException("Invalid optiond-refresh-rate '" + refreshRate + "'. Should be a number");
        }
    }
}

