/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.jboss.logging.TracePriority;

public class Logger {
    private Category log;

    protected Logger(String name) {
        this.log = Category.getInstance((String)name);
    }

    public void debug(Object message) {
        this.log.log(Priority.DEBUG, message);
    }

    public void debug(Object message, Throwable t) {
        this.log.log(Priority.DEBUG, message, t);
    }

    public void error(Object message) {
        this.log.log(Priority.ERROR, message);
    }

    public void error(Object message, Throwable t) {
        this.log.log(Priority.ERROR, message, t);
    }

    public void fatal(Object message) {
        this.log.log(Priority.FATAL, message);
    }

    public void fatal(Object message, Throwable t) {
        this.log.log(Priority.FATAL, message, t);
    }

    public Category getCategory() {
        return this.log;
    }

    public static Logger getLogger(Class clazz) {
        Logger logger = new Logger(clazz.getName());
        return logger;
    }

    public static Logger getLogger(String name) {
        Logger logger = new Logger(name);
        return logger;
    }

    public void info(Object message) {
        this.log.log(Priority.INFO, message);
    }

    public void info(Object message, Throwable t) {
        this.log.log(Priority.INFO, message, t);
    }

    public boolean isDebugEnabled() {
        Priority p = Priority.DEBUG;
        if (!this.log.isEnabledFor(p)) {
            return false;
        }
        return p.isGreaterOrEqual(this.log.getChainedPriority());
    }

    public boolean isInfoEnabled() {
        Priority p = Priority.INFO;
        if (!this.log.isEnabledFor(p)) {
            return false;
        }
        return p.isGreaterOrEqual(this.log.getChainedPriority());
    }

    public boolean isTraceEnabled() {
        if (!this.log.isEnabledFor((Priority)TracePriority.TRACE)) {
            return false;
        }
        return TracePriority.TRACE.isGreaterOrEqual(this.log.getChainedPriority());
    }

    public void log(Priority p, Object message) {
        this.log.log(p, message);
    }

    public void log(Priority p, Object message, Throwable t) {
        this.log.log(p, message, t);
    }

    public void trace(Object message) {
        this.log.log((Priority)TracePriority.TRACE, message);
    }

    public void trace(Object message, Throwable t) {
        this.log.log((Priority)TracePriority.TRACE, message, t);
    }

    public void warn(Object message) {
        this.log.log(Priority.WARN, message);
    }

    public void warn(Object message, Throwable t) {
        this.log.log(Priority.WARN, message, t);
    }
}

