/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.server;

import java.net.InetAddress;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import org.jboss.jmx.server.RMIConnectorImpl;
import org.jboss.jmx.server.RMIConnectorServiceMBean;
import org.jboss.util.ServiceMBeanSupport;

public class RMIConnectorService
extends ServiceMBeanSupport
implements RMIConnectorServiceMBean {
    public static String JNDI_NAME = "jmx:rmi";
    public static String JMX_NAME = "jmx";
    public static String PROTOCOL_NAME = "rmi";
    private MBeanServer server;
    private RMIConnectorImpl adaptor;
    private String mHost;
    private String mName;

    public RMIConnectorService() {
        this.mName = null;
    }

    public RMIConnectorService(String name) {
        this.mName = name;
    }

    public String getJNDIName() {
        if (this.mName != null) {
            return String.valueOf(JMX_NAME) + ":" + this.mHost + ":" + PROTOCOL_NAME + ":" + this.mName;
        }
        return String.valueOf(JMX_NAME) + ":" + this.mHost + ":" + PROTOCOL_NAME;
    }

    public String getName() {
        return "JMX RMI Connector";
    }

    public ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        this.server = server;
        return new ObjectName("Connector:name=RMI");
    }

    protected void initService() throws Exception {
        this.mHost = InetAddress.getLocalHost().getHostName();
        this.adaptor = new RMIConnectorImpl(this.server);
    }

    protected void startService() throws Exception {
        new InitialContext().bind(this.getJNDIName(), (Object)this.adaptor);
    }

    protected void stopService() {
        try {
            new InitialContext().unbind(this.getJNDIName());
        }
        catch (Exception e) {
            this.log.error("unbind failure", e);
        }
    }
}

