/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.server;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import org.jboss.jmx.interfaces.RMIConnector;
import org.jboss.jmx.interfaces.RMINotificationListener;
import org.jboss.jmx.server.ObjectHandler;

public class RMIConnectorImpl
extends UnicastRemoteObject
implements RMIConnector {
    private MBeanServer mServer;
    private Hashtable mObjectPool = new Hashtable();
    private Vector mListeners = new Vector();
    static /* synthetic */ Class class$org$jboss$jmx$server$ObjectHandler;

    public RMIConnectorImpl(MBeanServer pServer) throws RemoteException {
        this.mServer = pServer;
    }

    public void addNotificationListener(ObjectName pName, RMINotificationListener pListener, NotificationFilter pFilter, Object pHandback) throws InstanceNotFoundException, RemoteException {
        Listener lRemoteListener = new Listener(pListener);
        this.mServer.addNotificationListener(pName, lRemoteListener, pFilter, pHandback);
        this.mListeners.addElement(lRemoteListener);
    }

    private ObjectHandler assignObjectHandler(Object pNewObject) {
        ObjectHandler lObjectHandler = new ObjectHandler(this.toString());
        this.mObjectPool.put(lObjectHandler, pNewObject);
        return lObjectHandler;
    }

    private Object checkForObjectHandler(Object pObjectToCheck) {
        if (pObjectToCheck instanceof ObjectHandler) {
            return this.mObjectPool.get(pObjectToCheck);
        }
        return pObjectToCheck;
    }

    private void checkForObjectHandlers(Object[] pListOfObjects, String[] pSignature) {
        int i = 0;
        while (i < pListOfObjects.length) {
            Object lEffective = this.checkForObjectHandler(pListOfObjects[i]);
            if (pListOfObjects[i] != lEffective) {
                pListOfObjects[i] = lEffective;
                if (i < pSignature.length && pSignature[i].equals((class$org$jboss$jmx$server$ObjectHandler != null ? class$org$jboss$jmx$server$ObjectHandler : RMIConnectorImpl.class$("org.jboss.jmx.server.ObjectHandler")).getName())) {
                    pSignature[i] = lEffective.getClass().getName();
                }
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public ObjectInstance createMBean(String pClassName, ObjectName pName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, RemoteException {
        return this.mServer.createMBean(pClassName, pName);
    }

    public ObjectInstance createMBean(String pClassName, ObjectName pName, ObjectName pLoaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, RemoteException {
        return this.mServer.createMBean(pClassName, pName, pLoaderName);
    }

    public ObjectInstance createMBean(String pClassName, ObjectName pName, ObjectName pLoaderName, Object[] pParams, String[] pSignature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, RemoteException {
        this.checkForObjectHandlers(pParams, pSignature);
        return this.mServer.createMBean(pClassName, pName, pLoaderName, pParams, pSignature);
    }

    public ObjectInstance createMBean(String pClassName, ObjectName pName, Object[] pParams, String[] pSignature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, RemoteException {
        this.checkForObjectHandlers(pParams, pSignature);
        return this.mServer.createMBean(pClassName, pName, pParams, pSignature);
    }

    public Object getAttribute(ObjectName pName, String pAttribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, RemoteException {
        return this.mServer.getAttribute(pName, pAttribute);
    }

    public AttributeList getAttributes(ObjectName pName, String[] pAttributes) throws InstanceNotFoundException, ReflectionException, RemoteException {
        return this.mServer.getAttributes(pName, pAttributes);
    }

    public String getDefaultDomain() throws RemoteException {
        return this.mServer.getDefaultDomain();
    }

    public Integer getMBeanCount() throws RemoteException {
        return this.mServer.getMBeanCount();
    }

    public MBeanInfo getMBeanInfo(ObjectName pName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, RemoteException {
        return this.mServer.getMBeanInfo(pName);
    }

    public ObjectInstance getObjectInstance(ObjectName pName) throws InstanceNotFoundException, RemoteException {
        return this.mServer.getObjectInstance(pName);
    }

    public Object instantiate(String pClassName) throws ReflectionException, MBeanException, RemoteException {
        return this.assignObjectHandler(this.mServer.instantiate(pClassName));
    }

    public Object instantiate(String pClassName, ObjectName pLoaderName) throws ReflectionException, MBeanException, InstanceNotFoundException, RemoteException {
        return this.assignObjectHandler(this.mServer.instantiate(pClassName, pLoaderName));
    }

    public Object instantiate(String pClassName, ObjectName pLoaderName, Object[] pParams, String[] pSignature) throws ReflectionException, MBeanException, InstanceNotFoundException, RemoteException {
        this.checkForObjectHandlers(pParams, pSignature);
        return this.assignObjectHandler(this.mServer.instantiate(pClassName, pLoaderName, pParams, pSignature));
    }

    public Object instantiate(String pClassName, Object[] pParams, String[] pSignature) throws ReflectionException, MBeanException, RemoteException {
        this.checkForObjectHandlers(pParams, pSignature);
        return this.assignObjectHandler(this.mServer.instantiate(pClassName, pParams, pSignature));
    }

    public Object invoke(ObjectName pName, String pActionName, Object[] pParams, String[] pSignature) throws InstanceNotFoundException, MBeanException, ReflectionException, RemoteException {
        this.checkForObjectHandlers(pParams, pSignature);
        return this.mServer.invoke(pName, pActionName, pParams, pSignature);
    }

    public boolean isInstanceOf(ObjectName pName, String pClassName) throws InstanceNotFoundException, RemoteException {
        return this.mServer.isInstanceOf(pName, pClassName);
    }

    public boolean isRegistered(ObjectName pName) throws RemoteException {
        return this.mServer.isRegistered(pName);
    }

    public Set queryMBeans(ObjectName pName, QueryExp pQuery) throws RemoteException {
        return this.mServer.queryMBeans(pName, pQuery);
    }

    public Set queryNames(ObjectName pName, QueryExp pQuery) throws RemoteException {
        return this.mServer.queryNames(pName, pQuery);
    }

    public ObjectInstance registerMBean(Object pObjectHandler, ObjectName pNameToAssign) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, RemoteException {
        if (!(pObjectHandler instanceof ObjectHandler)) {
            throw new IllegalArgumentException("You can only register local objects referenced by ObjectHandler");
        }
        return this.mServer.registerMBean(this.checkForObjectHandler(pObjectHandler), pNameToAssign);
    }

    public void removeNotificationListener(ObjectName pName, RMINotificationListener pListener) throws InstanceNotFoundException, ListenerNotFoundException, RemoteException {
        int lIndex = this.mListeners.indexOf(new Listener(pListener));
        if (lIndex >= 0) {
            this.mServer.removeNotificationListener(pName, (Listener)this.mListeners.elementAt(lIndex));
        }
    }

    public void setAttribute(ObjectName pName, Attribute pAttribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, RemoteException {
        this.mServer.setAttribute(pName, pAttribute);
    }

    public AttributeList setAttributes(ObjectName pName, AttributeList pAttributes) throws InstanceNotFoundException, ReflectionException, RemoteException {
        return this.mServer.setAttributes(pName, pAttributes);
    }

    public void unregisterMBean(ObjectName pName) throws InstanceNotFoundException, MBeanRegistrationException, RemoteException {
        this.mServer.unregisterMBean(pName);
    }

    private class Listener
    implements NotificationListener {
        private RMINotificationListener mRemoteListener;

        public Listener(RMINotificationListener pRemoteListener) {
            this.mRemoteListener = pRemoteListener;
        }

        public boolean equals(Object pTest) {
            if (pTest instanceof Listener) {
                return this.mRemoteListener.equals(((Listener)pTest).mRemoteListener);
            }
            return false;
        }

        public void handleNotification(Notification pNotification, Object pHandback) {
            try {
                this.mRemoteListener.handleNotification(pNotification, pHandback);
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
        }

        public int hashCode() {
            return this.mRemoteListener.hashCode();
        }
    }
}

