/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.ra;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ManagedConnection;
import org.jboss.jms.ra.JmsManagedConnection;
import org.jboss.jms.ra.Level;

public class JmsSession
implements QueueSession,
TopicSession {
    private JmsManagedConnection mc;

    public JmsSession(JmsManagedConnection mc) {
        this.mc = mc;
    }

    public void close() throws JMSException {
        if (this.mc != null) {
            this.mc.getLogger().log(Level.FINE, "Closing session");
            this.mc.removeHandle(this);
            ConnectionEvent ev = new ConnectionEvent((ManagedConnection)this.mc, 1);
            ev.setConnectionHandle((Object)this);
            this.mc.sendEvent(ev);
            this.mc = null;
        }
    }

    public void commit() throws JMSException {
        this.getSession().commit();
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return ((QueueSession)this.getSession()).createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        return ((QueueSession)this.getSession()).createBrowser(queue, messageSelector);
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.getSession().createBytesMessage();
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return ((TopicSession)this.getSession()).createDurableSubscriber(topic, name);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return ((TopicSession)this.getSession()).createDurableSubscriber(topic, name, messageSelector, noLocal);
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.getSession().createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.getSession().createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.getSession().createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return this.getSession().createObjectMessage(object);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return ((TopicSession)this.getSession()).createPublisher(topic);
    }

    public Queue createQueue(String queueName) throws JMSException {
        return ((QueueSession)this.getSession()).createQueue(queueName);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return ((QueueSession)this.getSession()).createReceiver(queue);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        return ((QueueSession)this.getSession()).createReceiver(queue, messageSelector);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        return ((QueueSession)this.getSession()).createSender(queue);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.getSession().createStreamMessage();
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return ((TopicSession)this.getSession()).createSubscriber(topic);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        return ((TopicSession)this.getSession()).createSubscriber(topic, messageSelector, noLocal);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return ((QueueSession)this.getSession()).createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return ((TopicSession)this.getSession()).createTemporaryTopic();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.getSession().createTextMessage();
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        return this.getSession().createTextMessage(string);
    }

    public Topic createTopic(String topicName) throws JMSException {
        return ((TopicSession)this.getSession()).createTopic(topicName);
    }

    void destroy() {
        this.mc = null;
    }

    public MessageListener getMessageListener() throws JMSException {
        throw new IllegalStateException("Method not allowed");
    }

    private Session getSession() throws JMSException {
        if (this.mc == null) {
            throw new IllegalStateException("The session is closed");
        }
        return this.mc.getSession();
    }

    public boolean getTransacted() throws JMSException {
        return this.getSession().getTransacted();
    }

    public void recover() throws JMSException {
        this.getSession().recover();
    }

    public void rollback() throws JMSException {
        this.getSession().rollback();
    }

    public void run() {
        throw new Error("Method not allowed");
    }

    void setManagedConnection(JmsManagedConnection mc) {
        if (this.mc != null) {
            this.mc.removeHandle(this);
        }
        this.mc = mc;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        throw new IllegalStateException("Method not allowed");
    }

    public void unsubscribe(String name) throws JMSException {
        ((TopicSession)this.getSession()).unsubscribe(name);
    }
}

