/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.ra;

import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import org.jboss.jms.ra.JmsManagedConnection;

public class JmsLocalTransaction
implements LocalTransaction {
    JmsManagedConnection mc;

    public JmsLocalTransaction(JmsManagedConnection mc) {
        this.mc = mc;
    }

    public void begin() throws ResourceException {
        ConnectionEvent ev = new ConnectionEvent((ManagedConnection)this.mc, 2);
        this.mc.sendEvent(ev);
    }

    public void commit() throws ResourceException {
        try {
            this.mc.getSession().commit();
            ConnectionEvent ev = new ConnectionEvent((ManagedConnection)this.mc, 3);
            this.mc.sendEvent(ev);
        }
        catch (JMSException ex) {
            EISSystemException re = new EISSystemException("Could not commit LocalTransaction : " + ex.getMessage());
            re.setLinkedException((Exception)((Object)ex));
            throw re;
        }
    }

    public void rollback() throws ResourceException {
        try {
            this.mc.getSession().rollback();
            ConnectionEvent ev = new ConnectionEvent((ManagedConnection)this.mc, 4);
            this.mc.sendEvent(ev);
        }
        catch (JMSException ex) {
            EISSystemException re = new EISSystemException("Could not rollback LocalTransaction : " + ex.getMessage());
            re.setLinkedException((Exception)((Object)ex));
            throw re;
        }
    }
}

