/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jrmp.server;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.UnicastRemoteObject;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.Container;
import org.jboss.ejb.ContainerInvoker;
import org.jboss.ejb.ContainerInvokerContainer;
import org.jboss.ejb.MethodInvocation;
import org.jboss.ejb.plugins.jrmp.interfaces.ContainerRemote;
import org.jboss.ejb.plugins.jrmp.interfaces.EJBMetaDataImpl;
import org.jboss.ejb.plugins.jrmp.interfaces.GenericProxy;
import org.jboss.ejb.plugins.jrmp.interfaces.HomeHandleImpl;
import org.jboss.ejb.plugins.jrmp.interfaces.RemoteMethodInvocation;
import org.jboss.ejb.plugins.jrmp.server.DefaultSocketFactory;
import org.jboss.logging.Logger;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.SessionMetaData;
import org.jboss.metadata.XmlLoadable;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SecurityDomain;
import org.jboss.tm.TransactionPropagationContextFactory;
import org.w3c.dom.Element;

public class JRMPContainerInvoker
extends RemoteServer
implements ContainerRemote,
ContainerInvoker,
XmlLoadable {
    static Logger log = Logger.getLogger(class$org$jboss$ejb$plugins$jrmp$server$JRMPContainerInvoker != null ? class$org$jboss$ejb$plugins$jrmp$server$JRMPContainerInvoker : (class$org$jboss$ejb$plugins$jrmp$server$JRMPContainerInvoker = JRMPContainerInvoker.class$("org.jboss.ejb.plugins.jrmp.server.JRMPContainerInvoker")));
    protected static final int ANONYMOUS_PORT = 0;
    protected boolean optimize = false;
    protected int rmiPort = 0;
    protected RMIClientSocketFactory clientSocketFactory;
    protected RMIServerSocketFactory serverSocketFactory;
    protected String clientSocketFactoryName;
    protected String serverSocketFactoryName;
    protected SecurityDomain sslDomain;
    protected String serverAddress;
    protected boolean jdk122 = false;
    protected Container container;
    protected ContainerInvokerContainer invokerContainer;
    protected String jndiName;
    protected EJBMetaDataImpl ejbMetaData;
    protected EJBHome home;
    protected EJBObject statelessObject;
    protected Map beanMethodInvokerMap;
    protected Map homeMethodInvokerMap;
    protected ContainerInvoker ciDelegate;
    private static TransactionPropagationContextFactory tpcFactory;
    static /* synthetic */ Class class$org$jboss$ejb$plugins$jrmp$server$JRMPContainerInvoker;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$jboss$security$SecurityDomain;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void destroy() {
        this.container = null;
        this.invokerContainer = null;
        if (this.ciDelegate != null) {
            this.ciDelegate.destroy();
        }
        this.ciDelegate = null;
    }

    public EJBHome getEJBHome() {
        return this.ciDelegate.getEJBHome();
    }

    public EJBMetaData getEJBMetaData() {
        return this.ejbMetaData;
    }

    public Collection getEntityCollection(Collection ids) throws RemoteException {
        return this.ciDelegate.getEntityCollection(ids);
    }

    public EJBObject getEntityEJBObject(Object id) throws RemoteException {
        return this.ciDelegate.getEntityEJBObject(id);
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public EJBObject getStatefulSessionEJBObject(Object id) throws RemoteException {
        return this.ciDelegate.getStatefulSessionEJBObject(id);
    }

    public EJBObject getStatelessSessionEJBObject() throws RemoteException {
        return this.ciDelegate.getStatelessSessionEJBObject();
    }

    public void importXml(Element element) throws DeploymentException {
        Element addrElement;
        Element sslDomainElement;
        Element optElement = MetaData.getUniqueChild(element, "Optimized");
        if (optElement != null) {
            String opt = MetaData.getElementContent(optElement);
            this.optimize = Boolean.valueOf(opt);
        }
        this.jdk122 = System.getProperty("java.vm.version").compareTo("1.3") < 0;
        this.ciDelegate = this.jdk122 ? new org.jboss.ejb.plugins.jrmp12.server.JRMPContainerInvoker(this) : new org.jboss.ejb.plugins.jrmp13.server.JRMPContainerInvoker(this);
        try {
            Element portElement = MetaData.getUniqueChild(element, "RMIObjectPort");
            if (portElement != null) {
                String port = MetaData.getElementContent(portElement);
                this.rmiPort = Integer.parseInt(port);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.rmiPort = 0;
        }
        catch (DeploymentException deploymentException) {
            this.rmiPort = 0;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Element csfElement = MetaData.getOptionalChild(element, "RMIClientSocketFactory");
            if (csfElement != null) {
                this.clientSocketFactoryName = MetaData.getElementContent(csfElement);
            }
        }
        catch (Exception e) {
            log.error(e);
            this.clientSocketFactoryName = null;
        }
        try {
            Element ssfElement = MetaData.getOptionalChild(element, "RMIServerSocketFactory");
            if (ssfElement != null) {
                this.serverSocketFactoryName = MetaData.getElementContent(ssfElement);
            }
        }
        catch (Exception e) {
            log.error(e);
            this.serverSocketFactoryName = null;
        }
        if ((sslDomainElement = MetaData.getOptionalChild(element, "ssl-domain")) != null) {
            String domainName = MetaData.getElementContent(sslDomainElement);
            try {
                InitialContext iniCtx = new InitialContext();
                this.sslDomain = (SecurityDomain)iniCtx.lookup(domainName);
            }
            catch (Exception e) {
                throw new DeploymentException("Failed to location ssl-domain", e);
            }
        }
        if ((addrElement = MetaData.getOptionalChild(element, "RMIServerSocketAddr")) != null) {
            this.serverAddress = MetaData.getElementContent(addrElement);
        }
        this.loadCustomSocketFactories(loader);
        log.debug("Container Invoker RMI Port='" + (this.rmiPort == 0 ? "Anonymous" : Integer.toString(this.rmiPort)) + "'");
        log.debug("Container Invoker Client SocketFactory='" + (this.clientSocketFactory == null ? "Default" : this.clientSocketFactory.toString()) + "'");
        log.debug("Container Invoker Server SocketFactory='" + (this.serverSocketFactory == null ? "Default" : this.serverSocketFactory.toString()) + "'");
        log.debug("Container Invoker Server SocketAddr='" + (this.serverAddress == null ? "Default" : this.serverAddress) + "'");
        log.debug("Container Invoker Server sslDomain='" + (this.sslDomain == null ? "Default" : this.sslDomain.getSecurityDomain()) + "'");
        log.debug("Container Invoker Optimize='" + this.optimize + "'");
    }

    public void init() throws Exception {
        InitialContext ctx = new InitialContext();
        this.jndiName = this.container.getBeanMetaData().getJndiName();
        tpcFactory = (TransactionPropagationContextFactory)ctx.lookup("java:/TransactionPropagationContextExporter");
        GenericProxy.setTransactionManager((TransactionManager)ctx.lookup("java:/TransactionManager"));
        GenericProxy.setTPCFactory(tpcFactory);
        Method[] methods = this.invokerContainer.getRemoteClass().getMethods();
        this.beanMethodInvokerMap = new HashMap();
        int i = 0;
        while (i < methods.length) {
            this.beanMethodInvokerMap.put(new Long(RemoteMethodInvocation.calculateHash(methods[i])), methods[i]);
            ++i;
        }
        methods = this.invokerContainer.getHomeClass().getMethods();
        this.homeMethodInvokerMap = new HashMap();
        int i2 = 0;
        while (i2 < methods.length) {
            this.homeMethodInvokerMap.put(new Long(RemoteMethodInvocation.calculateHash(methods[i2])), methods[i2]);
            ++i2;
        }
        try {
            Method getEJBObjectMethod = Class.forName("javax.ejb.Handle").getMethod("getEJBObject", new Class[0]);
            this.homeMethodInvokerMap.put(new Long(RemoteMethodInvocation.calculateHash(getEJBObjectMethod)), getEJBObjectMethod);
        }
        catch (Exception e) {
            log.error("getEJBObject", e);
        }
        if (this.container.getBeanMetaData() instanceof EntityMetaData) {
            Class<?> pkClass;
            EntityMetaData metaData = (EntityMetaData)this.container.getBeanMetaData();
            String pkClassName = metaData.getPrimaryKeyClass();
            try {
                pkClass = pkClassName != null ? this.container.getClassLoader().loadClass(pkClassName) : this.container.getClassLoader().loadClass(metaData.getEjbClass()).getField(metaData.getPrimKeyField()).getClass();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                log.error("Unable to identify Bean's Primary Key class!  Did you specify a primary key class and/or field?  Does that field exist?");
                throw new RuntimeException("Primary Key Problem");
            }
            catch (NullPointerException nullPointerException) {
                log.error("Unable to identify Bean's Primary Key class!  Did you specify a primary key class and/or field?  Does that field exist?");
                throw new RuntimeException("Primary Key Problem");
            }
            this.ejbMetaData = new EJBMetaDataImpl(this.invokerContainer.getRemoteClass(), this.invokerContainer.getHomeClass(), pkClass, false, false, new HomeHandleImpl(this.jndiName));
        } else {
            this.ejbMetaData = ((SessionMetaData)this.container.getBeanMetaData()).isStateless() ? new EJBMetaDataImpl(this.invokerContainer.getRemoteClass(), this.invokerContainer.getHomeClass(), null, true, true, new HomeHandleImpl(this.jndiName)) : new EJBMetaDataImpl(this.invokerContainer.getRemoteClass(), this.invokerContainer.getHomeClass(), null, true, false, new HomeHandleImpl(this.jndiName));
        }
        this.ciDelegate.init();
    }

    public Object invoke(Object id, Method m, Object[] args, Transaction tx, Principal identity, Object credential) throws Exception {
        Class remoteClass;
        Class<?> methodClass = m.getDeclaringClass();
        if (!methodClass.isAssignableFrom(remoteClass = this.invokerContainer.getRemoteClass())) {
            RemoteMethodInvocation rmi = new RemoteMethodInvocation(id, m, args);
            rmi.setTransactionPropagationContext(tpcFactory.getTransactionPropagationContext(tx));
            rmi.setPrincipal(SecurityAssociation.getPrincipal());
            rmi.setCredential(SecurityAssociation.getCredential());
            try {
                return this.invoke(new MarshalledObject<RemoteMethodInvocation>(rmi)).get();
            }
            catch (Exception e) {
                throw new MarshalledObject<Exception>(e).get();
            }
        }
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.container.getClassLoader());
        try {
            Object object = this.container.invoke(new MethodInvocation(id, m, args, tx, identity, credential));
            Object var12_13 = null;
            Thread.currentThread().setContextClassLoader(oldCl);
            return object;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            Thread.currentThread().setContextClassLoader(oldCl);
            throw throwable;
        }
    }

    public MarshalledObject invoke(MarshalledObject mimo) throws Exception {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.container.getClassLoader());
        try {
            RemoteMethodInvocation rmi = (RemoteMethodInvocation)mimo.get();
            rmi.setMethodMap(this.beanMethodInvokerMap);
            Object tpc = rmi.getTransactionPropagationContext();
            MarshalledObject<Object> marshalledObject = new MarshalledObject<Object>(this.container.invoke(new MethodInvocation(rmi.getId(), rmi.getMethod(), rmi.getArguments(), rmi.getPrincipal(), rmi.getCredential(), rmi.getTransactionPropagationContext())));
            Object var5_6 = null;
            Thread.currentThread().setContextClassLoader(oldCl);
            return marshalledObject;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            Thread.currentThread().setContextClassLoader(oldCl);
            throw throwable;
        }
    }

    public Object invokeHome(Method m, Object[] args, Transaction tx, Principal identity, Object credential) throws Exception {
        Class remoteClass;
        Class<?> methodClass = m.getDeclaringClass();
        if (!methodClass.isAssignableFrom(remoteClass = this.invokerContainer.getHomeClass())) {
            RemoteMethodInvocation rmi = new RemoteMethodInvocation(null, m, args);
            rmi.setTransactionPropagationContext(tpcFactory.getTransactionPropagationContext(tx));
            rmi.setPrincipal(SecurityAssociation.getPrincipal());
            rmi.setCredential(SecurityAssociation.getCredential());
            try {
                return this.invokeHome(new MarshalledObject<RemoteMethodInvocation>(rmi)).get();
            }
            catch (Exception e) {
                throw new MarshalledObject<Exception>(e).get();
            }
        }
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.container.getClassLoader());
        try {
            Object object = this.container.invokeHome(new MethodInvocation(null, m, args, tx, identity, credential));
            Object var11_12 = null;
            Thread.currentThread().setContextClassLoader(oldCl);
            return object;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            Thread.currentThread().setContextClassLoader(oldCl);
            throw throwable;
        }
    }

    public MarshalledObject invokeHome(MarshalledObject mimo) throws Exception {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.container.getClassLoader());
        try {
            RemoteMethodInvocation rmi = (RemoteMethodInvocation)mimo.get();
            rmi.setMethodMap(this.homeMethodInvokerMap);
            MarshalledObject<Object> marshalledObject = new MarshalledObject<Object>(this.container.invokeHome(new MethodInvocation(null, rmi.getMethod(), rmi.getArguments(), rmi.getPrincipal(), rmi.getCredential(), rmi.getTransactionPropagationContext())));
            Object var5_5 = null;
            Thread.currentThread().setContextClassLoader(oldCl);
            return marshalledObject;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            Thread.currentThread().setContextClassLoader(oldCl);
            throw throwable;
        }
    }

    public boolean isOptimized() {
        return this.optimize;
    }

    private void loadCustomSocketFactories(ClassLoader loader) {
        block17: {
            try {
                if (this.clientSocketFactoryName != null) {
                    Class<?> csfClass = loader.loadClass(this.clientSocketFactoryName);
                    this.clientSocketFactory = (RMIClientSocketFactory)csfClass.newInstance();
                }
            }
            catch (Exception e) {
                log.error(e);
                this.clientSocketFactory = null;
            }
            try {
                if (this.serverSocketFactoryName != null) {
                    Object[] args;
                    Method m;
                    Class[] parameterTypes;
                    Class<?> ssfClass = loader.loadClass(this.serverSocketFactoryName);
                    this.serverSocketFactory = (RMIServerSocketFactory)ssfClass.newInstance();
                    if (this.serverAddress != null) {
                        try {
                            parameterTypes = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = JRMPContainerInvoker.class$("java.lang.String"))};
                            m = ssfClass.getMethod("setBindAddress", parameterTypes);
                            args = new Object[]{this.serverAddress};
                            m.invoke((Object)this.serverSocketFactory, args);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            log.error("Socket factory does not support setBindAddress(String)");
                        }
                        catch (Exception exception) {
                            log.error("Failed to setBindAddress=" + this.serverAddress + " on socket factory");
                        }
                    }
                    if (this.sslDomain != null) {
                        try {
                            parameterTypes = new Class[]{class$org$jboss$security$SecurityDomain != null ? class$org$jboss$security$SecurityDomain : (class$org$jboss$security$SecurityDomain = JRMPContainerInvoker.class$("org.jboss.security.SecurityDomain"))};
                            m = ssfClass.getMethod("setSecurityDomain", parameterTypes);
                            args = new Object[]{this.sslDomain};
                            m.invoke((Object)this.serverSocketFactory, args);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            log.error("Socket factory does not support setSecurityDomain(SecurityDomain)");
                        }
                        catch (Exception exception) {
                            log.error("Failed to setSecurityDomain=" + this.sslDomain + " on socket factory");
                        }
                    }
                    break block17;
                }
                if (this.serverAddress != null) {
                    DefaultSocketFactory defaultFactory = new DefaultSocketFactory();
                    this.serverSocketFactory = defaultFactory;
                    try {
                        defaultFactory.setBindAddress(this.serverAddress);
                    }
                    catch (UnknownHostException e) {
                        log.error("Failed to setBindAddress=" + this.serverAddress + " on socket factory, " + e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                log.error(e);
                this.serverSocketFactory = null;
            }
        }
    }

    protected void rebind(Context ctx, String name, Object val) throws NamingException {
        Name n = ctx.getNameParser("").parse(name);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException nameNotFoundException) {
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        ctx.rebind(n.get(0), val);
    }

    public void setContainer(Container con) {
        this.container = con;
        this.invokerContainer = (ContainerInvokerContainer)((Object)con);
        this.ciDelegate.setContainer(con);
    }

    public void setOptimized(boolean optimize) {
        this.optimize = optimize;
    }

    public void start() throws Exception {
        try {
            UnicastRemoteObject.exportObject(this, this.rmiPort, this.clientSocketFactory, this.serverSocketFactory);
            GenericProxy.addLocal(this.container.getBeanMetaData().getJndiName(), this);
            InitialContext context = new InitialContext();
            this.rebind(context, this.container.getBeanMetaData().getJndiName(), this.invokerContainer.getContainerInvoker().getEJBHome());
            this.rebind(context, "invokers/" + this.container.getBeanMetaData().getJndiName(), this.invokerContainer.getContainerInvoker());
            log.debug("Bound " + this.container.getBeanMetaData().getEjbName() + " to " + this.container.getBeanMetaData().getJndiName());
        }
        catch (IOException e) {
            throw new ServerException("Could not bind either home or invoker", e);
        }
    }

    public void stop() {
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind(this.container.getBeanMetaData().getJndiName());
            ctx.unbind("invokers/" + this.container.getBeanMetaData().getJndiName());
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (Exception exception) {}
        GenericProxy.removeLocal(this.container.getBeanMetaData().getJndiName());
        this.beanMethodInvokerMap.clear();
        this.homeMethodInvokerMap.clear();
        Method[] methods = this.invokerContainer.getRemoteClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            RemoteMethodInvocation.clearHash(methods[i]);
            ++i;
        }
        methods = this.invokerContainer.getHomeClass().getMethods();
        int i2 = 0;
        while (i2 < methods.length) {
            RemoteMethodInvocation.clearHash(methods[i2]);
            ++i2;
        }
        log.debug("Cleared method maps");
    }
}

