/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jrmp.interfaces;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;

public final class RemoteMethodInvocation
implements Externalizable {
    private static final long serialVersionUID = 6021873560918744612L;
    static Map hashMap = new HashMap();
    Object id;
    long hash;
    Object[] args;
    private Object tpc;
    private Principal identity;
    private Object credential;
    transient Map methodMap;

    public RemoteMethodInvocation() {
    }

    public RemoteMethodInvocation(Object id, Method m, Object[] args) {
        this.id = id;
        this.args = args;
        this.hash = RemoteMethodInvocation.calculateHash(m);
    }

    public RemoteMethodInvocation(Method m, Object[] args) {
        this(null, m, args);
    }

    public static long calculateHash(Method method) {
        Class<?> methodClass = method.getDeclaringClass();
        Map methodHashes = (Map)hashMap.get(methodClass);
        if (methodHashes == null) {
            methodHashes = RemoteMethodInvocation.getInterfaceHashes(methodClass);
            hashMap.put(methodClass, methodHashes);
        }
        return (Long)methodHashes.get(method);
    }

    public static void clearHash(Method method) {
        Class<?> methodClass = method.getDeclaringClass();
        hashMap.remove(methodClass);
    }

    public Object[] getArguments() {
        return this.args;
    }

    public Object getCredential() {
        return this.credential;
    }

    public Object getId() {
        return this.id;
    }

    public static Map getInterfaceHashes(Class intf) {
        Method[] methods = intf.getDeclaredMethods();
        HashMap<Method, Long> map = new HashMap<Method, Long>();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            Class<?>[] parameterTypes = method.getParameterTypes();
            String methodDesc = String.valueOf(method.getName()) + "(";
            int j = 0;
            while (j < parameterTypes.length) {
                methodDesc = String.valueOf(methodDesc) + RemoteMethodInvocation.getTypeString(parameterTypes[j]);
                ++j;
            }
            methodDesc = String.valueOf(methodDesc) + ")" + RemoteMethodInvocation.getTypeString(method.getReturnType());
            try {
                long hash = 0L;
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
                MessageDigest messagedigest = MessageDigest.getInstance("SHA");
                DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
                dataoutputstream.writeUTF(methodDesc);
                dataoutputstream.flush();
                byte[] abyte0 = messagedigest.digest();
                int j2 = 0;
                while (j2 < Math.min(8, abyte0.length)) {
                    hash += (long)(abyte0[j2] & 0xFF) << j2 * 8;
                    ++j2;
                }
                map.put(method, new Long(hash));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return map;
    }

    public Method getMethod() {
        Method m = (Method)this.methodMap.get(new Long(this.hash));
        if (m == null) {
            throw new NullPointerException("METHOD IS NOT FOUND:" + this.hash + " " + this.methodMap);
        }
        return (Method)this.methodMap.get(new Long(this.hash));
    }

    public Principal getPrincipal() {
        return this.identity;
    }

    public Object getTransactionPropagationContext() {
        return this.tpc;
    }

    static String getTypeString(Class cl) {
        if (cl == Byte.TYPE) {
            return "B";
        }
        if (cl == Character.TYPE) {
            return "C";
        }
        if (cl == Double.TYPE) {
            return "D";
        }
        if (cl == Float.TYPE) {
            return "F";
        }
        if (cl == Integer.TYPE) {
            return "I";
        }
        if (cl == Long.TYPE) {
            return "J";
        }
        if (cl == Short.TYPE) {
            return "S";
        }
        if (cl == Boolean.TYPE) {
            return "Z";
        }
        if (cl == Void.TYPE) {
            return "V";
        }
        if (cl.isArray()) {
            return "[" + RemoteMethodInvocation.getTypeString(cl.getComponentType());
        }
        return "L" + cl.getName().replace('.', '/') + ";";
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readObject();
        this.hash = in.readLong();
        this.args = (Object[])in.readObject();
        this.tpc = in.readObject();
        this.identity = (Principal)in.readObject();
        this.credential = in.readObject();
    }

    public void setCredential(Object credential) {
        this.credential = credential;
    }

    public void setMethodMap(Map methods) {
        this.methodMap = methods;
    }

    public void setPrincipal(Principal identity) {
        this.identity = identity;
    }

    public void setTransactionPropagationContext(Object tpc) {
        this.tpc = tpc;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.id);
        out.writeLong(this.hash);
        out.writeObject(this.args);
        out.writeObject(this.tpc);
        out.writeObject(this.identity);
        out.writeObject(this.credential);
    }
}

