/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jaws.metadata;

import java.net.URL;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.jaws.metadata.JawsApplicationMetaData;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.XmlFileLoader;
import org.w3c.dom.Document;

public class JawsXmlFileLoader {
    private ApplicationMetaData application;
    private ClassLoader classLoader;
    private ClassLoader localClassLoader;
    private Logger log;

    public JawsXmlFileLoader(ApplicationMetaData app, ClassLoader cl, ClassLoader localCl, Logger l) {
        this.application = app;
        this.classLoader = cl;
        this.localClassLoader = localCl;
        this.log = l;
    }

    public JawsApplicationMetaData load() throws DeploymentException {
        JawsApplicationMetaData jamd = new JawsApplicationMetaData(this.application, this.classLoader);
        URL stdJawsUrl = this.classLoader.getResource("standardjaws.xml");
        if (stdJawsUrl == null) {
            throw new DeploymentException("No standardjaws.xml found");
        }
        this.log.debug("Loading standardjaws.xml : " + stdJawsUrl.toString());
        Document stdJawsDocument = XmlFileLoader.getDocument(stdJawsUrl);
        jamd.importXml(stdJawsDocument.getDocumentElement());
        URL jawsUrl = this.localClassLoader.getResource("META-INF/jaws.xml");
        if (jawsUrl != null) {
            this.log.debug(String.valueOf(jawsUrl.toString()) + " found. Overriding defaults");
            Document jawsDocument = XmlFileLoader.getDocument(jawsUrl);
            jamd.importXml(jawsDocument.getDocumentElement());
        }
        jamd.init();
        return jamd;
    }
}

