/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jaws.jdbc;

import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.sql.PreparedStatement;
import java.util.Iterator;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.jaws.JAWSPersistenceManager;
import org.jboss.ejb.plugins.jaws.JPMStoreEntityCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCCommandFactory;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCUpdateCommand;
import org.jboss.ejb.plugins.jaws.metadata.CMPFieldMetaData;

public class JDBCStoreEntityCommand
extends JDBCUpdateCommand
implements JPMStoreEntityCommand {
    public JDBCStoreEntityCommand(JDBCCommandFactory factory) {
        super(factory, "Store");
        boolean tuned = this.jawsEntity.hasTunedUpdates();
        if (!tuned) {
            this.setSQL(this.makeSQL(null));
        }
    }

    protected final boolean changed(Object current, Object old) {
        return current == null ? old != null : (old == null ? true : current.equals(old) ^ true);
    }

    public void execute(EntityEnterpriseContext ctx) throws RemoteException {
        if (this.jawsEntity.isReadOnly()) {
            return;
        }
        ExecutionState es = new ExecutionState();
        es.ctx = ctx;
        es.currentState = this.getState(ctx);
        boolean dirty = false;
        boolean tuned = this.jawsEntity.hasTunedUpdates();
        if (tuned) {
            es.dirtyField = new boolean[es.currentState.length];
            Object[] oldState = ((JAWSPersistenceManager.PersistenceContext)ctx.getPersistenceContext()).state;
            int i = 0;
            while (i < es.currentState.length) {
                es.dirtyField[i] = this.changed(es.currentState[i], oldState[i]);
                dirty |= es.dirtyField[i];
                ++i;
            }
        }
        if (!tuned || dirty) {
            try {
                this.jdbcExecute(es);
            }
            catch (Exception e) {
                throw new ServerException("Store failed", e);
            }
        }
    }

    protected String getSQL(Object argOrArgs) throws Exception {
        boolean tuned = this.jawsEntity.hasTunedUpdates();
        return tuned ? this.makeSQL(argOrArgs) : super.getSQL(argOrArgs);
    }

    protected Object handleResult(int rowsAffected, Object argOrArgs) throws Exception {
        ExecutionState es = (ExecutionState)argOrArgs;
        boolean tuned = this.jawsEntity.hasTunedUpdates();
        if (tuned) {
            JAWSPersistenceManager.PersistenceContext pCtx = (JAWSPersistenceManager.PersistenceContext)es.ctx.getPersistenceContext();
            pCtx.state = es.currentState;
        }
        return null;
    }

    protected String makeSQL(Object argOrArgs) {
        ExecutionState es = (ExecutionState)argOrArgs;
        boolean tuned = this.jawsEntity.hasTunedUpdates();
        String sql = "UPDATE " + this.jawsEntity.getTableName() + " SET ";
        Iterator iter = this.jawsEntity.getCMPFields();
        int i = 0;
        boolean first = true;
        while (iter.hasNext()) {
            CMPFieldMetaData cmpField = (CMPFieldMetaData)iter.next();
            if (tuned && !es.dirtyField[i++]) continue;
            sql = String.valueOf(sql) + (first ? "" : ",") + cmpField.getColumnName() + "=?";
            first = false;
        }
        sql = String.valueOf(sql) + " WHERE " + this.getPkColumnWhereList();
        return sql;
    }

    protected void setParameters(PreparedStatement stmt, Object argOrArgs) throws Exception {
        ExecutionState es = (ExecutionState)argOrArgs;
        boolean tuned = this.jawsEntity.hasTunedUpdates();
        int idx = 1;
        Iterator iter = this.jawsEntity.getCMPFields();
        int i = 0;
        while (iter.hasNext()) {
            CMPFieldMetaData cmpField = (CMPFieldMetaData)iter.next();
            if (!tuned || es.dirtyField[i]) {
                this.setParameter(stmt, idx++, cmpField.getJDBCType(), es.currentState[i]);
            }
            ++i;
        }
        this.setPrimaryKeyParameters(stmt, idx, es.ctx.getId());
    }

    protected static class ExecutionState {
        public EntityEnterpriseContext ctx;
        public Object[] currentState;
        public boolean[] dirtyField;

        protected ExecutionState() {
        }
    }
}

