/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jaws.jdbc;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.jaws.JPMFindEntitiesCommand;
import org.jboss.ejb.plugins.jaws.JPMFindEntityCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCBeanExistsCommand;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCCommandFactory;
import org.jboss.util.FinderResults;

public class JDBCFindEntityCommand
implements JPMFindEntityCommand {
    JDBCBeanExistsCommand beanExistsCommand;
    JPMFindEntitiesCommand findEntitiesCommand;

    public JDBCFindEntityCommand(JDBCCommandFactory factory) {
        this.beanExistsCommand = factory.createBeanExistsCommand();
        this.findEntitiesCommand = factory.createFindEntitiesCommand();
    }

    public Object execute(Method finderMethod, Object[] args, EntityEnterpriseContext ctx) throws RemoteException, FinderException {
        if (finderMethod.getName().equals("findByPrimaryKey")) {
            return this.findByPrimaryKey(args[0]);
        }
        FinderResults result = this.findEntitiesCommand.execute(finderMethod, args, ctx);
        if (result.size() == 0) {
            throw new ObjectNotFoundException("No such entity!");
        }
        if (result.size() == 1) {
            Object[] objects = result.toArray();
            return objects[0];
        }
        throw new FinderException("More than one entity matches the finder criteria.");
    }

    protected Object findByPrimaryKey(Object id) throws FinderException {
        if (this.beanExistsCommand.execute(id)) {
            return id;
        }
        throw new ObjectNotFoundException("Object with primary key " + id + " not found in storage");
    }
}

