/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.jaws.jdbc;

import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.util.Iterator;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCCommandFactory;
import org.jboss.ejb.plugins.jaws.jdbc.JDBCFinderCommand;
import org.jboss.ejb.plugins.jaws.metadata.CMPFieldMetaData;
import org.jboss.ejb.plugins.jaws.metadata.FinderMetaData;

public class JDBCFindByCommand
extends JDBCFinderCommand {
    private CMPFieldMetaData cmpField;

    public JDBCFindByCommand(JDBCCommandFactory factory, Method finderMethod, FinderMetaData md) throws IllegalArgumentException {
        super(factory, md);
        String cmpFieldName = finderMethod.getName().substring(6).toLowerCase();
        this.log.debug("Finder:" + cmpFieldName);
        this.cmpField = null;
        Iterator iter = this.jawsEntity.getCMPFields();
        while (this.cmpField == null && iter.hasNext()) {
            CMPFieldMetaData fi = (CMPFieldMetaData)iter.next();
            String lastComponentOfName = CMPFieldMetaData.getLastComponent(fi.getName()).toLowerCase();
            if (!cmpFieldName.equals(lastComponentOfName)) continue;
            this.cmpField = fi;
        }
        if (this.cmpField == null) {
            throw new IllegalArgumentException("No finder for this method: " + finderMethod.getName());
        }
        String sql = "SELECT " + this.getPkColumnList() + " FROM " + this.jawsEntity.getTableName() + " WHERE ";
        sql = String.valueOf(sql) + this.cmpField.getColumnName() + "=?";
        this.setSQL(sql);
    }

    public String getFromClause() {
        return " FROM " + this.jawsEntity.getTableName();
    }

    public String getOrderByClause() {
        return "";
    }

    public String getWhereClause() {
        return String.valueOf(this.cmpField.getColumnName()) + "=?";
    }

    protected void setParameters(PreparedStatement stmt, Object argOrArgs) throws Exception {
        Object[] args = (Object[])argOrArgs;
        if (this.cmpField != null) {
            this.setParameter(stmt, 1, this.cmpField.getJDBCType(), args[0]);
        }
    }
}

