/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.util.Timer;
import java.util.TimerTask;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.InstancePool;
import org.jboss.ejb.plugins.InstancePoolFeeder;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlLoadable;
import org.w3c.dom.Element;

public class TimedInstancePoolFeeder
extends TimerTask
implements XmlLoadable,
InstancePoolFeeder {
    private InstancePool ip;
    private int rate;
    private int increment;
    private Timer timer;
    private boolean isStarted = false;

    public void importXml(Element element) throws DeploymentException {
        try {
            Element instancePoolConf = MetaData.getUniqueChild(element, "feeder-policy-conf");
            Element tmp = MetaData.getUniqueChild(instancePoolConf, "increment");
            this.increment = Integer.parseInt(MetaData.getElementContent(tmp));
            tmp = MetaData.getUniqueChild(instancePoolConf, "period");
            this.rate = Integer.parseInt(MetaData.getElementContent(tmp));
        }
        catch (Exception e) {
            throw new DeploymentException("Can't read feeder-policy-conf", e);
        }
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void run() {
        try {
            int capacity = this.ip.getMaxSize();
            if (this.ip.getCurrentSize() < capacity) {
                int i = 0;
                while (i < this.increment) {
                    this.ip.add();
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
    }

    public void setInstancePool(InstancePool ip) {
        this.ip = ip;
    }

    public void start() {
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this, 0L, (long)this.rate);
        this.isStarted = true;
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }
}

