/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import org.jboss.ejb.CacheKey;
import org.jboss.ejb.Container;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.EntityCache;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.AbstractInstanceCache;

public class EntityInstanceCache
extends AbstractInstanceCache
implements EntityCache {
    private EntityContainer m_container;

    protected EnterpriseContext acquireContext() throws Exception {
        EnterpriseContext ctx = null;
        if (this.m_container != null) {
            ctx = this.m_container.getInstancePool().get();
        }
        return ctx;
    }

    protected void activate(EnterpriseContext ctx) throws RemoteException {
        if (this.m_container != null) {
            this.m_container.getPersistenceManager().activateEntity((EntityEnterpriseContext)ctx);
        }
    }

    protected boolean canPassivate(EnterpriseContext ctx) {
        if (ctx.isLocked()) {
            return false;
        }
        if (ctx.getTransaction() != null) {
            return false;
        }
        return !this.m_container.getLockManager().canPassivate(((EntityEnterpriseContext)ctx).getCacheKey());
    }

    public Object createCacheKey(Object id) {
        return new CacheKey(id);
    }

    public void destroy() {
        EntityInstanceCache entityInstanceCache = this;
        synchronized (entityInstanceCache) {
            this.m_container = null;
        }
        super.destroy();
    }

    protected void freeContext(EnterpriseContext ctx) {
        if (this.m_container != null) {
            this.m_container.getInstancePool().free(ctx);
        }
    }

    public EnterpriseContext get(Object id) throws RemoteException, NoSuchObjectException {
        if (!(id instanceof CacheKey)) {
            throw new IllegalArgumentException("cache.get for entity beans must have a CacheKey object as argument instead of " + id);
        }
        EnterpriseContext rtn = null;
        rtn = super.get(id);
        return rtn;
    }

    protected Container getContainer() {
        return this.m_container;
    }

    protected Object getKey(EnterpriseContext ctx) {
        return ((EntityEnterpriseContext)ctx).getCacheKey();
    }

    protected void passivate(EnterpriseContext ctx) throws RemoteException {
        if (this.m_container != null) {
            this.m_container.getPersistenceManager().passivateEntity((EntityEnterpriseContext)ctx);
        }
    }

    public void remove(Object id) {
        if (!(id instanceof CacheKey)) {
            throw new IllegalArgumentException("cache.remove for entity beans must have a CacheKey object as argument instead of " + id);
        }
        super.remove(id);
    }

    public void setContainer(Container c) {
        this.m_container = (EntityContainer)c;
    }

    protected void setKey(Object id, EnterpriseContext ctx) {
        ((EntityEnterpriseContext)ctx).setCacheKey(id);
        ctx.setId(((CacheKey)id).getId());
    }
}

