/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.scope;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.deployment.scope.ScopedURLClassLoader;
import org.jboss.logging.Logger;

public class Scope {
    protected final Map classLoaders = new HashMap();
    protected final Map dependencies = new HashMap();
    protected final Map classLocations = new HashMap();
    protected final Map resourceLocations = new HashMap();
    protected final Logger log;

    public Scope(Logger log) {
        this.log = log;
    }

    protected boolean addDependency(ScopedURLClassLoader source, ScopedURLClassLoader target) {
        if (source != null && target != null && !source.equals(target)) {
            HashSet<ScopedURLClassLoader> deps = (HashSet<ScopedURLClassLoader>)this.dependencies.get(target);
            if (deps == null) {
                deps = new HashSet<ScopedURLClassLoader>();
                this.dependencies.put(target, deps);
            }
            this.log.debug("Adding dependency from deployment " + source + ":" + source.deployment.getLocalUrl() + " to deployment " + target + ":" + target.deployment.getLocalUrl());
            return deps.add(source);
        }
        return false;
    }

    protected void clearByValue(Map map, Object value) {
        Iterator values = map.values().iterator();
        while (values.hasNext()) {
            if (!values.next().equals(value)) continue;
            values.remove();
        }
    }

    public ScopedURLClassLoader deRegisterClassLoader(ScopedURLClassLoader loader) {
        Map map = this.classLoaders;
        synchronized (map) {
            this.clearByValue(this.classLocations, loader);
            this.clearByValue(this.resourceLocations, loader);
            this.dependencies.remove(loader);
            ScopedURLClassLoader scopedURLClassLoader = (ScopedURLClassLoader)this.classLoaders.remove(loader.deployment.getLocalUrl());
            Object var4_4 = null;
            return scopedURLClassLoader;
        }
    }

    public Set getDependentClassLoaders(ScopedURLClassLoader loader) {
        HashSet result = (HashSet)this.dependencies.get(loader);
        if (result == null) {
            result = new HashSet();
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public URL getResource(String name, ScopedURLClassLoader source) {
        Map map = this.classLoaders;
        synchronized (map) {
            ScopedURLClassLoader target = (ScopedURLClassLoader)this.resourceLocations.get(name);
            if (target != null) {
                this.addDependency(source, target);
            }
            if (target != null) {
                return target.getResource(name);
            }
            Iterator allLoaders = this.classLoaders.values().iterator();
            while (allLoaders.hasNext()) {
                URL foundResource;
                target = (ScopedURLClassLoader)allLoaders.next();
                if (target.equals(source) || (foundResource = target.getResourceProperly(name)) == null) continue;
                this.resourceLocations.put(name, target);
                this.addDependency(source, target);
                return foundResource;
            }
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Class loadClass(String className, boolean resolve, ScopedURLClassLoader source) throws ClassNotFoundException {
        Map map = this.classLoaders;
        synchronized (map) {
            ScopedURLClassLoader target = (ScopedURLClassLoader)this.classLocations.get(className);
            if (target != null) {
                this.addDependency(source, target);
                return target.loadClass(className, resolve);
            }
            Iterator allLoaders = this.classLoaders.values().iterator();
            while (allLoaders.hasNext()) {
                target = (ScopedURLClassLoader)allLoaders.next();
                if (target.equals(source)) continue;
                try {
                    Class foundClass = target.loadClassProperly(className, resolve);
                    this.classLocations.put(className, target);
                    this.addDependency(source, target);
                    return foundClass;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            throw new ClassNotFoundException("could not resolve class " + className + " in scope.");
        }
    }

    public ScopedURLClassLoader registerClassLoader(ScopedURLClassLoader loader) {
        Map map = this.classLoaders;
        synchronized (map) {
            ScopedURLClassLoader scopedURLClassLoader = this.classLoaders.put(loader.deployment.getLocalUrl(), loader);
            Object var4_4 = null;
            return scopedURLClassLoader;
        }
    }
}

