/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.deployment.Deployment;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.Installer;
import org.jboss.deployment.InstallerFactory;
import org.jboss.deployment.J2eeApplicationMetaData;
import org.jboss.deployment.J2eeDeploymentException;
import org.jboss.deployment.J2eeModuleMetaData;
import org.jboss.deployment.Util;
import org.jboss.logging.Logger;
import org.jboss.metadata.XmlFileLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LocalDirInstaller
implements Installer {
    URL src;
    Deployment d;
    Logger log;
    boolean done;

    public Deployment execute(InstallerFactory factory, URL src) throws J2eeDeploymentException, IOException {
        this.log = factory.log;
        this.d = new Deployment();
        this.d.name = Util.getName(src.toString());
        this.d.sourceUrl = src;
        File localPkg = null;
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace("execute, src=" + src);
        }
        if (!src.getProtocol().startsWith("file")) {
            throw new J2eeDeploymentException("Only local file: URL are supported by LocalDirInstaller");
        }
        try {
            localPkg = new File(src.getFile());
            this.d.type = Util.hasDeploymentDescriptor(localPkg);
            if (this.d.type < 0) {
                throw new J2eeDeploymentException("LocalPkg: " + localPkg + " has no valid deployment descriptors");
            }
            this.d.localUrl = localPkg.toURL();
            if (trace) {
                this.log.trace("Deployment type is: " + this.d.type);
            }
            switch (this.d.type) {
                case 0: {
                    this.log.info("install EJB module " + this.d.name);
                    URL[] libs = this.resolveLibraries(localPkg);
                    URL localURL = localPkg.toURL();
                    this.d.addEjbModule(this.d.name, localURL, libs);
                    break;
                }
                case 1: {
                    String webContext = "\u0000" + this.d.name;
                    this.log.info("inflate and install WEB module " + this.d.name);
                    URL[] libs = this.resolveLibraries(localPkg);
                    URL localURL = localPkg.toURL();
                    this.d.addWebModule(this.d.name, webContext, localURL, libs);
                    break;
                }
                case 2: {
                    J2eeApplicationMetaData app = null;
                    try {
                        URL appXml = new URL(localPkg.toURL(), Installer.files[this.d.type]);
                        Document appDoc = XmlFileLoader.getDocument(appXml, false);
                        Element root = appDoc.getDocumentElement();
                        app = new J2eeApplicationMetaData(root);
                    }
                    catch (DeploymentException e) {
                        throw new J2eeDeploymentException("Error in parsing application.xml", e);
                    }
                    ArrayList<URL> ejbJars = new ArrayList<URL>();
                    Iterator it = app.getModules();
                    while (it.hasNext()) {
                        String name;
                        J2eeModuleMetaData mod = (J2eeModuleMetaData)it.next();
                        if (mod.isEjb()) {
                            name = mod.getFileName();
                            this.log.debug("Process EJB module " + name);
                            try {
                                File ejbPkg = new File(localPkg, name);
                                if (!ejbPkg.isDirectory()) {
                                    throw new J2eeDeploymentException("EJB module: " + ejbPkg + " is not a directory");
                                }
                                URL[] libs = this.resolveLibraries(ejbPkg);
                                URL localURL = ejbPkg.toURL();
                                this.d.addEjbModule(name, localURL, libs);
                                ejbJars.add(localURL);
                                continue;
                            }
                            catch (IOException _ioe) {
                                throw _ioe;
                            }
                            catch (NullPointerException nullPointerException) {
                                this.log.info("module " + name + " not found in " + this.d.name);
                                throw new J2eeDeploymentException("module " + name + " not found in " + this.d.name);
                            }
                        }
                        if (!mod.isWeb()) continue;
                        name = mod.getFileName();
                        String webContext = mod.getWebContext();
                        this.log.debug("Process WEB module " + name);
                        try {
                            File warPkg = new File(localPkg, name);
                            if (!warPkg.isDirectory()) {
                                throw new J2eeDeploymentException("WAR module: " + warPkg + " is not a directory");
                            }
                            URL[] libs = this.resolveLibraries(warPkg);
                            URL localURL = warPkg.toURL();
                            this.d.addWebModule(name, webContext, localURL, libs);
                        }
                        catch (IOException _ioe) {
                            throw _ioe;
                        }
                        catch (NullPointerException nullPointerException) {
                            this.log.info("module " + name + " not found in " + this.d.name);
                            throw new J2eeDeploymentException("module " + name + " not found in " + this.d.name);
                        }
                    }
                    if (ejbJars.size() > 0) {
                        this.log.debug("Adding all ejb jar files to the common classpath");
                    }
                    int e = 0;
                    while (e < ejbJars.size()) {
                        URL jar = (URL)ejbJars.get(e);
                        this.d.commonUrls.add(jar);
                        ++e;
                    }
                    break;
                }
                default: {
                    return this.d;
                }
            }
        }
        catch (Throwable t) {
            this.log.error("Deployment failed", t);
        }
        return this.d;
    }

    private URL[] resolveLibraries(File localFile) {
        URL[] libs = new URL[]{};
        Manifest mf = null;
        URL baseURL = null;
        try {
            baseURL = localFile.toURL();
            File mfFile = new File(localFile, "META-INF" + File.separator + "MANIFEST.MF");
            if (!mfFile.exists()) {
                mfFile = new File(localFile, "meta-inf" + File.separator + "manifest.mf");
            }
            if (mfFile.exists()) {
                FileInputStream fis = new FileInputStream(mfFile);
                mf = new Manifest(fis);
            }
        }
        catch (IOException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("resolveLibraries, error reading manifest", e);
            }
            return libs;
        }
        String classPath = null;
        if (mf != null) {
            Attributes mainAttributes = mf.getMainAttributes();
            classPath = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
        }
        if (classPath != null) {
            ArrayList<URL> tmp = new ArrayList<URL>();
            StringTokenizer st = new StringTokenizer(classPath);
            this.log.debug("resolveLibraries, Manifest Class-Path: " + classPath);
            while (st.hasMoreTokens()) {
                String tk = st.nextToken();
                try {
                    URL lib = new URL(baseURL, tk);
                    tmp.add(lib);
                    this.log.debug("added " + lib + " to common classpath");
                }
                catch (IOException _ioe) {
                    this.log.warn("Failed to add " + tk + " to common classpath: " + _ioe.getMessage());
                }
            }
            libs = new URL[tmp.size()];
            tmp.toArray(libs);
        }
        return libs;
    }
}

