/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public class ResourceRefMetaData
extends MetaData {
    private String refName;
    private String name;
    private String jndiName;
    private String type;
    private boolean containerAuth;
    private boolean isShareable;

    public String getJndiName() {
        return this.jndiName;
    }

    public String getRefName() {
        return this.refName;
    }

    public String getResourceName() {
        if (this.name == null) {
            this.name = this.refName;
        }
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void importEjbJarXml(Element element) throws DeploymentException {
        this.refName = MetaData.getElementContent(MetaData.getUniqueChild(element, "res-ref-name"));
        this.type = MetaData.getElementContent(MetaData.getUniqueChild(element, "res-type"));
        String auth = MetaData.getElementContent(MetaData.getUniqueChild(element, "res-auth"));
        if (auth.equals("Container")) {
            this.containerAuth = true;
        } else if (auth.equals("Application")) {
            this.containerAuth = false;
        } else {
            throw new DeploymentException("res-auth tag should be 'Container' or 'Application'");
        }
        String sharing = MetaData.getElementContent(MetaData.getOptionalChild(element, "res-sharing-scope"), "Shareable");
        this.isShareable = sharing.equals("Shareable");
    }

    public void importJbossXml(Element element) throws DeploymentException {
        Element child = MetaData.getOptionalChild(element, "resource-name");
        if (child == null) {
            this.jndiName = this.type.equals("java.net.URL") ? MetaData.getElementContent(MetaData.getUniqueChild(element, "res-url")) : MetaData.getElementContent(MetaData.getUniqueChild(element, "jndi-name"));
        } else {
            this.name = MetaData.getElementContent(child);
        }
    }

    public boolean isContainerAuth() {
        return this.containerAuth;
    }

    public boolean isShareable() {
        return this.isShareable;
    }

    public void setResourceName(String resName) {
        this.name = resName;
    }
}

