/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;

public class UsersRolesLoginModule
extends UsernamePasswordLoginModule {
    private String usersRsrcName = "users.properties";
    private String rolesRsrcName = "roles.properties";
    private Properties users;
    private Properties roles;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        try {
            String option = (String)options.get("usersProperties");
            if (option != null) {
                this.usersRsrcName = option;
            }
            if ((option = (String)options.get("rolesProperties")) != null) {
                this.rolesRsrcName = option;
            }
            this.loadUsers();
            this.loadRoles();
        }
        catch (Exception e) {
            this.log.error("Failed to load users/passwords/role files", e);
        }
    }

    public boolean login() throws LoginException {
        if (this.users == null) {
            throw new LoginException("Missing users.properties file.");
        }
        if (this.roles == null) {
            throw new LoginException("Missing roles.properties file.");
        }
        return super.login();
    }

    protected Group[] getRoleSets() throws LoginException {
        String targetUser = this.getUsername();
        Enumeration<?> users = this.roles.propertyNames();
        SimpleGroup rolesGroup = new SimpleGroup("Roles");
        ArrayList<SimpleGroup> groups = new ArrayList<SimpleGroup>();
        groups.add(rolesGroup);
        while (users.hasMoreElements()) {
            String user = (String)users.nextElement();
            String value = this.roles.getProperty(user);
            int index = user.indexOf(46);
            boolean isRoleGroup = false;
            boolean userMatch = false;
            if (index > 0 && targetUser.regionMatches(0, user, 0, index)) {
                isRoleGroup = true;
            } else {
                userMatch = targetUser.equals(user);
            }
            if (isRoleGroup) {
                String groupName = user.substring(index + 1);
                if (groupName.equals("Roles")) {
                    this.parseGroupMembers(rolesGroup, value);
                    continue;
                }
                SimpleGroup group = new SimpleGroup(groupName);
                this.parseGroupMembers(group, value);
                groups.add(group);
                continue;
            }
            if (!userMatch) continue;
            this.parseGroupMembers(rolesGroup, value);
        }
        Group[] roleSets = new Group[groups.size()];
        groups.toArray(roleSets);
        return roleSets;
    }

    protected String getUsersPassword() {
        String username = this.getUsername();
        String password = null;
        if (username != null) {
            password = this.users.getProperty(username, null);
        }
        return password;
    }

    private void parseGroupMembers(Group group, String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            SimplePrincipal p = new SimplePrincipal(token);
            group.addMember((Principal)p);
        }
    }

    private void loadUsers() throws IOException {
        this.users = this.loadProperties(this.usersRsrcName);
    }

    private void loadRoles() throws IOException {
        this.roles = this.loadProperties(this.rolesRsrcName);
    }

    private Properties loadProperties(String propertiesName) throws IOException {
        Properties bundle = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(propertiesName);
        if (url == null) {
            throw new IOException("Properties file " + propertiesName + " not found");
        }
        this.log.trace("Properties file=" + url);
        InputStream is = url.openStream();
        if (is == null) {
            throw new IOException("Properties file " + propertiesName + " not avilable");
        }
        bundle = new Properties();
        bundle.load(is);
        return bundle;
    }
}

