/*
 * Decompiled with CFR 0.152.
 */
package org.jboss;

import com.sun.management.jmx.Trace;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.loading.MLet;

public class Main {
    static /* synthetic */ Class class$org$jboss$Main;

    public Main(String confName, String patchDir) {
        Package mainPkg = Package.getPackage("org.jboss");
        System.out.println("JBoss release: " + mainPkg.getImplementationTitle());
        System.out.println("JBoss version: " + mainPkg.getImplementationVersion());
        long startTime = System.currentTimeMillis();
        try {
            System.out.println("Using configuration \"" + confName + "\"");
            PrintStream err = System.err;
            Trace.parseTraceProperties();
            URL jndiLocation = this.getClass().getResource("/jndi.properties");
            if (jndiLocation instanceof URL) {
                System.out.println("Please make sure the following is intended (check your CLASSPATH):");
                System.out.println(" jndi.properties is read from " + jndiLocation);
            }
            MBeanServer server = MBeanServerFactory.createMBeanServer();
            URL confDirectory = new File("../conf/" + confName).getCanonicalFile().toURL();
            URL[] urls = new URL[]{confDirectory};
            if (patchDir != null) {
                File dir = new File(patchDir);
                ArrayList<URL> tmp = new ArrayList<URL>();
                File[] jars = dir.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        String name = pathname.getName();
                        return name.endsWith(".jar") || name.endsWith(".zip");
                    }
                });
                tmp.add(confDirectory);
                int j = 0;
                while (jars != null && j < jars.length) {
                    File jar = jars[j];
                    URL u = jar.getCanonicalFile().toURL();
                    tmp.add(u);
                    ++j;
                }
                urls = new URL[tmp.size()];
                tmp.toArray(urls);
            }
            NullURLsMLet mlet = new NullURLsMLet(urls);
            server.registerMBean(mlet, new ObjectName(server.getDefaultDomain(), "service", "MLet"));
            Thread.currentThread().setContextClassLoader(mlet);
            URL mletConf = mlet.getResource("jboss.conf");
            Set beans = mlet.getMBeansFromURL(mletConf);
            Iterator iterator = beans.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (obj instanceof RuntimeOperationsException) {
                    ((RuntimeOperationsException)obj).getTargetException().printStackTrace(err);
                    continue;
                }
                if (obj instanceof RuntimeErrorException) {
                    ((RuntimeErrorException)obj).getTargetError().printStackTrace(err);
                    continue;
                }
                if (obj instanceof MBeanException) {
                    ((MBeanException)obj).getTargetException().printStackTrace(err);
                    continue;
                }
                if (obj instanceof RuntimeMBeanException) {
                    ((RuntimeMBeanException)obj).getTargetException().printStackTrace(err);
                    continue;
                }
                if (obj instanceof ReflectionException) {
                    ((ReflectionException)obj).getTargetException().printStackTrace(err);
                    continue;
                }
                if (!(obj instanceof Throwable)) continue;
                ((Throwable)obj).printStackTrace(err);
            }
            server.invoke(new ObjectName(":service=Configuration"), "loadConfiguration", new Object[0], new String[0]);
            server.invoke(new ObjectName(":service=Configuration"), "saveConfiguration", new Object[0], new String[0]);
            server.invoke(new ObjectName(":service=ServiceControl"), "init", new Object[0], new String[0]);
            server.invoke(new ObjectName(":service=ServiceControl"), "start", new Object[0], new String[0]);
        }
        catch (RuntimeOperationsException e) {
            System.out.println("Runtime error");
            e.getTargetException().printStackTrace();
        }
        catch (RuntimeErrorException e) {
            System.out.println("Runtime error");
            e.getTargetError().printStackTrace();
        }
        catch (MBeanException e) {
            e.getTargetException().printStackTrace();
        }
        catch (RuntimeMBeanException e) {
            e.getTargetException().printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long stopTime = System.currentTimeMillis();
        long lapsedTime = stopTime - startTime;
        long minutes = lapsedTime / 60000L;
        long seconds = (lapsedTime - 60000L * minutes) / 1000L;
        long milliseconds = lapsedTime - 60000L * minutes - 1000L * seconds;
        String version = mainPkg.getSpecificationTitle();
        System.out.println(String.valueOf(version) + " Started in " + minutes + "m:" + seconds + "s." + milliseconds);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        Thread.currentThread().setName("JBossMain");
        String cn = "default";
        String patchDir = null;
        int a = 0;
        while (a < args.length) {
            if (args[a].startsWith("-p")) {
                File tst;
                if (!(tst = new File(patchDir = args[++a])).exists()) {
                    throw new IllegalArgumentException("Patch dir: " + tst.getAbsolutePath() + " does not exist");
                }
            } else {
                if (args[a].charAt(0) == '-') {
                    throw new IllegalArgumentException("Usage: [-p <patch_directory>] [<config_name>]");
                }
                cn = args[a];
            }
            ++a;
        }
        final String confName = cn;
        final String patchDirName = patchDir;
        URL jbossProps = (class$org$jboss$Main != null ? class$org$jboss$Main : (class$org$jboss$Main = Main.class$("org.jboss.Main"))).getClassLoader().getResource(String.valueOf(confName) + "/jboss.properties");
        InputStream propertiesIn = (class$org$jboss$Main != null ? class$org$jboss$Main : (class$org$jboss$Main = Main.class$("org.jboss.Main"))).getClassLoader().getResourceAsStream(String.valueOf(confName) + "/jboss.properties");
        if (propertiesIn != null) {
            System.getProperties().load(propertiesIn);
        }
        if (System.getProperty("jboss.home") == null) {
            String path = (class$org$jboss$Main != null ? class$org$jboss$Main : (class$org$jboss$Main = Main.class$("org.jboss.Main"))).getProtectionDomain().getCodeSource().getLocation().getFile();
            File runJar = new File(path);
            File homeDir = new File(runJar.getParent(), "..");
            System.setProperty("jboss.home", homeDir.getCanonicalPath());
        }
        System.out.println("jboss.home = " + System.getProperty("jboss.home"));
        if (System.getProperty("java.security.auth.login.config") == null) {
            URL loginConfig = (class$org$jboss$Main != null ? class$org$jboss$Main : (class$org$jboss$Main = Main.class$("org.jboss.Main"))).getClassLoader().getResource(String.valueOf(confName) + "/auth.conf");
            if (loginConfig != null) {
                System.setProperty("java.security.auth.login.config", loginConfig.toExternalForm());
                System.out.println("Using JAAS LoginConfig: " + loginConfig.toExternalForm());
            } else {
                System.out.println("Warning: no auth.conf found in config=" + confName);
            }
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                new Main(confName, patchDirName);
                return null;
            }
        });
    }

    public static void systemExit(String[] argv) {
        System.exit(0);
    }

    public static class NullURLsMLet
    extends MLet {
        URL[] empty = new URL[0];

        public NullURLsMLet() {
        }

        public NullURLsMLet(URL[] urls) {
            super(urls);
        }

        public URL[] getAllURLs() {
            URL[] allURLs = super.getURLs();
            return allURLs;
        }

        public URL[] getURLs() {
            return this.empty;
        }
    }
}

