/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.io.FileNotFoundException;
import java.net.URL;
import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.security.auth.Policy;
import javax.security.auth.login.Configuration;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.security.SecurityPolicy;
import org.jboss.security.SecurityPolicyParser;
import org.jboss.security.plugins.SecurityPolicyServiceMBean;
import org.jboss.util.ServiceMBeanSupport;

public class SecurityPolicyService
extends ServiceMBeanSupport
implements SecurityPolicyServiceMBean {
    private String jndiName = "DefaultSecurityPolicy";
    private SecurityPolicy securityPolicy;
    private SecurityPolicyParser policySource;
    private String policyFile;
    static /* synthetic */ Class class$org$jboss$naming$NonSerializableFactory;

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getPolicyFile() {
        return this.policyFile;
    }

    public void setPolicyFile(String policyFile) {
        this.policyFile = policyFile;
    }

    public String getName() {
        return "SecurityPolicyService";
    }

    public void startService() throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL policyURL = loader.getResource(this.policyFile);
        if (policyURL == null) {
            throw new FileNotFoundException("Failed to find URL for policy resource: " + this.policyFile);
        }
        System.out.println("Loading policy file from: " + policyURL);
        this.policySource = new SecurityPolicyParser(policyURL);
        this.securityPolicy = new SecurityPolicy(this.policySource);
        this.policySource.refresh();
        InitialContext ctx = new InitialContext();
        NonSerializableFactory.rebind((String)this.jndiName, (Object)((Object)this.securityPolicy));
        String className = ((Object)((Object)this.securityPolicy)).getClass().getName();
        String factory = (class$org$jboss$naming$NonSerializableFactory == null ? (class$org$jboss$naming$NonSerializableFactory = SecurityPolicyService.class$("org.jboss.naming.NonSerializableFactory")) : class$org$jboss$naming$NonSerializableFactory).getName();
        StringRefAddr addr = new StringRefAddr("nns", this.jndiName);
        Reference memoryRef = new Reference(className, addr, factory, null);
        ctx.rebind(this.jndiName, (Object)memoryRef);
        Policy.setPolicy((Policy)this.securityPolicy);
        Configuration.setConfiguration(this.securityPolicy.getLoginConfiguration());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

