/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.jdbc.xa;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.pool.jdbc.xa.XAPoolDataSource;

public class XAPoolDriver
implements Driver {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$pool$jdbc$xa$XAPoolDriver != null ? class$org$jboss$pool$jdbc$xa$XAPoolDriver : (class$org$jboss$pool$jdbc$xa$XAPoolDriver = XAPoolDriver.class$("org.jboss.pool.jdbc.xa.XAPoolDriver"))));
    private static final String URL_START = "jdbc:minerva:xa:";
    private static final XAPoolDriver instance = new XAPoolDriver();
    static /* synthetic */ Class class$org$jboss$pool$jdbc$xa$XAPoolDriver;

    static {
        try {
            DriverManager.registerDriver(XAPoolDriver.instance());
        }
        catch (SQLException e) {
            log.error((Object)"Unable to register Minerva XA DB pool driver!", (Throwable)e);
        }
    }

    private XAPoolDriver() {
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(URL_START);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Connection connect(String url, Properties props) throws SQLException {
        if (url.startsWith(URL_START)) {
            return this.getXAConnection(url.substring(URL_START.length()));
        }
        return null;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    private Connection getXAConnection(String name) {
        Connection con = null;
        try {
            XAPoolDataSource source = XAPoolDataSource.getDataSource(name);
            if (source != null) {
                con = source.getConnection();
            }
        }
        catch (Exception e) {
            log.error((Object)"Can't get DataSource from XAPool", (Throwable)e);
        }
        return con;
    }

    public static XAPoolDriver instance() {
        return instance;
    }

    public boolean jdbcCompliant() {
        return false;
    }
}

