/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.connector.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.DataSource;
import org.jboss.pool.connector.jdbc.JDBCConnectionRequestInfo;

public class JDBCDataSource
implements DataSource,
Serializable,
Referenceable {
    private transient ConnectionManager manager;
    private transient ManagedConnectionFactory factory;
    private transient PrintWriter logger;
    private Reference jndiReference;

    public JDBCDataSource(ConnectionManager manager, ManagedConnectionFactory factory) {
        this.manager = manager;
        this.factory = factory;
    }

    public Connection getConnection() throws SQLException {
        try {
            return (Connection)this.manager.allocateConnection(this.factory, null);
        }
        catch (ResourceException e) {
            throw new SQLException("Unable to get Connection: " + (Object)((Object)e));
        }
    }

    public Connection getConnection(String user, String password) throws SQLException {
        try {
            return (Connection)this.manager.allocateConnection(this.factory, (ConnectionRequestInfo)new JDBCConnectionRequestInfo(user, password));
        }
        catch (ResourceException e) {
            throw new SQLException("Unable to get Connection: " + (Object)((Object)e));
        }
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logger;
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public Reference getReference() {
        return this.jndiReference;
    }

    public void setLogWriter(PrintWriter writer) throws SQLException {
        this.logger = writer;
    }

    public void setLoginTimeout(int timeout) throws SQLException {
        throw new SQLException("Method setLoginTimeout() not implemented.");
    }

    public void setReference(Reference ref) {
        this.jndiReference = ref;
    }
}

