/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.connector.jdbc;

import java.io.PrintWriter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.List;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public abstract class BaseManagedConnection
implements ManagedConnection {
    protected PrintWriter logger;
    protected ArrayList listeners;
    private String user;

    public BaseManagedConnection(String user) {
        this.user = user;
        this.listeners = new ArrayList();
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    public void associateConnection(Object Tx) throws ResourceException {
        throw new ResourceException("associateConnection not supported");
    }

    public abstract void cleanup() throws ResourceException;

    public void destroy() throws ResourceException {
        this.listeners.clear();
        this.listeners = null;
        this.logger = null;
        this.user = null;
    }

    protected void fireConnectionEvent(ConnectionEvent evt) {
        List local = (List)this.listeners.clone();
        int i = local.size() - 1;
        while (i >= 0) {
            if (evt.getId() == 1) {
                ((ConnectionEventListener)local.get(i)).connectionClosed(evt);
            } else if (evt.getId() == 5) {
                ((ConnectionEventListener)local.get(i)).connectionErrorOccurred(evt);
            }
            --i;
        }
    }

    public abstract Object getConnection(Subject var1, ConnectionRequestInfo var2) throws ResourceException;

    public abstract LocalTransaction getLocalTransaction() throws ResourceException;

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logger;
    }

    public abstract ManagedConnectionMetaData getMetaData() throws ResourceException;

    String getUser() {
        return this.user;
    }

    public abstract XAResource getXAResource() throws ResourceException;

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        ((AbstractCollection)this.listeners).remove(listener);
    }

    public void setLogWriter(PrintWriter writer) throws ResourceException {
        this.logger = writer;
    }
}

