/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.connector.jboss;

import java.io.PrintWriter;
import java.util.Properties;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.TransactionManager;
import org.jboss.pool.PoolParameters;
import org.jboss.pool.connector.jboss.JBossSecurityManager;
import org.jboss.pool.connector.jboss.MinervaSharedLocalCM;
import org.jboss.resource.ConnectionManagerFactory;
import org.jboss.resource.ConnectorConfig;
import org.jboss.resource.JBossConnectionManager;
import org.jboss.resource.ResourceSubjectFactory;

public class MinervaSharedLocalCMFactory
implements ConnectionManagerFactory {
    private TransactionManager tm;
    private PrintWriter logger;
    private ResourceSubjectFactory security;
    private MinervaSharedLocalCM manager;

    public JBossConnectionManager addManagedConnectionFactory(ManagedConnectionFactory factory, ConnectorConfig config, String name) {
        MinervaSharedLocalCM cm = null;
        if (!(config.logWriter != null && !config.logWriter.equals(this.logger) || config.tm != null && !config.tm.equals(this.tm) || config.rsf != null && !config.rsf.equals(this.security))) {
            if (this.manager == null) {
                this.manager = new MinervaSharedLocalCM();
                this.manager.setLogWriter(this.logger);
                this.manager.setTransactionManager(this.tm);
                this.manager.setSecurityManager(new JBossSecurityManager(this.security));
            }
            cm = this.manager;
        } else {
            cm = new MinervaSharedLocalCM();
            cm.setLogWriter(config.logWriter == null ? this.logger : config.logWriter);
            cm.setTransactionManager(config.tm == null ? this.tm : config.tm);
            cm.setSecurityManager(new JBossSecurityManager(config.rsf == null ? this.security : config.rsf));
        }
        if (config.listener != null) {
            cm.addJBossConnectionListener(config.listener);
        }
        Properties props = config.properties;
        PoolParameters params = new PoolParameters();
        String s = props.getProperty("Blocking");
        if (s != null) {
            try {
                params.blocking = new Boolean(s);
            }
            catch (Exception exception) {}
        }
        if ((s = props.getProperty("BlockingTimeout")) != null) {
            try {
                params.blockingTimeoutSecs = Integer.parseInt(s);
            }
            catch (Exception exception) {}
        }
        if ((s = props.getProperty("GCEnabled")) != null) {
            try {
                params.gcEnabled = new Boolean(s);
            }
            catch (Exception exception) {}
        }
        if ((s = props.getProperty("GCIntervalMillis")) != null) {
            try {
                params.gcIntervalMillis = Long.parseLong(s);
            }
            catch (Exception exception) {}
        }
        if ((s = props.getProperty("GCMinIdleMillis")) != null) {
            try {
                params.gcMinIdleMillis = Long.parseLong(s);
            }
            catch (Exception exception) {}
        }
        if ((s = props.getProperty("IdleTimeoutEnabled")) != null) {
            try {
                params.idleTimeoutEnabled = new Boolean(s);
            }
            catch (Exception exception) {}
        }
        if ((s = props.getProperty("IdleTimeoutMillis")) != null) {
            try {
                params.idleTimeoutMillis = Long.parseLong(s);
            }
            catch (Exception exception) {}
        }
        if ((s = props.getProperty("InvalidateOnError")) != null) {
            try {
                params.invalidateOnError = new Boolean(s);
            }
            catch (Exception exception) {}
        }
        if ((s = props.getProperty("TimestampUsed")) != null) {
            try {
                params.trackLastUsed = new Boolean(s);
            }
            catch (Exception exception) {}
        }
        if ((s = props.getProperty("MaxIdleTimeoutPercent")) != null) {
            try {
                params.maxIdleTimeoutPercent = new Float(s).floatValue();
            }
            catch (Exception exception) {}
        }
        if ((s = props.getProperty("MaxSize")) != null) {
            try {
                params.maxSize = Integer.parseInt(s);
            }
            catch (Exception exception) {}
        }
        if ((s = props.getProperty("MinSize")) != null) {
            try {
                params.minSize = Integer.parseInt(s);
            }
            catch (Exception exception) {}
        }
        if ((s = props.getProperty("LoggingEnabled")) == null || s.equalsIgnoreCase("true")) {
            params.logger = config.logWriter == null ? this.logger : config.logWriter;
        }
        String configuration = props.getProperty("PoolConfiguration");
        boolean perFactory = true;
        if (configuration != null) {
            if (configuration.equals("per-factory")) {
                perFactory = true;
            } else if (configuration.equals("per-user")) {
                perFactory = false;
            }
        }
        if (perFactory) {
            cm.createPerFactoryPool(factory, params);
        } else {
            cm.createPerUserPool(factory, params);
        }
        return cm;
    }

    public void setLogWriter(PrintWriter writer) {
        this.logger = writer;
    }

    public void setProperties(Properties props) {
    }

    public void setResourceSubjectFactory(ResourceSubjectFactory security) {
        this.security = security;
    }

    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }
}

