/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.connector;

import java.io.PrintWriter;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import org.jboss.pool.ObjectPool;
import org.jboss.pool.PoolObjectFactory;
import org.jboss.pool.connector.ConnectionParameters;

public class ManagedConnectionPoolFactory
extends PoolObjectFactory {
    private ManagedConnectionFactory factory;
    private ObjectPool pool;
    private PrintWriter log;

    public ManagedConnectionPoolFactory(ManagedConnectionFactory factory) {
        this.factory = factory;
        this.log = new PrintWriter(System.out);
    }

    public boolean checkValidObject(Object source, Object parameters) {
        if (parameters == null) {
            return true;
        }
        ConnectionParameters params = (ConnectionParameters)parameters;
        try {
            ManagedConnection test = this.factory.matchManagedConnections((Set)new SingleSet(source), params.subject, params.info);
            return test != null;
        }
        catch (ResourceException resourceException) {
            return false;
        }
    }

    public Object createObject(Object parameters) throws Exception {
        ConnectionParameters params = (ConnectionParameters)parameters;
        try {
            ManagedConnection ob = this.factory.createManagedConnection(params == null ? null : params.subject, params == null ? null : params.info);
            return ob;
        }
        catch (ResourceException e) {
            this.log.println("Unable to create ManagedConnection: " + (Object)((Object)e));
            return null;
        }
    }

    public void deleteObject(Object pooledObject) {
        try {
            ((ManagedConnection)pooledObject).destroy();
        }
        catch (Exception e) {
            this.log.println("deleteObject(): Unable to destroy ManagedConnection: " + e);
        }
    }

    public void poolClosing(ObjectPool pool) {
        super.poolClosing(pool);
        this.factory = null;
        pool = null;
        this.log = null;
    }

    public void poolStarted(ObjectPool pool, PrintWriter log) {
        super.poolStarted(pool);
        this.pool = pool;
        this.log = log;
        if (log == null) {
            log = new PrintWriter(System.out);
        }
    }

    public Object returnObject(Object clientObject) {
        try {
            ((ManagedConnection)clientObject).cleanup();
        }
        catch (ResourceException e) {
            this.log.println("Error cleaning up ManagedConnection:");
            e.printStackTrace(this.log);
            this.pool.markObjectAsInvalid(clientObject);
        }
        return clientObject;
    }

    private static class SingleSet
    extends AbstractSet {
        private Object ob;

        public SingleSet(Object ob) {
            this.ob = ob;
        }

        static /* synthetic */ Object access$0(SingleSet $0) {
            return $0.ob;
        }

        public Iterator iterator() {
            return new Iterator(this){
                private final /* synthetic */ SingleSet this$0;
                int pos;
                {
                    this.this$0 = this$0;
                    this.pos = 0;
                }

                public boolean hasNext() {
                    return this.pos < 1;
                }

                public Object next() {
                    if (this.pos < 1) {
                        ++this.pos;
                        return SingleSet.access$0(this.this$0);
                    }
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public int size() {
            return 1;
        }
    }
}

