/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.connector;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.jboss.pool.ObjectPool;
import org.jboss.pool.PoolParameters;
import org.jboss.pool.connector.ManagedConnectionPoolFactory;
import org.jboss.pool.connector.PoolManager;
import org.jboss.pool.connector.ServerSecurityManager;

public abstract class BaseConnectionManager
implements ConnectionManager {
    public static final String POOL_CONFIGURATION_KEY = "PoolConfiguration";
    public static final String POOL_CONFIG_VALUE_PER_FACTORY = "per-factory";
    public static final String POOL_CONFIG_VALUE_PER_USER = "per-user";
    public static final boolean DEFAULT_POOL_PER_FACTORY = true;
    protected transient PoolManager pools = new PoolManager();
    protected transient Map handles = new HashMap();
    protected transient TransactionManager tm;
    protected transient ServerSecurityManager sec;
    protected transient PrintWriter logger;

    public abstract Object allocateConnection(ManagedConnectionFactory var1, ConnectionRequestInfo var2) throws ResourceException;

    protected void connectionHandleClosed(Object handle) {
        this.handles.remove(handle);
    }

    protected void connectionHandleIssued(Object handle, Object listener) {
        this.handles.put(handle, listener);
    }

    public void createPerFactoryPool(ManagedConnectionFactory factory, PoolParameters params) {
        this.createPerFactoryPool(factory, params, String.valueOf(factory.getClass().getName()) + "-" + (this.pools.getFactoryCount() + 1));
    }

    public void createPerFactoryPool(ManagedConnectionFactory factory, PoolParameters params, String name) {
        this.pools.addPerFactoryPool(factory, new ManagedConnectionPoolFactory(factory), params, name);
    }

    public void createPerUserPool(ManagedConnectionFactory factory, PoolParameters params) {
        this.createPerUserPool(factory, params, String.valueOf(factory.getClass().getName()) + "-" + (this.pools.getFactoryCount() + 1));
    }

    public void createPerUserPool(ManagedConnectionFactory factory, PoolParameters params, String name) {
        this.pools.addPerUserPool(factory, new ManagedConnectionPoolFactory(factory), params, name);
    }

    public PrintWriter getLogWriter() {
        return this.logger;
    }

    public ServerSecurityManager getSecurityManager() {
        return this.sec;
    }

    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    public void setLogWriter(PrintWriter logger) {
        this.logger = logger;
    }

    public void setSecurityManager(ServerSecurityManager sec) {
        this.sec = sec;
    }

    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    public void shutDown() {
        this.pools.clear();
        this.handles.clear();
        this.pools = null;
        this.handles = null;
        this.tm = null;
        this.sec = null;
        this.logger.println(String.valueOf(this.getClass().getName()) + " shut down.");
        this.logger = null;
    }

    protected abstract class ConnectionListener
    implements ConnectionEventListener {
        private int handleCount = 0;
        protected ObjectPool pool;
        protected ManagedConnection con;

        protected ConnectionListener(ObjectPool pool, ManagedConnection con) {
            this.pool = pool;
            this.con = con;
            if (con == null) {
                throw new IllegalArgumentException("How can you manage a null connection?");
            }
        }

        public void addHandle() {
            ++this.handleCount;
        }

        public void clear() {
            try {
                this.con.removeConnectionEventListener((ConnectionEventListener)this);
            }
            catch (Exception exception) {}
            this.pool = null;
            this.con = null;
        }

        public abstract void connectionClosed(ConnectionEvent var1);

        public abstract void connectionErrorOccurred(ConnectionEvent var1);

        public abstract void enlist() throws SystemException, RollbackException;

        protected int getHandleCount() {
            return this.handleCount;
        }

        public ManagedConnection getManagedConnection() {
            return this.con;
        }

        public ObjectPool getPool() {
            return this.pool;
        }

        public abstract void localTransactionCommitted(ConnectionEvent var1);

        public abstract void localTransactionRolledback(ConnectionEvent var1);

        public abstract void localTransactionStarted(ConnectionEvent var1);

        public abstract void register() throws SystemException, RollbackException;

        protected int removeHandle() {
            return --this.handleCount;
        }
    }

    protected class NoTransactionListener
    extends ConnectionListener {
        public NoTransactionListener(ObjectPool pool, ManagedConnection con) {
            super(pool, con);
        }

        private void closeConnection(boolean error) {
            if (this.pool != null) {
                if (error) {
                    this.pool.markObjectAsInvalid(this.con);
                }
                this.pool.releaseObject(this.con);
            } else {
                try {
                    this.con.destroy();
                }
                catch (ResourceException e) {
                    e.printStackTrace();
                }
            }
        }

        public void connectionClosed(ConnectionEvent evt) {
            BaseConnectionManager.this.connectionHandleClosed(evt.getConnectionHandle());
            if (this.removeHandle() == 0) {
                this.closeConnection(false);
                this.clear();
            }
        }

        public void connectionErrorOccurred(ConnectionEvent evt) {
            this.closeConnection(true);
            this.clear();
        }

        public void enlist() throws SystemException, RollbackException {
        }

        public void localTransactionCommitted(ConnectionEvent evt) {
        }

        public void localTransactionRolledback(ConnectionEvent evt) {
        }

        public void localTransactionStarted(ConnectionEvent evt) {
        }

        public void register() throws SystemException, RollbackException {
            this.con.addConnectionEventListener((ConnectionEventListener)this);
        }
    }

    protected class XAListener
    extends ConnectionListener
    implements Synchronization,
    ConnectionEventListener {
        private XAResource xar;
        private Transaction trans;

        public XAListener(ObjectPool pool, ManagedConnection con, Transaction trans, XAResource xar) {
            super(pool, con);
            this.trans = trans;
            this.xar = xar;
            if (con == null) {
                throw new IllegalArgumentException("How can you manage a null connection?");
            }
            if (xar == null || trans == null) {
                throw new IllegalArgumentException("Not allowed to use a listener when there's no transaction!");
            }
        }

        public void afterCompletion(int status) {
            block3: {
                block2: {
                    if (this.getHandleCount() <= 0) break block2;
                    this.trans = null;
                    this.xar = null;
                    break block3;
                }
                if (this.pool != null || this.con == null) break block3;
                try {
                    this.con.destroy();
                }
                catch (ResourceException e) {
                    e.printStackTrace();
                }
            }
        }

        public void beforeCompletion() {
        }

        public void clear() {
            super.clear();
            this.trans = null;
            this.xar = null;
        }

        public void connectionClosed(ConnectionEvent evt) {
            BaseConnectionManager.this.connectionHandleClosed(evt.getConnectionHandle());
            if (this.removeHandle() > 0) {
                return;
            }
            if (this.trans != null) {
                try {
                    this.trans.delistResource(this.xar, 0x4000000);
                }
                catch (SystemException e) {
                    e.printStackTrace();
                }
            }
            if (this.pool != null) {
                ObjectPool mypool = this.pool;
                ManagedConnection mycon = this.con;
                this.clear();
                mypool.releaseObject(mycon);
            } else if (this.trans == null) {
                try {
                    this.con.destroy();
                }
                catch (ResourceException e) {
                    e.printStackTrace();
                }
                this.clear();
            }
        }

        public void connectionErrorOccurred(ConnectionEvent evt) {
            try {
                this.trans.delistResource(this.xar, 0x20000000);
            }
            catch (SystemException e) {
                e.printStackTrace();
            }
            if (this.pool != null) {
                this.pool.markObjectAsInvalid(this.con);
                this.pool.releaseObject(this.con);
            } else {
                try {
                    this.con.destroy();
                }
                catch (ResourceException e) {
                    e.printStackTrace();
                }
            }
            this.clear();
        }

        public void enlist() throws SystemException, RollbackException {
            this.trans.enlistResource(this.xar);
            if (this.pool == null) {
                this.trans.registerSynchronization((Synchronization)this);
            }
        }

        public void localTransactionCommitted(ConnectionEvent evt) {
        }

        public void localTransactionRolledback(ConnectionEvent evt) {
        }

        public void localTransactionStarted(ConnectionEvent evt) {
        }

        public void register() throws SystemException, RollbackException {
            this.enlist();
            this.con.addConnectionEventListener((ConnectionEventListener)this);
        }

        public void updateTransaction(Transaction trans, XAResource xaRes) {
            this.trans = trans;
            this.xar = xaRes;
        }
    }
}

